/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.topology.oracle;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.topology.ArrayReplicationTopoBuilder;
import com.huawei.ism.drm.storage.topology.ReplicaRelation;
import com.huawei.ism.drm.storage.topology.ReplicationLinkSkin;
import com.huawei.ism.drm.topo.element.LunElement;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.twaver.Skin;
import com.huawei.ism.drm.topo.utils.TooltipUtil;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.twaver.IData;
import com.huawei.twaver.Node;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.utils.Sets;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:PolicyTemplate-47")
public class OracleAllFlashTOPOBuilder
extends ArrayReplicationTopoBuilder {
    private static final Log LOGGER = LogFactory.getInstance(OracleAllFlashTOPOBuilder.class);
    private static final Set<Integer> NO_VPANEL_PO_TYPE = new HashSet<Integer>(Arrays.asList(11, 14));
    private static final String UNHEALTH = "-1";
    private static final Set<Integer> PARALLEL_3DC = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Integer[]{5, 6, 27}));
    private static final Set<Integer> PARALLEL_4DC = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Integer[]{36, 59, 41, 43}));

    @Override
    public void buildTopo(TopoBaseContext context) {
        this.checkRootNode(context);
        ProtectGroup pg = context.getProtectGroup();
        Set pgReplicas = pg.getReplicaList();
        this.sortRelation(pg);
        List<ReplicaRelation> relations = this.transform(pg, pgReplicas);
        boolean isParallel = this.isParallel(context.getProtectGroup());
        StringBuilder lunIdList = new StringBuilder();
        Map<String, String> wrapMap = this.initWrapMap(pg);
        this.dealWithReplicaRelations(relations, wrapMap, context, isParallel);
        this.dealWithReplicaPair(wrapMap, context, relations);
        context.setLinkIdList(lunIdList.toString());
    }

    private boolean checkDrStorage(DrStorage drStorage, DrStorage trgDrStorage) {
        return drStorage == null || trgDrStorage == null;
    }

    private void checkRootNode(TopoBaseContext context) {
        if (context == null) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        if (context.getRootNode() == null) {
            this.initialize(context);
        }
    }

    @Override
    protected void sortRelation(ProtectGroup pg) {
        Set pgReplicas = pg.getReplicaList();
        if (pg.getTemplate().getType() != 35 && pg.getTemplate().getType() != 36) {
            return;
        }
        this.sortRelation(pgReplicas);
    }

    private boolean isParallel(ProtectGroup protectGroup) {
        PolicyTemplate template = protectGroup.getTemplate();
        int type = template.getType();
        if (PARALLEL_3DC.contains(type)) {
            return true;
        }
        return PARALLEL_4DC.contains(type) && !ProtectionJobUtil.isHyperMetroInFirstSite((ProtectGroup)protectGroup) && !NO_VPANEL_PO_TYPE.contains(protectGroup.getPoType());
    }

    private void dealWithReplicaRelations(List<ReplicaRelation> relations, Map<String, String> wrapMap, TopoBaseContext context, boolean isParallel) {
        DrStorage trgDrStorage;
        ReplicaRelation relation = relations.get(0);
        String srcSN = relation.getSourceSN();
        String trgSN = relation.getTargetSN();
        DrStorage drStorage = this.changeToDrstorage(this.getDrResource(srcSN));
        if (this.checkDrStorage(drStorage, trgDrStorage = this.changeToDrstorage(this.getDrResource(trgSN)))) {
            return;
        }
        Site srcSite = this.setSite(context, drStorage.getSiteId());
        Site trgSite = this.setSite(context, relation.getRecoverySite());
        List<String> srcResourceIdList = relation.getSourceLuns();
        List sources = this.getResourceListFromDB(srcSite, srcSN, srcResourceIdList);
        List trgLuns = this.getResourceListFromDB(trgSite, trgSN, relation.getTargetLuns());
        List<ReplicationTargetLun> targets = this.getTrgLunListFromDB(srcSite, srcSN, trgSN, relation.getTargetLuns());
        Map<String, StorageResource> srcResourceIDMap = this.getResourceIDMap(sources);
        Map<String, StorageResource> trgResourceIDMap = this.getResourceIDMap(trgLuns);
        Map<String, ReplicationTargetLun> repLunIDMap = this.getReplicationLunIDMap(targets);
        Set schedules = context.getProtectGroup().getTemplate().getSchedules();
        Schedule schedule = TopoServiceUtil.getSchedule((int)relation.getProtectLocation(), (Set)schedules, (ProtectGroup)context.getProtectGroup());
        String scheduleInfo = TooltipUtil.getScheduleInfo((Schedule)schedule);
        HashMap<String, ReplicationRelation> coninstanceIdToGroup = new HashMap<String, ReplicationRelation>();
        Node srcStorageNode = this.addSiteNode(context, drStorage, srcSite, wrapMap);
        this.setWrapMap(wrapMap, isParallel, trgSite);
        Node trgStorageNode = this.addSiteNode(context, trgDrStorage, trgSite, wrapMap);
        for (String srcResourceId : srcResourceIdList) {
            StorageResource source = srcResourceIDMap.get(DrmEnumDefine.ResourceTypeE.LUN.name() + srcResourceId);
            source = this.buildStorageRes(relation, srcResourceId, source);
            String trgLunID = relation.getTargetLunBySource(srcResourceId);
            if (trgLunID == null) continue;
            StorageResource trgSource = trgResourceIDMap.get(DrmEnumDefine.ResourceTypeE.LUN.name() + trgLunID);
            trgSource = this.buildStorageRes(relation, trgLunID, trgSource);
            LunElement trgLunNode = new LunElement((Object)(trgSN + trgLunID), this.changeToLun(trgSource));
            LunElement srcLunNode = new LunElement((Object)(srcSN + srcResourceId), this.changeToLun(source));
            srcLunNode = (Node)context.addChild((IData)srcStorageNode, (IData)srcLunNode);
            trgLunNode = (Node)context.addChild((IData)trgStorageNode, (IData)trgLunNode);
            ReplicationTargetLun repLunInfo = repLunIDMap.get(trgLunID);
            String linkId = this.buidldLinkedId(srcSN, srcResourceId, trgSN, trgLunID);
            ReplicationRelation repliationRelation = this.getReplicationGroup(repLunInfo, relation, coninstanceIdToGroup, srcSite, trgLunID);
            String deviceType = ((IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class)).getStorageType(srcSN);
            context.linkTos((Node)srcLunNode, (Node)trgLunNode, linkId, new Skin[]{new ReplicationLinkSkin(repliationRelation, deviceType, repLunInfo, scheduleInfo)});
        }
    }

    private String buidldLinkedId(String srcSN, String srcLunId, String trgSN, String trgLunId) {
        return srcSN + ":" + srcLunId + ":" + trgSN + ":" + trgLunId;
    }

    private void dealWithReplicaPair(Map<String, String> wrapMap, TopoBaseContext context, List<ReplicaRelation> relations) {
        ProtectGroup pg = context.getProtectGroup();
        List<String> srcLunIds = this.convertToLunIdsList((String)pg.getProps().get("REMOTE_PAIR_SRCLUNIDS"));
        List<String> trgLunIds = this.convertToLunIdsList((String)pg.getProps().get("REMOTE_PAIR_TRGLUNIDS"));
        String srcSN = relations.get(0).getTargetSN();
        String trgSN = relations.get(0).getSourceSN();
        for (int i = 0; i < srcLunIds.size(); ++i) {
            DrStorage trgDrStorage;
            DrStorage drStorage = this.changeToDrstorage(this.getDrResource(srcSN));
            if (this.checkDrStorage(drStorage, trgDrStorage = this.changeToDrstorage(this.getDrResource(trgSN)))) {
                LOGGER.error((Object)"Storage is invalid.");
            }
            String srcLunId = srcLunIds.get(i);
            String trgLunId = trgLunIds.get(i);
            List<String> srcResourceIds = Arrays.asList(srcLunId);
            List<String> trgResourceIds = Arrays.asList(trgLunId);
            List<Lun> srcStorageResources = this.getLunResources(srcSN, srcResourceIds);
            List<Lun> trgStorageResources = this.getLunResources(trgSN, trgResourceIds);
            if (VerifyUtil.isEmpty(srcStorageResources) || VerifyUtil.isEmpty(trgStorageResources)) {
                return;
            }
            Site srcSite = this.setSite(context, drStorage.getSiteId());
            Site trgSite = this.setSite(context, trgDrStorage.getSiteId());
            Node srcStorageNode = this.addSiteNode(context, drStorage, srcSite, wrapMap);
            Node trgStorageNode = this.addSiteNode(context, trgDrStorage, trgSite, wrapMap);
            LunElement srcLunNode = new LunElement((Object)(srcSN + srcLunId), srcStorageResources.get(0));
            LunElement trgLunNode = new LunElement((Object)(trgSN + trgLunId), trgStorageResources.get(0));
            if (srcLunNode != null && trgLunNode != null) {
                srcLunNode = (Node)context.addChild((IData)srcStorageNode, (IData)srcLunNode);
                trgLunNode = (Node)context.addChild((IData)trgStorageNode, (IData)trgLunNode);
            }
            String deviceType = ((IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class)).getStorageType(srcSN);
            List<ReplicationTargetLun> targets = this.getTrgLunListFromDB(srcSite, srcSN, trgSN, trgLunIds);
            Map<String, ReplicationTargetLun> repLunIDMap = this.getReplicationLunIDMap(targets);
            ReplicationTargetLun repLunInfo = repLunIDMap.get(trgLunId);
            HashMap<String, ReplicationRelation> coninstanceIdToGroup = new HashMap<String, ReplicationRelation>();
            ReplicationRelation repliationRelation = this.getReplicationGroup(repLunInfo, relations.get(0), coninstanceIdToGroup, srcSite, trgLunId);
            Set schedules = pg.getTemplate().getSchedules();
            String scheduleInfo = TooltipUtil.getScheduleInfo((Schedule)((Schedule)schedules.iterator().next()));
            String linkId = this.buidldLinkedId(srcSN, srcLunId, trgSN, trgLunId);
            context.linkTos((Node)srcLunNode, (Node)trgLunNode, linkId, new Skin[]{new ReplicationLinkSkin(repliationRelation, deviceType, repLunInfo, scheduleInfo)});
        }
    }

    private List<Lun> getLunResources(String srcSN, List<String> srcResourceIds) {
        return ((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).getStorageResources(srcSN, srcResourceIds, Lun.class);
    }

    private Lun changeToLun(StorageResource source) {
        Lun lun = null;
        if (source instanceof Lun) {
            lun = (Lun)source;
        }
        return lun;
    }

    private DrStorage changeToDrstorage(DrResource drResource) {
        DrStorage drStorage = null;
        if (drResource instanceof DrStorage) {
            drStorage = (DrStorage)drResource;
        }
        return drStorage;
    }

    @Override
    protected Site setSite(TopoBaseContext context, String siteId) {
        String srcSiteId = siteId;
        Site srcSite = context.getSiteService().getSiteById(srcSiteId);
        context.getSiteMaps().put(srcSiteId, srcSite);
        return srcSite;
    }

    @Override
    protected void setWrapMap(Map<String, String> wrapMap, boolean isParallel, Site trgSite) {
        if (isParallel && !wrapMap.containsKey(trgSite.getSiteId())) {
            wrapMap.put(trgSite.getSiteId(), "Replication-Data-Center-Group-1");
        }
    }

    private StorageResource buildStorageRes(ReplicaRelation relation, String srcResourceId, StorageResource source) {
        if (!VerifyUtil.isEmpty((Object)source)) {
            return source;
        }
        Lun storageResource = new Lun();
        storageResource.setResourceId(srcResourceId);
        storageResource.setName("--");
        storageResource.setStatus(Integer.valueOf(-2));
        storageResource.setHealthStatus(UNHEALTH);
        return storageResource;
    }

    private List<String> convertToLunIdsList(String lunIds) {
        if (VerifyUtil.isEmpty((String)lunIds)) {
            LOGGER.warn((Object)"lunIds is empty");
            return Collections.emptyList();
        }
        try {
            LOGGER.info((Object)"Bgein get lunIds from props.");
            return Arrays.asList(lunIds.split(","));
        }
        catch (LegoCheckedException e) {
            return Collections.singletonList(lunIds);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to convert cgUuids to array", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
    }
}

