/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.license.util;

import com.huawei.lego.cbb.license.util.IEsnTool;
import com.huawei.lego.cbb.license.util.SignVerifier;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoCmdUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class EsnToolBase
implements IEsnTool {
    private static final Log LOGGER = LogFactory.getInstance(EsnToolBase.class);
    private static final int VALUE_2 = 2;
    private String toolpath = "";

    public EsnToolBase(String path) {
        this.toolpath = path;
    }

    @Override
    public List<String> getServerEsns() {
        String[] strs;
        String str;
        BufferedReader br;
        Process process;
        ArrayList<String> esnlist;
        block6: {
            esnlist = new ArrayList<String>();
            String executeCmd = this.getExecuteCmd();
            LOGGER.info((Object)"Begin execute query esn command.");
            process = null;
            br = null;
            SignVerifier.getInstance().verify(executeCmd);
            process = Runtime.getRuntime().exec(executeCmd);
            br = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.defaultCharset()));
            str = br.readLine();
            if (LegoCmdUtil.waitProcessExecuteWithTimeout((Process)process) == 0) break block6;
            ArrayList<String> arrayList = esnlist;
            CommonUtil.close((Closeable)br);
            CommonUtil.destroyProcess((Process)process);
            return arrayList;
        }
        try {
            LOGGER.info((Object)"End esn process.");
            if (!"".equals(str) && this.getStrsLens(strs = str.split(":"))) {
                esnlist.add(strs[1]);
                LOGGER.info((Object)String.format(Locale.ENGLISH, "THE ESN: %s.", strs[1]), 1L);
            }
            LOGGER.info((Object)"End getServerEsns");
            strs = esnlist;
        }
        catch (Exception ex) {
            try {
                String msg = String.format(Locale.ROOT, "getServerEsns error: %s.", ExceptionUtil.getErrorMessage((Throwable)ex));
                LOGGER.error((Object)msg);
                throw new LegoUncheckedException(msg);
            }
            catch (Throwable throwable) {
                CommonUtil.close(br);
                CommonUtil.destroyProcess(process);
                throw throwable;
            }
        }
        CommonUtil.close((Closeable)br);
        CommonUtil.destroyProcess((Process)process);
        return strs;
    }

    public abstract String getExecuteCmd();

    private boolean getStrsLens(String[] strs) {
        return strs.length == 2;
    }

    public Log getLogger() {
        return LOGGER;
    }

    public String getToolpath() {
        return this.toolpath;
    }
}

