/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.task.service;

import com.huawei.lego.cbb.task.dao.ITaskDAO;
import com.huawei.lego.cbb.task.dao.ITaskParamerterDAO;
import com.huawei.lego.cbb.task.dao.ITaskResultDAO;
import com.huawei.lego.cbb.task.dao.ITaskTypeDAO;
import com.huawei.lego.cbb.task.manager.ITaskManager;
import com.huawei.lego.cbb.task.sdk.model.Task;
import com.huawei.lego.cbb.task.sdk.model.TaskParameter;
import com.huawei.lego.cbb.task.sdk.model.TaskResult;
import com.huawei.lego.cbb.task.sdk.model.TaskType;
import com.huawei.lego.cbb.task.sdk.service.ITaskService;
import com.huawei.lego.cbb.task.sdk.service.TaskStatus;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoProperties;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;

@Service(name="task", desc="", interfaceClass=ITaskService.class)
public class TaskServiceImpl
extends BaseService
implements ITaskService {
    private static final Log LOGGER = LogFactory.getInstance(TaskServiceImpl.class);
    private static final Log logger = LogFactory.getInstance(TaskServiceImpl.class);
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    private static final int OPTTYPE = 1;
    private static final int EVENTTYPE = 2;
    private static final int TWO_HUNDRED_M = 246579200;
    private ITaskDAO taskDao = null;
    private ITaskManager taskManager = null;
    private ITaskTypeDAO taskTypeDao = null;
    private ITaskResultDAO taskResultDao = null;
    private ITaskParamerterDAO taskParameterDao = null;

    public long addTask(Task task) {
        long taskId = this.taskDao.addTask(task);
        this.taskManager.start(task);
        return taskId;
    }

    public void updateTask(Task task) {
        if (task.getTaskStatus().intValue() != TaskStatus.IDLE.getValue() && task.getTaskStatus().intValue() != TaskStatus.FINISH.getValue()) {
            throw new LegoCheckedException(601L);
        }
        this.taskManager.stop(task);
        this.taskDao.updateTask(task);
        this.taskManager.start(task);
    }

    public void deleteTask(long taskId) {
        Task task = this.taskDao.readTask(taskId);
        if (task.getTaskStatus().intValue() != TaskStatus.IDLE.getValue() && task.getTaskStatus().intValue() != TaskStatus.FINISH.getValue() && task.getTaskStatus().intValue() != TaskStatus.SUSPEND.getValue()) {
            throw new LegoCheckedException(601L);
        }
        this.taskManager.stop(task);
        this.taskDao.deleteTask(task);
    }

    public BatchOperationResult deleteTask(List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        if (list != null && !list.isEmpty()) {
            int operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.deleteTask(batchOperation.getTargetId());
                }
                catch (LegoCheckedException ce) {
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (Exception ex) {
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        }
        LOGGER.debug((Object)"deleteTask:completed,return BatchOperationResult");
        return result;
    }

    public void deleteTaskResult(long taskResultId) {
        this.taskResultDao.deleteTaskResult(taskResultId);
    }

    public Task readTask(long taskId) {
        return this.taskDao.readTask(taskId);
    }

    private void readTask() {
        try {
            Task logTask = this.readTask(1L);
            Task alarmtask = this.readTask(2L);
            if (null != logTask) {
                this.updateTask(logTask);
            }
            if (null != alarmtask) {
                this.updateTask(alarmtask);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"updateTask file fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
    }

    public List<Task> queryTasks(Map<String, Object> condition) {
        return this.taskDao.queryTask(condition);
    }

    public Paging queryTasks(Map<String, Object> condition, int firstRowIndex, int totalRow) {
        return this.taskDao.findPage(condition, firstRowIndex, totalRow);
    }

    public void runTask(long taskId) {
        Task task = this.taskDao.readTask(taskId);
        TaskStatus status = TaskStatus.getTaskState((int)task.getTaskStatus());
        if (!status.equals((Object)TaskStatus.IDLE) && !status.equals((Object)TaskStatus.FINISH)) {
            throw new LegoCheckedException(601L);
        }
        this.taskManager.runAtOnce(task);
    }

    public BatchOperationResult runTask(List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (list != null && !list.isEmpty()) {
            operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.runTask(batchOperation.getTargetId());
                }
                catch (LegoCheckedException ce) {
                    LOGGER.error((Object)"A legochecked exception occured,error msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ce)});
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    LOGGER.error((Object)"A legounckecked exception occured,error msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ue)});
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (Exception ex) {
                    LOGGER.error((Object)"An exception occured,error msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        }
        return result;
    }

    public void suspendTask(long taskId) {
        Task task = this.taskDao.readTask(taskId);
        TaskStatus status = TaskStatus.getTaskState((int)task.getTaskStatus());
        if (!status.equals((Object)TaskStatus.IDLE)) {
            throw new LegoCheckedException(601L);
        }
        this.taskManager.pause(task);
        task.setTaskStatus(Integer.valueOf(TaskStatus.SUSPEND.getValue()));
        this.taskDao.updateTask(task);
    }

    public BatchOperationResult suspendTask(List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operationCount = 0;
        if (list != null && !list.isEmpty()) {
            operationCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.suspendTask(batchOperation.getTargetId());
                }
                catch (LegoCheckedException ce) {
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (Exception ex) {
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operationCount);
            result.setSucceedCount(operationCount - fail);
        }
        LOGGER.debug((Object)"suspendTask:completed,return BatchOperationResult");
        return result;
    }

    public void resumeTask(long taskId) {
        Task task = this.taskDao.readTask(taskId);
        TaskStatus status = TaskStatus.getTaskState((int)task.getTaskStatus());
        if (!status.equals((Object)TaskStatus.SUSPEND)) {
            throw new LegoCheckedException(602L);
        }
        this.taskManager.resume(task);
        task.setTaskStatus(Integer.valueOf(TaskStatus.IDLE.getValue()));
        this.taskDao.updateTask(task);
    }

    public BatchOperationResult resumeTask(List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        if (null != list && !list.isEmpty()) {
            int operationCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.resumeTask(batchOperation.getTargetId());
                }
                catch (LegoCheckedException ce) {
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (Exception ex) {
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operationCount);
            result.setSucceedCount(operationCount - fail);
        }
        LOGGER.debug((Object)"resumeTask:completed,return BatchOperationResult");
        return result;
    }

    public BatchOperationResult deleteTaskResultList(List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        if (this.checkListNotNull(list)) {
            int operationCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.deleteTaskResult(batchOperation.getTargetId());
                }
                catch (LegoCheckedException ce) {
                    LOGGER.error((Object)"A legochecked exception occured,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ce)});
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    LOGGER.error((Object)"A legounchecked exception occured,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ue)});
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (Exception ex) {
                    LOGGER.error((Object)"An exception occured,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            this.readTask();
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operationCount);
            result.setSucceedCount(operationCount - fail);
        }
        return result;
    }

    private boolean checkListNotNull(List<BatchOperation> list) {
        if (list != null && !list.isEmpty()) {
            LOGGER.debug((Object)"checkListNotNull:list is not null");
            return true;
        }
        return false;
    }

    private void deleteFile(int taskType, String fileName) {
        if (fileName == null || "".equals(fileName)) {
            return;
        }
        File currentFile = new File(".");
        String path = "";
        try {
            path = currentFile.getCanonicalPath();
        }
        catch (IOException e1) {
            LOGGER.error((Object)"deleteFile currentfile.getCanonicalPath()", 102L);
        }
        String currentPath = path + File.separator;
        currentPath = currentPath + "datastorage";
        if (taskType == 1) {
            currentPath = currentPath + File.separator + "sysoptlog" + File.separator;
        } else if (taskType == 2) {
            currentPath = currentPath + File.separator + "alarm" + File.separator;
        }
        try {
            File file = new File(currentPath + fileName);
            if (!file.exists()) {
                LOGGER.error((Object)"File path is error, or file not exist!");
                throw new LegoCheckedException(1291L);
            }
            file.deleteOnExit();
            boolean result = file.delete();
            if (!result) {
                LOGGER.error((Object)"Delete file fail,file name is %s.", new Object[]{file.getName()});
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Delete file fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
    }

    public BatchOperationResult deleteFile(int taskType, List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        if (list != null && !list.isEmpty()) {
            int operationCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.deleteFile(taskType, batchOperation.getTargetName());
                }
                catch (LegoCheckedException ce) {
                    LOGGER.error((Object)"A legochecked exception occured,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ce)});
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    LOGGER.error((Object)"A legounchecked exception occured,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ue)});
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (Exception ex) {
                    LOGGER.error((Object)"An exception occured,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operationCount);
            result.setSucceedCount(operationCount - fail);
        }
        return result;
    }

    public Boolean checkFile(int taskType, String fileName) {
        String currentPath = LegoProperties.getStorageFilePath();
        currentPath = currentPath + File.separator + "datastorage";
        if (taskType == 1) {
            currentPath = currentPath + File.separator + "sysoptlog" + File.separator;
        } else if (taskType == 2) {
            currentPath = currentPath + File.separator + "alarm" + File.separator;
        }
        File file = new File(currentPath + fileName);
        if (!file.exists()) {
            LOGGER.error((Object)"CheckFile failed! file is not exist.");
            return false;
        }
        return true;
    }

    public Boolean checkFileSize(int taskType, String fileName) {
        String currentPath = LegoProperties.getStorageFilePath();
        currentPath = currentPath + File.separator + "datastorage";
        if (taskType == 1) {
            currentPath = currentPath + File.separator + "sysoptlog" + File.separator;
        } else if (taskType == 2) {
            currentPath = currentPath + File.separator + "alarm" + File.separator;
        }
        File file = new File(currentPath + fileName);
        if (file.length() > 246579200L) {
            LOGGER.error((Object)"CheckFileSize : file size is too big.");
            return false;
        }
        return true;
    }

    public Boolean nameIsExist(String taskName) {
        return this.taskDao.nameIsExist(taskName);
    }

    public void setTaskDao(ITaskDAO taskDao) {
        this.taskDao = taskDao;
    }

    public void startTask(Task task) {
        this.taskManager.start(task);
    }

    public void startTask(List<Task> tasks) {
        if (tasks != null) {
            for (Task task : tasks) {
                this.startTask(task);
            }
        } else {
            LOGGER.debug((Object)"Tasks is null");
        }
    }

    public List<TaskResult> queryTaskResultList(long taskId) {
        return this.taskResultDao.queryTaskResult(taskId);
    }

    public Paging queryTaskResultList(Long taskId, int firstRowIndex, int totalRow) {
        return this.taskResultDao.queryTaskResult(taskId, firstRowIndex, totalRow);
    }

    public String addTaskType(TaskType type) {
        return this.taskTypeDao.addTaskType(type);
    }

    public List<TaskType> queryTaskTypeList(int type) {
        return this.taskTypeDao.queryTaskType(type);
    }

    public TaskType readTaskType(String taskType) {
        return this.taskTypeDao.readTaskType(taskType);
    }

    public void updateTaskType(TaskType taskType) {
        try {
            this.taskTypeDao.updateTaskType(taskType);
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"Update task type failed, task type is %s.", new Object[]{taskType.getTaskType()});
        }
    }

    public long addTaskResult(TaskResult result) {
        return this.taskResultDao.addTaskResult(result);
    }

    public TaskResult readTaskResult(long resultId) {
        return this.taskResultDao.readTaskResult(resultId);
    }

    public void setTaskResultDao(ITaskResultDAO taskResultDao) {
        this.taskResultDao = taskResultDao;
    }

    public void stopTask(Task task) {
        this.taskManager.stop(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] downLoad(int taskType, String fileName) {
        byte[] content = null;
        BufferedInputStream bis = null;
        ByteArrayOutputStream bos = null;
        String currentPath = LegoProperties.getStorageFilePath();
        currentPath = currentPath + File.separator + "datastorage";
        if (taskType == 1) {
            currentPath = currentPath + File.separator + "sysoptlog" + File.separator;
        } else if (taskType == 2) {
            currentPath = currentPath + File.separator + "alarm" + File.separator;
        }
        File file = new File(currentPath + fileName);
        if (!file.exists()) {
            LOGGER.error((Object)"Download file error! file is not exist.");
            throw new LegoCheckedException(1291L);
        }
        try {
            int bytesRead;
            bis = new BufferedInputStream(new FileInputStream(file));
            bos = new ByteArrayOutputStream(1024);
            byte[] buff = new byte[0x100000];
            while ((bytesRead = bis.read(buff, 0, buff.length)) != -1) {
                bos.write(buff, 0, bytesRead);
            }
            byte[] byArray = content = bos.toByteArray();
            this.releaseResources(bis, bos);
            return byArray;
        }
        catch (IOException e) {
            try {
                logger.error((Object)"Downloading file failed.", (Throwable)e);
                this.releaseResources(bis, bos);
            }
            catch (Throwable throwable) {
                this.releaseResources(bis, bos);
                throw throwable;
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> downLoadLarge(int taskType, String fileName) {
        ArrayList<byte[]> contentList = new ArrayList<byte[]>();
        BufferedInputStream bis = null;
        ByteArrayOutputStream bos = null;
        String currentPath = LegoProperties.getStorageFilePath();
        currentPath = currentPath + File.separator + "datastorage";
        if (taskType == 1) {
            currentPath = currentPath + File.separator + "sysoptlog" + File.separator;
        } else if (taskType == 2) {
            currentPath = currentPath + File.separator + "alarm" + File.separator;
        }
        File file = new File(currentPath + fileName);
        if (!file.exists()) {
            LOGGER.error((Object)"DownLoadLarge error! file is not exist.");
            throw new LegoCheckedException(1291L);
        }
        if (file.length() > 246579200L) {
            LOGGER.error((Object)"DownLoadLarge error! file size is too large to downLoad.");
            throw new LegoCheckedException(1297L);
        }
        try {
            int bytesRead;
            bis = new BufferedInputStream(new FileInputStream(file));
            bos = new ByteArrayOutputStream(0x100000);
            byte[] buff = new byte[0x100000];
            while ((bytesRead = bis.read(buff, 0, buff.length)) != -1) {
                bos = new ByteArrayOutputStream(0x100000);
                bos.write(buff, 0, bytesRead);
                contentList.add(bos.toByteArray());
            }
            ArrayList<byte[]> arrayList = contentList;
            this.releaseResources(bis, bos);
            return arrayList;
        }
        catch (IOException ex) {
            try {
                logger.error((Object)"Downloading file failed,error msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                this.releaseResources(bis, bos);
            }
            catch (Throwable throwable) {
                this.releaseResources(bis, bos);
                throw throwable;
            }
        }
        return contentList;
    }

    private void releaseResources(BufferedInputStream bis, ByteArrayOutputStream bos) {
        CommonUtil.close((Closeable)bis);
        CommonUtil.close((Closeable)bos);
    }

    public TaskParameter queryTaskParameter(long taskId) {
        return this.taskParameterDao.queryTaskParameter(taskId);
    }

    public void updateTaskParameter(TaskParameter taskParameter) {
        this.taskParameterDao.updateTaskParameter(taskParameter);
    }

    public void setTaskParameterDao(ITaskParamerterDAO taskParameterDao) {
        this.taskParameterDao = taskParameterDao;
    }

    public void setTaskManager(ITaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public void setTaskTypeDao(ITaskTypeDAO taskTypeDao) {
        this.taskTypeDao = taskTypeDao;
    }
}

