/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.task.sysjob;

import com.huawei.lego.cbb.task.dao.ITaskDAO;
import com.huawei.lego.cbb.task.dao.ITaskTypeDAO;
import com.huawei.lego.cbb.task.manager.TaskManager;
import com.huawei.lego.cbb.task.sdk.model.Task;
import com.huawei.lego.cbb.task.sdk.model.TaskParameter;
import com.huawei.lego.cbb.task.sdk.model.TaskType;
import com.huawei.lego.cbb.task.sdk.service.TaskCategory;
import com.huawei.lego.cbb.task.sdk.service.TaskPeriodType;
import com.huawei.lego.cbb.task.sdk.service.TaskStatus;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InitDataStorageTask
implements SystemStatusChangedListener {
    private static final Log LOGGER = LogFactory.getInstance(InitDataStorageTask.class);
    private int cycleDate = 120;
    private String reserDate = "90";
    private String filestyleValue = "2";
    private int defaultTimeHour = 2;
    private String sysOptType = "log_bk";
    private String eventType = "alarm_bk";
    private int sysOptTypeId = 1;
    private int eventTypeId = 2;
    private String time = "02:00:00";
    private String langValue = "1";
    private ITaskTypeDAO taskTypeDao;
    private ITaskDAO taskDao;
    private TaskManager taskManager;

    public void init(int taskType) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        String filePath = this.getStorageFilePath(taskType);
        this.getCondition(taskType, condition);
        List<Task> taskList = this.taskDao.queryTask(condition);
        if (this.checkListEmpty(taskList)) {
            Task task = this.getTask(taskType, filePath);
            this.taskDao.addTask(task);
            this.taskManager.start(task);
        } else {
            for (Task task : taskList) {
                this.updateTask(filePath, task);
            }
        }
    }

    private Task getTask(int taskType, String filePath) {
        Task task = new Task();
        TaskType taskTypeTemp = this.readTaskType(taskType, task);
        Date currentDate = new Date();
        Date date = this.getFirstStorageTime();
        if (date != null) {
            task.setBaseTime(date);
        }
        task.setCreateTime(currentDate);
        task.setExecuteType(Integer.valueOf(2));
        task.setIsNotifyFail(Boolean.valueOf(false));
        task.setPeriod(Integer.valueOf(this.cycleDate));
        task.setPeriodtimes(Integer.valueOf(-1));
        task.setPeriodType(Integer.valueOf(TaskPeriodType.DATE.getValue()));
        task.setLastModifyTime(currentDate);
        task.setTaskType(taskTypeTemp);
        task.setCreateUser(Long.valueOf(1L));
        task.setTaskCategory(Integer.valueOf(TaskCategory.SYSTEM.getValue()));
        task.setTaskStatus(Integer.valueOf(TaskStatus.IDLE.getValue()));
        TaskParameter taskParameter = new TaskParameter();
        taskParameter.setParameter1(this.filestyleValue);
        taskParameter.setParameter2(this.reserDate);
        String locale = System.getProperties().getProperty("user.language");
        this.langValue = "zh".equals(locale) ? "2" : "1";
        taskParameter.setParameter3(this.langValue);
        taskParameter.setParameter4(this.time);
        taskParameter.setParameter5(filePath);
        task.setParameter(taskParameter);
        task.setIsNotifyFail(Boolean.valueOf(false));
        task.setIsNotifySuccess(Boolean.valueOf(false));
        task.setIsSendMail(Boolean.valueOf(false));
        task.setIsSendNote(Boolean.valueOf(false));
        task.setBundleName("lego");
        taskParameter.setTask(task);
        return task;
    }

    private void updateTask(String filePath, Task task) {
        TaskParameter taskParameter = task.getParameter();
        taskParameter.setParameter5(filePath);
        task.setParameter(taskParameter);
        this.taskDao.updateTask(task);
    }

    private void getCondition(int taskType, Map<String, Object> condition) {
        condition.put("taskType", "log_bk");
        if (taskType == this.sysOptTypeId) {
            condition.put("taskType", this.sysOptType);
        } else if (taskType == this.eventTypeId) {
            condition.put("taskType", this.eventType);
        }
    }

    private TaskType readTaskType(int taskType, Task task) {
        TaskType taskTypeTemp = null;
        if (taskType == this.sysOptTypeId) {
            task.setTaskName("SystemOptStorage");
            taskTypeTemp = this.taskTypeDao.readTaskType(this.sysOptType);
        } else if (taskType == this.eventTypeId) {
            task.setTaskName("EventOptStorage");
            taskTypeTemp = this.taskTypeDao.readTaskType(this.eventType);
        }
        return taskTypeTemp;
    }

    private boolean checkListEmpty(List<Task> taskList) {
        return taskList == null || taskList.isEmpty();
    }

    private Date getFirstStorageTime() {
        Date firstRunTime = null;
        SimpleDateFormat formatH = new SimpleDateFormat("H");
        SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date nextDay = new Date();
        int hour = NumberUtil.convertToInteger((Object)formatH.format(nextDay));
        Calendar cal = Calendar.getInstance();
        if (hour >= this.defaultTimeHour) {
            cal.add(5, this.cycleDate + 1);
            nextDay = cal.getTime();
        } else {
            cal.add(5, this.cycleDate);
            nextDay = cal.getTime();
        }
        try {
            firstRunTime = dateFormat.parse(formatDay.format(nextDay) + " " + this.time);
        }
        catch (ParseException e) {
            LOGGER.error((Object)"ParseException ", (Throwable)e, 1L);
        }
        return firstRunTime;
    }

    private String getStorageFilePath(int taskType) {
        String currentPath = LegoProperties.getStorageFilePath();
        if (taskType == this.sysOptTypeId) {
            currentPath = currentPath + "datastorage" + File.separator + "sysoptlog";
        } else if (taskType == this.eventTypeId) {
            currentPath = currentPath + "datastorage" + File.separator + "alarm";
        }
        return currentPath;
    }

    public ITaskTypeDAO getTaskTypeDao() {
        return this.taskTypeDao;
    }

    public void setTaskTypeDao(ITaskTypeDAO taskTypeDao) {
        this.taskTypeDao = taskTypeDao;
    }

    public ITaskDAO getTaskDao() {
        return this.taskDao;
    }

    public void setTaskDao(ITaskDAO taskDao) {
        this.taskDao = taskDao;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public void setTaskManager(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public void afterPropertiesSet() {
        this.init(this.sysOptTypeId);
        this.init(this.eventTypeId);
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            this.afterPropertiesSet();
        }
    }
}

