/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.internal.jms;

import com.google.common.collect.ImmutableList;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SecureObjectInputStream
extends ObjectInputStream {
    private static final Log LOGGER = LogFactory.getInstance(SecureObjectInputStream.class);
    private static final String KEY_SECURE_CLASS = "deserialization.secure.class";
    private static final String KEY_SECURE_PACKAGE = "deserialization.secure.package";
    private List<String> secureClassList = ImmutableList.of((Object)"com.huawei.lego.comm.internal.jms.MessageUnit", (Object)"com.huawei.lego.comm.internal.jms.MessageTopic", (Object)"java.io.Serializable.OpenStackStoragePoolRemoteDevInfo", (Object)"java.sql.Timestamp", (Object)"org.apache.commons.collections.map.HashedMap", (Object)"[B", (Object)"[Lcom.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;", (Object)"[Ljava.lang.String;");
    private List<String> securePackageList = ImmutableList.of((Object)"com.huawei.ism.drm.protection.group.sdk.model", (Object)"com.huawei.ism.drm.protection.replica.sdk.model", (Object)"com.huawei.lego.core.system.notify.sdk.model", (Object)"com.huawei.ism.drm.application.sdk.model", (Object)"com.huawei.ism.drm.app.sdk.model", (Object)"com.huawei.ism.database.db2.sdk.model", (Object)"com.huawei.ism.database.oracle.sdk.model", (Object)"com.huawei.ism.database.opengauss.sdk.model", (Object)"com.huawei.ism.database.sdk.model", (Object)"com.huawei.ism.database.sqlserver.sdk.model", (Object)"com.huawei.ism.host.sdk.model.Host", (Object)"com.huawei.ism.drm.kube.sdk.model", (Object[])new String[]{"com.huawei.ism.host.sdk.model.HostFileSystem", "com.huawei.ism.drm.virtualization.sdk.model", "com.huawei.ism.drm.vsphere.sdk.model", "com.huawei.lego.nem.fault.sdk.model", "com.huawei.lego.cbb.resource.sdk.model", "com.huawei.lego.nem.discover.sdk.model", "com.huawei.lego.com.south.sdk.model", "com.huawei.lego.cbb.backtask.sdk.model", "com.huawei.ism.drm.openstack.sdk.model", "com.huawei.ism.drm.openstack.sdk.msg", "com.huawei.ism.drm.common.sdk.model", "com.huawei.ism.drm.drp.sdk.model", "com.huawei.ism.drm.system.info.sdk.model", "com.huawei.ism.drm.report.sdk.model", "com.huawei.ism.drm.protection", "com.huawei.ism.drm.openstack.model", "com.huawei.ism.drm.site.sdk.model", "com.huawei.ism.drm.galax.sdk.model", "com.huawei.ism.base.sdk.model", "org.hibernate.collection.internal", "com.huawei.ism.array.sdk.model", "com.huawei.ism.drm.storage.sdk.model", "com.huawei.ism.unistor.sdk.model", "com.huawei.ism.base.port.sdk.model", "java.util", "java.lang"});
    private long configUpdateTime = 0L;
    private ClassLoader classLoader;

    public SecureObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public SecureObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
        super(inputStream);
        this.classLoader = classLoader;
    }

    protected SecureObjectInputStream() throws IOException, SecurityException {
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        this.reloadProperties();
        boolean isClassSecure = this.secureClassList.stream().anyMatch(className -> className.equals(desc.getName()));
        if (!(isClassSecure |= this.securePackageList.stream().anyMatch(packageName -> desc.getName().startsWith((String)packageName)))) {
            LOGGER.error((Object)"ResolveClass failed. cause %s is not secure Class", new Object[]{desc.getName()});
            throw new ClassNotFoundException("ResolveClass failed. cause " + desc.getName() + " is not secure Class");
        }
        try {
            return super.resolveClass(desc);
        }
        catch (ClassNotFoundException e) {
            return Class.forName(desc.getName(), true, this.classLoader);
        }
    }

    private void reloadProperties() {
        List<String> securePackageConfigList;
        if (this.configUpdateTime >= LegoBaseConfig.getInstance().getUpdateTime()) {
            return;
        }
        List<String> secureClassConfigList = this.getSecureConfigList(KEY_SECURE_CLASS);
        if (!secureClassConfigList.isEmpty()) {
            this.secureClassList = secureClassConfigList;
        }
        if (!(securePackageConfigList = this.getSecureConfigList(KEY_SECURE_PACKAGE)).isEmpty()) {
            this.securePackageList = securePackageConfigList;
        }
        this.configUpdateTime = LegoBaseConfig.getInstance().getUpdateTime();
    }

    private List<String> getSecureConfigList(String proKey) {
        String secureValue = LegoBaseConfig.getInstance().getKeyValue(proKey);
        if (VerifyUtil.isEmpty((String)secureValue)) {
            LOGGER.info((Object)"proKey:%s of legoConfig is empty", new Object[]{proKey});
            return Collections.emptyList();
        }
        LOGGER.info((Object)"proKey:%s of legoConfig read success", new Object[]{proKey});
        return Arrays.asList(secureValue.split(","));
    }
}

