/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.internal.jms.messagemanager;

import com.huawei.lego.com.internal.ProductName;
import com.huawei.lego.comm.internal.jms.messagecodebase.CommandCodeBase;
import com.huawei.lego.comm.internal.jms.messagecodebase.MessageCodeRegisterException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MessageChecker {
    private static final Log LOGGER = LogFactory.getInstance(MessageChecker.class);
    private Map<ProductName, MessageLimitS> messSegmentFilter = new HashMap<ProductName, MessageLimitS>();

    public MessageChecker() {
        try {
            Field[] fds = CommandCodeBase.class.getDeclaredFields();
            List pns = ProductName.values();
            long base = 0L;
            long max = 0L;
            int index = 0;
            for (int i = 0; i < fds.length; ++i) {
                if ((i + 1) % 2 != 0) {
                    base = fds[i].getLong(CommandCodeBase.class);
                    continue;
                }
                max = fds[i].getLong(CommandCodeBase.class);
                MessageLimitS mls = new MessageLimitS();
                mls.setBase(base);
                mls.setMax(max);
                this.messSegmentFilter.put((ProductName)pns.get(index), mls);
                ++index;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    public boolean judgeSpecialMessage(long code, String pn) {
        try {
            this.judgeSpecialMessageCode(pn, code);
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Register's code is:-%s.", code));
            return true;
        }
        catch (Exception mcre) {
            String failInfo = "----- Product:" + pn + ",Command:" + code + "----- register messagecodes is failed! --MessageCode isn't criterion!";
            LOGGER.error((Object)"register failed,msg :%s. ", new Object[]{failInfo});
            return false;
        }
    }

    public void judgeSpecialMessageCode(String productname, long messcode) {
        block6: {
            try {
                String proname = productname;
                ProductName pn = ProductName.fromString((String)proname);
                if (null != pn) {
                    MessageLimitS mls = this.messSegmentFilter.get(pn);
                    if (mls == null) {
                        return;
                    }
                    long base = mls.getBase();
                    long max = mls.getMax();
                    if (base >= messcode && max < messcode) {
                        String errorinfo = "the productname is: " + proname + ". messagecode segment is from " + base + " to " + max + " --but current messagecode is: " + messcode;
                        throw new MessageCodeRegisterException(errorinfo);
                    }
                    break block6;
                }
                String errorinfo = "the productname isn't registed!! ";
                throw new MessageCodeRegisterException(errorinfo);
            }
            catch (MessageCodeRegisterException mcre) {
                LOGGER.error((Object)"MessageCodeRegisterException when judgeSpecialMessageCode.", (Throwable)((Object)mcre), 1L);
                throw mcre;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Other Exception when judgeSpecialMessageCode,error :%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new MessageCodeRegisterException("Other Exception when judgeSpecialMessageCode: " + ExceptionUtil.getErrorMessage((Throwable)e));
            }
        }
    }

    private static class MessageLimitS {
        private long base = 0L;
        private long max = 0L;

        private MessageLimitS() {
        }

        public long getBase() {
            return this.base;
        }

        public void setBase(long base) {
            this.base = base;
        }

        public long getMax() {
            return this.max;
        }

        public void setMax(long max) {
            this.max = max;
        }
    }
}

