/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.cache.local;

import com.huawei.lego.core.sdk.base.ICacheService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class LocalCacheImpl
implements ICacheService<String, Object> {
    private static final int NUM_1000 = 1000;
    private static final Log LOGGER = LogFactory.getInstance(LocalCacheImpl.class);
    private ConcurrentHashMap<String, Object>[] caches;
    private ConcurrentHashMap<String, Long> expiryCache;
    private ConcurrentHashMap<String, Integer> intervalCache;
    private ConcurrentHashMap<String, Integer> saveToCache;
    private ScheduledExecutorService scheduleService;
    private int expiryInterval = 10;
    private int moduleSize = 10;

    public LocalCacheImpl() {
        this.init();
    }

    public LocalCacheImpl(int expiryInterval, int moduleSize) {
        this.expiryInterval = expiryInterval;
        this.moduleSize = moduleSize;
        this.init();
    }

    private void init() {
        this.caches = new ConcurrentHashMap[this.moduleSize];
        int index = 0;
        while (index < this.moduleSize) {
            this.caches[index++] = new ConcurrentHashMap();
        }
        this.expiryCache = new ConcurrentHashMap();
        this.intervalCache = new ConcurrentHashMap();
        this.saveToCache = new ConcurrentHashMap();
        this.scheduleService = Executors.newScheduledThreadPool(1);
        this.scheduleService.scheduleAtFixedRate(new CheckOutOfDateSchedule(this.caches, this.expiryCache), 0L, (long)this.expiryInterval * 60L, TimeUnit.SECONDS);
        LOGGER.info((Object)"Local Cache CheckService is start!", 1L);
    }

    public boolean clear() {
        if (!VerifyUtil.isEmpty((Object[])this.caches)) {
            for (ConcurrentHashMap<String, Object> cache : this.caches) {
                cache.clear();
            }
        }
        if (!VerifyUtil.isEmpty(this.expiryCache)) {
            this.expiryCache.clear();
        }
        if (this.intervalCache != null) {
            this.intervalCache.clear();
        }
        return true;
    }

    public boolean containsKey(String key) {
        this.checkValidate(key);
        return this.getCache(key).containsKey(key);
    }

    public boolean containsKey(String key, boolean updateTime) {
        this.checkValidates(key);
        return this.getCache(key).containsKey(key);
    }

    public Object get(String key) {
        this.checkValidate(key);
        return this.getCache(key).get(key);
    }

    public Object get(String key, boolean updateTime) {
        this.checkValidates(key);
        return this.getCache(key).get(key);
    }

    public Set<String> keySet() {
        this.checkAll();
        return this.expiryCache.keySet();
    }

    public Set<String> keySet(boolean updateTime) {
        this.checkAll();
        return this.expiryCache.keySet();
    }

    public Object put(String key, Object value) {
        Object result = this.getCache(key).put(key, value);
        this.expiryCache.put(key, -1L);
        return result;
    }

    public Object put(String key, Object value, Date expiry) {
        Date now = new Date();
        int ttl = (int)(expiry.getTime() - now.getTime()) / 1000;
        this.saveToCache.put(key, ttl);
        return this.put(key, value, ttl);
    }

    public Object put(String key, Object value, int ttl) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, ttl);
        this.expiryCache.put(key, calendar.getTime().getTime());
        this.intervalCache.put(key, ttl);
        Object result = this.getCache(key).put(key, value);
        return result;
    }

    public Object remove(String key) {
        Object result = this.getCache(key).remove(key);
        this.expiryCache.remove(key);
        this.intervalCache.remove(key);
        return result;
    }

    public int size() {
        this.checkAll();
        return this.expiryCache.size();
    }

    public int size(boolean updateTime) {
        this.checkAlls();
        return this.expiryCache.size();
    }

    public Collection<Object> values() {
        this.checkAll();
        ArrayList<Object> values = new ArrayList<Object>();
        if (!VerifyUtil.isEmpty((Object[])this.caches)) {
            for (ConcurrentHashMap<String, Object> cache : this.caches) {
                values.addAll(cache.values());
            }
        }
        return values;
    }

    public Collection<Object> values(boolean updateTime) {
        this.checkAlls();
        ArrayList<Object> values = new ArrayList<Object>();
        for (ConcurrentHashMap<String, Object> cache : this.caches) {
            values.addAll(cache.values());
        }
        return values;
    }

    private ConcurrentHashMap<String, Object> getCache(String key) {
        int hashCode = key.hashCode();
        if (hashCode < 0) {
            hashCode = -hashCode;
        }
        return this.caches[hashCode % this.moduleSize];
    }

    private void checkValidate(String key) {
        if (null == key) {
            return;
        }
        Long date = this.expiryCache.get(key);
        if (date != null && date != -1L && new Date(date).before(new Date())) {
            this.getCache(key).remove(key);
            this.expiryCache.remove(key);
            this.intervalCache.remove(key);
            if (null != this.saveToCache && this.saveToCache.get(key) != null) {
                this.saveToCache.remove(key);
            }
        } else {
            if (null != this.saveToCache && this.saveToCache.get(key) != null) {
                return;
            }
            Integer ttl = this.intervalCache.get(key);
            if (ttl == null) {
                return;
            }
            Object value = this.getCache(key).get(key);
            this.put(key, value, (int)ttl);
        }
    }

    private void checkValidates(String key) {
        Long date;
        if (key != null && (date = this.expiryCache.get(key)) != null && date != -1L && new Date(date).before(new Date())) {
            this.getCache(key).remove(key);
            this.expiryCache.remove(key);
            this.intervalCache.remove(key);
        }
    }

    private void checkAll() {
        for (String key : this.expiryCache.keySet()) {
            this.checkValidate(key);
        }
    }

    private void checkAlls() {
        for (String key : this.expiryCache.keySet()) {
            this.checkValidates(key);
        }
    }

    public void destroy() {
        try {
            this.clear();
            if (!VerifyUtil.isEmpty((Object)this.scheduleService)) {
                this.scheduleService.shutdown();
            }
            this.scheduleService = null;
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Method destroy,error :%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        LOGGER.info((Object)"Destory local cache resources.");
    }

    public void decreaseCachedDataCount(String key) {
    }

    public void increaseCachedDataCount(String key) {
    }

    class CheckOutOfDateSchedule
    implements Runnable {
        private ConcurrentHashMap<String, Object>[] caches;
        private ConcurrentHashMap<String, Long> expiryCache;

        CheckOutOfDateSchedule(ConcurrentHashMap<String, Object>[] caches, ConcurrentHashMap<String, Long> expiryCache) {
            this.expiryCache = expiryCache;
            this.caches = caches;
        }

        @Override
        public void run() {
            try {
                for (ConcurrentHashMap<String, Object> cache : this.caches) {
                    Iterator<String> keys = ((ConcurrentHashMap.KeySetView)cache.keySet()).iterator();
                    if (keys == null) continue;
                    this.traversalCaches(cache, keys);
                }
            }
            catch (Exception ex) {
                LOGGER.info((Object)"Local Cache CheckService is start!", 1L);
            }
        }

        private void traversalCaches(ConcurrentHashMap<String, Object> cache, Iterator<String> keys) {
            while (keys.hasNext()) {
                String key = keys.next();
                Long date = this.expiryCache.get(key);
                if (date == null || date <= 0L || !new Date(date).before(new Date())) continue;
                this.doRemoveCache(cache, key);
            }
        }

        private void doRemoveCache(ConcurrentHashMap<String, Object> cache, String key) {
            if (LocalCacheImpl.this.saveToCache.containsKey(key)) {
                LocalCacheImpl.this.saveToCache.remove(key);
            }
            LocalCacheImpl.this.intervalCache.remove(key);
            this.expiryCache.remove(key);
            cache.remove(key);
        }
    }
}

