/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.persistance.dao;

import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.base.persistance.dao.ICommonDao;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class CommonDaoImpl
extends HibernateDaoSupportWrapper
implements ICommonDao {
    private static final Log LOGGER = LogFactory.getInstance(CommonDaoImpl.class);

    @Override
    public Serializable save(Object entity) {
        return super.getHibernateTemplate().save(entity);
    }

    @Override
    public void saveOrUpdate(Object entity) {
        super.getHibernateTemplate().saveOrUpdate(entity);
    }

    @Override
    public void saveAll(Set<?> entity) {
        for (Object obj : entity) {
            super.getHibernateTemplate().saveOrUpdate(obj);
        }
    }

    @Override
    public void delete(Object entity) {
        super.getHibernateTemplate().delete(entity);
    }

    @Override
    public void deleteAll(List<?> list) {
        super.getHibernateTemplate().deleteAll(list);
    }

    @Override
    public void update(Object entity) {
        super.getHibernateTemplate().update(entity);
    }

    @Override
    public Object get(Class<?> entityClass, Serializable id) {
        return super.getHibernateTemplate().get(entityClass, id);
    }

    @Override
    public List<?> findPage(String hql, int firstRowIndex, int totalRow) {
        HibernateTemplate tmp = this.getHibernateTemplate();
        return (List)tmp.execute(session -> {
            Query q = session.createQuery(hql);
            q.setFirstResult(firstRowIndex);
            q.setMaxResults(totalRow);
            return q.list();
        });
    }

    @Override
    public List<?> findPage(String hql, int firstRowIndex, int totalRow, Map<Integer, String> param) {
        HibernateTemplate tmp = this.getHibernateTemplate();
        return (List)tmp.execute(session -> {
            Query q = session.createQuery(hql);
            Set entrySet = param.entrySet();
            for (Map.Entry entry : entrySet) {
                Integer key = (Integer)entry.getKey();
                String value = (String)entry.getValue();
                q.setString(key.intValue(), value);
            }
            q.setFirstResult(firstRowIndex);
            q.setMaxResults(totalRow);
            return q.list();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTotalCount(String hql, Map<Integer, String> param) {
        Session session = null;
        Query query = null;
        Long totalCount = 0L;
        try {
            session = this.getSessionFactory().getCurrentSession();
            query = session.createQuery(hql);
            Set<Map.Entry<Integer, String>> entrys = param.entrySet();
            for (Map.Entry<Integer, String> entry : entrys) {
                query.setString(entry.getKey().intValue(), entry.getValue());
            }
            totalCount = (Long)query.uniqueResult();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception when query database, error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            HibernateUtil.closeSession(session);
        }
        return totalCount;
    }

    @Override
    public List<?> findByHql(String hql) {
        return super.getHibernateTemplate().find(hql, new Object[0]);
    }

    @Override
    public List<?> findByHql(String hql, Map<Integer, String> param) {
        HibernateTemplate tmp = this.getHibernateTemplate();
        return (List)tmp.execute(session -> {
            Query query = session.createQuery(hql);
            Set entrys = param.entrySet();
            for (Map.Entry entry : entrys) {
                query.setString(((Integer)entry.getKey()).intValue(), (String)entry.getValue());
            }
            return query.list();
        });
    }

    @Override
    public List<?> findByHql(String hql, Object[] params) {
        return super.getHibernateTemplate().find(hql, params);
    }

    @Override
    public int updateByHql(String hql) {
        return super.getHibernateTemplate().bulkUpdate(hql, new Object[0]);
    }

    @Override
    public int updateByHql(String hql, Object[] param) {
        return super.getHibernateTemplate().bulkUpdate(hql, param);
    }

    @Override
    public List<?> findBySql(String sql, Object ... params) {
        HibernateTemplate tmp = this.getHibernateTemplate();
        return (List)tmp.execute(session -> {
            NativeQuery query = session.createSQLQuery(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    query.setParameter(i, params[i]);
                }
            }
            return query.list();
        });
    }

    @Override
    public int updateBySql(String sql) {
        HibernateTemplate tmp = this.getHibernateTemplate();
        return (Integer)tmp.execute(session -> session.createSQLQuery(sql).executeUpdate());
    }

    @Override
    public int updateBySql(String sql, Object[] param) {
        HibernateTemplate tmp = this.getHibernateTemplate();
        return (Integer)tmp.execute(session -> {
            NativeQuery sqlQuery = session.createSQLQuery(sql);
            for (int i = 0; i < param.length; ++i) {
                sqlQuery.setParameter(i, param[i]);
            }
            return sqlQuery.executeUpdate();
        });
    }

    @Override
    public HibernateTemplate getBaseHibernateTemplate() {
        return super.getHibernateTemplate();
    }
}

