/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.persistance.ds;

import com.huawei.lego.core.base.framework.container.IDataSourceInitializer;
import com.huawei.lego.core.base.persistance.initializer.HibernateConfigurationBuilder;
import com.huawei.lego.core.base.persistance.initializer.HibernateInitializer;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class DBConfigInitalizer
implements IDataSourceInitializer {
    private static final String SYSTEM_REPORTER_DATASOURCE_CONFIG_FILE = "systemconf.properties";
    private static final String EXTENSION_DB_NAME = "db.name";
    private static final String EXTENSION_POINT_DATASOURCE = "com.huawei.lego.orm.hibernate.ds";
    private static final Log LOG = LogFactory.getInstance(DBConfigInitalizer.class);
    private String dbName = "";
    private String dbPropertiesFileName = "";
    private String hbmFileNames = "";
    private HibernateConfigurationBuilder builder;

    public void setBuilder(HibernateConfigurationBuilder builder) {
        this.builder = builder;
    }

    @Override
    public boolean initialize() {
        this.init();
        return true;
    }

    private void init() {
        Properties properties = this.loadDataSourceConfigFile(SYSTEM_REPORTER_DATASOURCE_CONFIG_FILE);
        this.dbName = properties.getProperty(EXTENSION_DB_NAME);
        this.dbPropertiesFileName = properties.getProperty(EXTENSION_POINT_DATASOURCE);
        this.hbmFileNames = properties.getProperty("com.huawei.lego.orm.hibernate.hbm");
        HibernateInitializer datasourceInitializer = this.builder.createInitializer(EXTENSION_POINT_DATASOURCE);
        HibernateInitializer configInitializer = this.builder.createInitializer("com.huawei.lego.orm.hibernate.hbm");
        if (datasourceInitializer != null) {
            datasourceInitializer.initConfiguration(this.dbName, this.dbPropertiesFileName);
        }
        if (configInitializer != null) {
            configInitializer.initConfiguration(this.dbName, this.hbmFileNames);
        }
        this.builder.buildAllSessionFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadDataSourceConfigFile(String fileName) {
        Properties properties = new Properties();
        InputStream is = null;
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            if (cl != null) {
                is = cl.getResourceAsStream(fileName);
                properties.load(is);
            }
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"can not find the datasource config file, error:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        catch (IOException e) {
            LOG.error((Object)"can not load the datasource config file, error:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Close the datasource config file failed");
                }
            }
        }
        return properties;
    }

    @Override
    public void destroy() {
    }
}

