/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.util;

import com.huawei.lego.core.base.util.ConverterUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

class LegoDBProperties {
    public static final String MYSQL = "mysql";
    public static final String SQLSERVER = "sqlserver";
    private static final Log LOGGER = LogFactory.getInstance(ConverterUtil.class);
    private static final String LEGO_PROPERTIES = "lego.properties";
    private static final Properties PROPS = new Properties();

    LegoDBProperties() {
    }

    public static String getDBType() {
        String dbType = MYSQL;
        String value = PROPS.getProperty("hibernate.connection.url");
        if (value != null && value.toLowerCase(Locale.ROOT).contains(SQLSERVER)) {
            dbType = SQLSERVER;
        }
        return dbType;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        InputStream ins = null;
        ClassLoader classLoader = LegoDBProperties.class.getClassLoader();
        if (classLoader != null) {
            ins = classLoader.getResourceAsStream(LEGO_PROPERTIES);
        }
        if (ins != null) {
            PROPS.load(ins);
        }
        if (ins == null) return;
        try {
            ins.close();
            return;
        }
        catch (IOException e) {
            LOGGER.error((Object)"Close default.properties fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return;
        catch (IOException e) {
            try {
                LOGGER.error((Object)"Read default.properties fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                if (ins == null) return;
            }
            catch (Throwable throwable) {
                if (ins == null) throw throwable;
                try {
                    ins.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    LOGGER.error((Object)"Close default.properties fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e2)});
                }
                throw throwable;
            }
            try {
                ins.close();
                return;
            }
            catch (IOException e3) {
                LOGGER.error((Object)"Close default.properties fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e3)});
            }
            return;
        }
    }
}

