/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.domain.context;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Messages;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Locale;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class BaseContext
implements Serializable {
    protected static final boolean DEBUG = false;
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getInstance(BaseContext.class);

    public void initContextField(BaseContext ctx, Element element) {
        Iterator iterator = element.attributeIterator();
        while (iterator.hasNext()) {
            Attribute attr = (Attribute)iterator.next();
            try {
                this.processClassField(ctx, attr);
            }
            catch (SecurityException e) {
                LOG.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)e, 1L);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e, 1L);
            }
        }
    }

    private void processClassField(BaseContext ctx, Attribute attr) throws IllegalAccessException {
        Field field;
        block6: {
            field = null;
            try {
                field = ctx.getClass().getDeclaredField(attr.getName());
            }
            catch (NoSuchFieldException e) {
                if (attr.getName().equalsIgnoreCase("bundle")) break block6;
                LOG.info((Object)String.format(Locale.ENGLISH, "%s %s.", attr.getName(), Messages.getMessage((String)"MODEL_ATTRIBUTE_NOT_DEFINE")), 1L);
            }
        }
        if (field != null) {
            field.setAccessible(true);
            if (field.getType() == String.class) {
                String value = attr.getValue();
                if (value.contains(";")) {
                    field.set(ctx, value.split(";"));
                } else {
                    field.set(ctx, value);
                }
            }
        }
    }

    public Log getLog() {
        return LOG;
    }
}

