/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.domain.service;

import com.huawei.lego.core.domain.context.ModelServiceMapping;
import com.huawei.lego.core.domain.context.ProductContext;
import com.huawei.lego.core.domain.context.ServiceContext;
import com.huawei.lego.core.domain.service.AbsDaoService;
import com.huawei.lego.core.domain.service.AbsServiceEnhancer;
import com.huawei.lego.core.sdk.base.structure.IService;
import com.huawei.lego.core.sdk.domain.IManager;
import com.huawei.lego.core.sdk.domain.exception.ServiceNotFoundException;
import com.huawei.lego.core.sdk.domain.exception.ServiceNotMatchedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Messages;
import java.lang.reflect.InvocationTargetException;

public abstract class AbsMoManager
implements IManager {
    private static final Log LOGGER = LogFactory.getInstance(AbsMoManager.class);
    private ModelServiceMapping ctxMapping;
    private ProductContext pContext;

    public AbsMoManager setProductContext(ProductContext context) {
        this.pContext = context;
        return this;
    }

    public AbsMoManager setCtxMappings(ModelServiceMapping ctxMappings) {
        this.ctxMapping = ctxMappings;
        return this;
    }

    public ServiceAndEnhancer getServiceAndEnhancer(String moSrvName) {
        ServiceAndEnhancer reValue = null;
        if (this.ctxMapping != null) {
            ServiceContext[] srvCtxs = this.ctxMapping.getServiceCtxs();
            ServiceContext targetService = null;
            for (ServiceContext srvCtx : srvCtxs) {
                if (!srvCtx.getServiceName().equalsIgnoreCase(moSrvName)) continue;
                targetService = srvCtx;
                break;
            }
            reValue = this.processReval(targetService);
        }
        return reValue;
    }

    private ServiceAndEnhancer processReval(ServiceContext targetService) {
        ServiceAndEnhancer reValue = null;
        if (targetService != null) {
            try {
                Object service = targetService.getServiceClass().newInstance();
                this.validServiceType(service);
                Object enhancer = targetService.getEnhancer().getConstructors()[0].newInstance(service);
                reValue = new ServiceAndEnhancer((AbsServiceEnhancer)enhancer, (IService)service);
            }
            catch (InstantiationException e) {
                LOGGER.error((Object)e, 1L);
            }
            catch (IllegalAccessException e) {
                LOGGER.error((Object)e, 1L);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error((Object)e, 1L);
            }
            catch (SecurityException e) {
                LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
            }
            catch (InvocationTargetException e) {
                LOGGER.error((Object)e, 1L);
            }
        }
        return reValue;
    }

    private void validServiceType(Object service) {
        if (!(service instanceof IService)) {
            throw new ServiceNotMatchedException(Messages.getMessage((String)"SERVICE_NOT_MATCHED"));
        }
        if (service instanceof AbsDaoService) {
            ((AbsDaoService)service).setProductContext(this.pContext);
        }
    }

    public IService getMOSerivce(String moSrvName) {
        ServiceAndEnhancer srv = this.getServiceAndEnhancer(moSrvName);
        if (srv != null) {
            return srv.getService();
        }
        throw new ServiceNotFoundException(Messages.getMessage((String)"SERVICE_NOT_FOUND"));
    }

    public AbsServiceEnhancer getEnhancedService(String srvName) {
        ServiceAndEnhancer srv = this.getServiceAndEnhancer(srvName);
        if (srv != null) {
            return srv.getEnhander();
        }
        throw new ServiceNotFoundException(Messages.getMessage((String)"SERVICE_NOT_FOUND"));
    }

    public static class ServiceAndEnhancer {
        private AbsServiceEnhancer enhander;
        private IService service;

        public ServiceAndEnhancer(AbsServiceEnhancer enhander, IService service) {
            this.enhander = enhander;
            this.service = service;
        }

        public AbsServiceEnhancer getEnhander() {
            return this.enhander;
        }

        public IService getService() {
            return this.service;
        }
    }
}

