/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.mediation.nepoll;

import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.mediation.nepoll.PollPlugin;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.Serializable;
import java.util.HashMap;

public class PingPoll
implements Serializable {
    private static final long serialVersionUID = 312499003263152431L;
    private static final int STATUS_ONLINE = 0;
    private static final int STATUS_OFFLINE = -1;
    private static final Log logger = LogFactory.getInstance(PingPoll.class);
    private long moId;
    private String moIP;
    private String moName;
    private boolean isFirstTime = true;
    private boolean isOnline = true;

    public PingPoll(long moId, String moIp, String moName) {
        this.moId = moId;
        this.moIP = moIp;
        this.moName = moName;
    }

    public void sendOffLineMsg() {
        try {
            logger.warn((Object)"Ping %s is not reachable.", new Object[]{this.moIP});
            if (this.isOnline) {
                HashMap<Long, Integer> msg = new HashMap<Long, Integer>();
                msg.put(this.moId, -1);
                MessageUnit mu = new MessageUnit();
                mu.setCmdcode(109L);
                mu.setObj(msg);
                mu.setMt(MessageTopic.COMMAND);
                mu.setSourceAppName(this.getClass().getName());
                IMessageCenter mc = PollPlugin.getInstance().getMc();
                mc.sendMessage(mu);
                this.isOnline = false;
                this.isFirstTime = false;
                logger.info((Object)"Send mo offline message success and generate a offline alarm, moId: %s, moIP: %s.", new Object[]{this.getMoId(), this.moIP});
            }
        }
        catch (Exception e) {
            logger.error((Object)"Send mo offline message and generate offline alarm failed, moId: %s , moIP: %s.%s", new Object[]{this.getMoId(), this.moIP, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    public void sendOnLineMsg() {
        logger.debug((Object)"Ping %s is not reachable.", new Object[]{this.moIP});
        HashMap<Long, Integer> msg = new HashMap<Long, Integer>();
        msg.put(this.getMoId(), 0);
        if (this.isFirstTime) {
            MessageUnit mu = new MessageUnit();
            mu.setCmdcode(110L);
            mu.setObj(msg);
            mu.setMt(MessageTopic.COMMAND);
            mu.setSourceAppName(this.getClass().getName());
            IMessageCenter mc = PollPlugin.getInstance().getMc();
            mc.sendMessage(mu);
            this.isFirstTime = false;
            this.isOnline = true;
            logger.info((Object)"Send mo online message and generate a offline restore alarm,moId:%s ,moIP: %s.", new Object[]{this.getMoId(), this.moIP});
            return;
        }
        try {
            if (!this.isOnline) {
                MessageUnit mu = new MessageUnit();
                mu.setCmdcode(110L);
                mu.setObj(msg);
                mu.setMt(MessageTopic.COMMAND);
                mu.setSourceAppName(this.getClass().getName());
                IMessageCenter mc = PollPlugin.getInstance().getMc();
                mc.sendMessage(mu);
                this.isOnline = true;
                logger.info((Object)"Send mo online message and generate a offline restore alarm, moId: %s, moIP:%s.", new Object[]{this.getMoId(), this.moIP});
            }
        }
        catch (Exception e) {
            logger.error((Object)"Send mo offline message and generate offline restore alarm failed, moId: %s, moIP: %s,%s.", new Object[]{this.getMoId(), this.moIP, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    public long getMoId() {
        return this.moId;
    }

    public void setMoId(long moId) {
        this.moId = moId;
    }

    public String getMoIP() {
        return this.moIP;
    }

    public void setMoIP(String moIp) {
        this.moIP = moIp;
    }

    public String getMoName() {
        return this.moName;
    }

    public void setMoName(String moName) {
        this.moName = moName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.moIP == null ? 0 : this.moIP.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PingPoll other = (PingPoll)obj;
        return other.getMoId() == this.getMoId();
    }

    public String toString() {
        return "moId: " + this.moId + ", moIP:" + this.moIP + ", moName: " + this.moName;
    }
}

