/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.discover.service;

import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.base.structure.ICallback;
import com.huawei.lego.core.sdk.base.structure.ILifecycle;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.nem.discover.sdk.model.ProductsCustomizeInfo;
import com.huawei.lego.nem.discover.sdk.service.IProductsCustomizeService;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@Service(name="ProductsCustomizeServiceImpl", desc="", interfaceClass=IProductsCustomizeService.class)
public class ProductsCustomizeServiceImpl
extends BaseService
implements IProductsCustomizeService,
ILifecycle {
    private static final Log LOGGER = LogFactory.getInstance(ProductsCustomizeServiceImpl.class);
    private String customizeseFile = "resources" + File.separator + "products" + File.separator + "customizese" + File.separator + "discover.properties";
    private ProductsCustomizeInfo customizeInfo;

    public ProductsCustomizeInfo getProductsCustomizeInfo() {
        return this.customizeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Properties props = new Properties();
        File file = new File(".");
        String path = "";
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error((Object)"init getCanonicalPath() error!", 102L);
        }
        String currentPath = path + File.separator;
        currentPath = currentPath + this.customizeseFile;
        File productsFile = new File(currentPath);
        if (productsFile.exists()) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(productsFile);
                props.load(inputStream);
                this.initCustomizeInfo(props);
            }
            catch (FileNotFoundException fe) {
                LOGGER.error((Object)("file not found" + ExceptionUtil.getErrorMessage((Throwable)fe)), 1L);
            }
            catch (IOException iex) {
                LOGGER.error((Object)"IOException", (Throwable)iex, 1L);
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Exception" + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
            }
            finally {
                props.clear();
                CommonUtil.close((Closeable)inputStream);
            }
        }
    }

    private void initCustomizeInfo(Properties props) {
        this.customizeInfo = new ProductsCustomizeInfo();
        String productsName = "";
        String productsNameKey = "productsname";
        productsName = props.getProperty(productsNameKey);
        this.customizeInfo.setProductsName(productsName);
        String key = "";
        String value = "";
        Map customizeParameters = this.customizeInfo.getCustomizeParameters();
        Set<Map.Entry<Object, Object>> keySet = props.entrySet();
        for (Map.Entry<Object, Object> obj : keySet) {
            key = obj.getKey().toString();
            value = props.getProperty(key);
            customizeParameters.put(key, value);
        }
    }

    public void initialize(List<ICallback> callback) {
        this.init();
    }

    public String getPropertiesProductName() {
        return LegoProperties.getProperty((String)"customProductname", (String)"");
    }
}

