/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.msg.listener;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.DateFormatUtil;
import com.huawei.lego.nem.fault.msg.FaultListener;
import com.huawei.lego.nem.fault.msg.listener.FaultHandlerContainer;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.Annotation;
import com.huawei.lego.nem.fault.sdk.model.Event;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class AlarmForwardListener
implements FaultListener {
    private static final Log LOGGER = LogFactory.getInstance(AlarmForwardListener.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Annotation annotation = null;

    @Override
    public synchronized void processAlarm(Alarm alarm) {
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessAlarm in ProductAlarmListener, entity: %s.", alarm.getEntity()), 1L);
        this.sendNotifyMsg(alarm);
    }

    @Override
    public void processRestoreAlarm(Alarm restoredAlarm) {
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessRestoreAlarm in ProductAlarmListener, entity: %s.", restoredAlarm.getEntity()), 1L);
        this.sendNotifyMsg(restoredAlarm);
    }

    @Override
    public synchronized void processConfirm(Alarm alarm) {
    }

    @Override
    public synchronized void processAntiConfirm(Alarm alarm) {
    }

    @Override
    public void processEvent(Event event) {
    }

    @Override
    public void processManuClearAlarm(Alarm alarm) {
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessManuClearAlarm in ProductAlarmListener, entity: %s.", alarm.getEntity()), 1L);
        this.sendNotifyMsg(alarm);
    }

    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    private void sendNotifyMsg(Alarm alarm) {
        StringBuffer bufferv = new StringBuffer();
        bufferv.append("publish alarm in webnms:");
        bufferv.append(alarm.getAlarmName());
        bufferv.append('/');
        bufferv.append(alarm.getSeverity());
        bufferv.append('/');
        bufferv.append(alarm.getMoName());
        bufferv.append('/');
        bufferv.append(DateFormatUtil.format((DateFormat)this.sdf, (Object)alarm.getModTime()));
        LOGGER.debug((Object)bufferv.toString(), 1L);
        FaultHandlerContainer.notify(alarm, this.annotation);
    }
}

