/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.msg.listener;

import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.DateFormatUtil;
import com.huawei.lego.nem.fault.launcher.impl.MsgSubscribeLauncher;
import com.huawei.lego.nem.fault.msg.FaultListener;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.Event;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.util.FaultUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class AlarmInformListener
implements FaultListener {
    private static final Log LOGGER = LogFactory.getInstance(AlarmInformListener.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public synchronized void processAlarm(Alarm alarm) {
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessAlarm in AlarmInformListener, entity: %s.", alarm.getEntity()), 1L);
        this.sendNotifyMsg(alarm);
    }

    @Override
    public void processRestoreAlarm(Alarm restoredAlarm) {
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessRestoreAlarm in AlarmInformListener, entity: %s.", restoredAlarm.getEntity()), 1L);
        this.sendNotifyMsg(restoredAlarm);
    }

    @Override
    public synchronized void processConfirm(Alarm alarm) {
    }

    @Override
    public synchronized void processAntiConfirm(Alarm alarm) {
    }

    @Override
    public void processManuClearAlarm(Alarm alarm) {
    }

    @Override
    public void processEvent(Event event) {
    }

    private void sendNotifyMsg(Alarm alarm) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("publish alarm in webnms:");
        buffer.append(alarm.getAlarmName());
        buffer.append('/');
        buffer.append(alarm.getSeverity());
        buffer.append('/');
        buffer.append(alarm.getMoName());
        buffer.append('/');
        buffer.append(DateFormatUtil.format((DateFormat)this.sdf, (Object)alarm.getModTime()));
        LOGGER.debug((Object)buffer.toString(), 1L);
        MessageUnit mu = new MessageUnit();
        mu.setCmdcode(5006L);
        mu.setObj(alarm);
        mu.setMt(MessageTopic.DATA);
        mu.setSourceAppName(this.getClass().getName());
        MsgSubscribeLauncher.getMc().sendMessage(mu);
        if (alarm.getMoId() == 0L) {
            return;
        }
        LegoAlarm legoAlarm = FaultUtil.alarmToLegoAlarm(alarm);
        if (null == legoAlarm) {
            return;
        }
        MessageUnit cloudServiceMu = new MessageUnit();
        cloudServiceMu.setCmdcode(5021L);
        cloudServiceMu.setObj(legoAlarm);
        cloudServiceMu.setMt(MessageTopic.DATA);
        cloudServiceMu.setSourceAppName(this.getClass().getName());
        MsgSubscribeLauncher.getMc().sendMessage(cloudServiceMu);
    }
}

