/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.discovery.process;

import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.SwitchoverEnum;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindow;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class HvsAirGapRunningModePoller
implements IPoller {
    private static final Log LOGGER = LogFactory.getInstance(HvsAirGapRunningModePoller.class);
    private final String uuid;
    private final String pollerType;

    public HvsAirGapRunningModePoller(String uuid, String pollerType) {
        this.uuid = uuid;
        this.pollerType = pollerType;
    }

    public String getPollerID() {
        return this.uuid;
    }

    public String getPollerType() {
        return this.pollerType;
    }

    public void run() {
        this.checkAndSetAutoTimeWindows();
    }

    private void checkAndSetAutoTimeWindows() {
        List list = CommonDAOLocator.getBaseDao().find("from ResourceTimeWindow", new Object[0]);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        for (Object obj : list) {
            if (!(obj instanceof ResourceTimeWindow)) continue;
            ResourceTimeWindow timeWindow = (ResourceTimeWindow)obj;
            long curTime = System.currentTimeMillis();
            if (timeWindow.getSwitchoverEnum() != SwitchoverEnum.MAINTENANCE || curTime - timeWindow.getLastSwitchOnTime() < 86400000L) continue;
            resourceService.switchoverTimeWindows(timeWindow.getResourceId(), timeWindow.getWindowId(), false, true);
            LOGGER.info((Object)"switchover time window to Automatic open/close mode");
        }
    }
}

