/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.discovery.process;

import com.google.common.collect.ImmutableList;
import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class OracleAllFlashAdgCheckPoller
implements IPoller {
    private static final Log LOGGER = LogFactory.getInstance(OracleAllFlashAdgCheckPoller.class);
    private static final Long ADMIN_USER_ID = 1L;
    private static final List<Integer> NORMAL_STATUS_LIST = ImmutableList.of((Object)DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus(), (Object)DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
    private final String uuid;
    private final String pollerType;

    public OracleAllFlashAdgCheckPoller(String uuid, String pollerType) {
        this.uuid = uuid;
        this.pollerType = pollerType;
    }

    public String getPollerID() {
        return this.uuid;
    }

    public String getPollerType() {
        return this.pollerType;
    }

    public void run() {
        List protectGroups = QueryProtectGroupRefineService.getInstance().queryProtectGroups(ADMIN_USER_ID);
        if (VerifyUtil.isEmpty((Collection)protectGroups)) {
            return;
        }
        protectGroups.removeIf(protectGroup -> protectGroup.getTemplate().getType() != 47);
        if (VerifyUtil.isEmpty((Collection)protectGroups)) {
            LOGGER.debug((Object)"ProtectGroups are empty.");
            return;
        }
        protectGroups.forEach(protectGroup -> {
            if (!NORMAL_STATUS_LIST.contains(protectGroup.getStatus())) {
                return;
            }
            String[] params = new String[]{(String)protectGroup.getProps().get("DB_NAMES"), protectGroup.getName()};
            LOGGER.debug((Object)"Begin check adg status at %s", new Object[]{this.getClass().getSimpleName()});
            try {
                this.checkAdgStatus((ProtectGroup)protectGroup);
                AlarmReporter.restoreAlarm((String)"0x3230099", (String[])params);
            }
            catch (LegoCheckedException e) {
                String ipAddr = "--";
                if (e.getErrorCode() == 1073948515L && !VerifyUtil.isEmpty((Object[])e.getParameters()) && e.getParameters().length == 2) {
                    ipAddr = e.getParameters()[1];
                }
                params = new String[]{params[0], params[1], ipAddr};
                LOGGER.error((Object)"Fail to check adg status at: %s", new Object[]{protectGroup.getName()});
                AlarmReporter.sendAlarm((String)"0x3230099", (String)protectGroup.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])params);
            }
            LOGGER.debug((Object)"End check adg status at %s", new Object[]{this.getClass().getSimpleName()});
        });
    }

    private void checkAdgStatus(ProtectGroup protectGroup) {
        Set poList = protectGroup.getPolist();
        poList.forEach(po -> {
            po.getProps().put("QUERY_TYPE", "0");
            this.checkAdgNodeOfPo((ProtectObject)po);
        });
    }

    private void checkAdgNodeOfPo(ProtectObject po) {
        List<ProtectObject> tempPo = this.createNodeOfPo(po);
        IApplicationManager applicationManager = ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType());
        tempPo.forEach(arg_0 -> ((IApplicationManager)applicationManager).checkEnvStatus(arg_0));
    }

    private List<ProtectObject> createNodeOfPo(ProtectObject po) {
        ArrayList<ProtectObject> poList = new ArrayList<ProtectObject>();
        int proType = NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE"));
        if (DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue() == proType) {
            String instanceConfig = (String)po.getProps().get("INSTANCENAME");
            if (VerifyUtil.isEmpty((String)instanceConfig)) {
                LOGGER.error((Object)"Instance config not found: poName=%s", new Object[]{po.getName()});
                return Collections.emptyList();
            }
            JSONArray instanceArray = JSONArray.fromObject((Object)instanceConfig);
            for (Object obj : instanceArray) {
                JSONObject jsonObject = JSONObject.fromObject(obj);
                String instanceName = jsonObject.getString("INSTANCENAME", "");
                String hostSn = jsonObject.getString("ip", "");
                if (VerifyUtil.isEmpty((String)instanceName) || VerifyUtil.isEmpty((String)hostSn)) continue;
                ProtectObject newPo = new ProtectObject();
                newPo.getProps().putAll(po.getProps());
                newPo.setProviderSN(hostSn);
                newPo.setPoType(1);
                newPo.getProps().put("INSTANCENAME", instanceName);
                newPo.getProps().put("PROVIDER_TYPE", String.valueOf(DrmEnumDefine.ProviderTypeE.HOST.getValue()));
                newPo.getProps().put("hostSn", hostSn);
                poList.add(newPo);
            }
        } else {
            poList.add(po);
        }
        return poList;
    }
}

