/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.discovery.proxy;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HvsDeviceQuery {
    private int index;
    private int count;
    private Map<String, Object> filters;

    public String buildParam() {
        return Stream.of(this.buildRange(), this.buildFilter()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("&"));
    }

    public String appendTo(String url) {
        String param = this.buildParam();
        if (VerifyUtil.isEmpty((String)param)) {
            return url;
        }
        String delimiter = url.contains("?") ? "&" : "?";
        return String.join((CharSequence)delimiter, url, param);
    }

    private Optional<String> buildRange() {
        if (this.count == 0) {
            return Optional.empty();
        }
        String range = String.format(Locale.ENGLISH, "[%s-%s]", this.index, this.index + this.count);
        return Optional.of("range=" + this.encode(range));
    }

    private Optional<String> buildFilter() {
        if (VerifyUtil.isEmpty(this.filters)) {
            return Optional.empty();
        }
        String condition = this.filters.entrySet().stream().map(this::buildFilter).collect(Collectors.joining(" and "));
        return Optional.of("filter=" + this.encode(condition));
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException neverHappenException) {
            throw new LegoCheckedException(1073947393L, (Throwable)neverHappenException);
        }
    }

    private String buildFilter(Map.Entry<String, Object> entry) {
        Object value = entry.getValue();
        String param = value instanceof Collection ? JSONArray.fromObject((Object)value).toString() : ":" + value;
        String field = entry.getKey();
        return field + ":" + param;
    }

    HvsDeviceQuery(int index, int count, Map<String, Object> filters) {
        this.index = index;
        this.count = count;
        this.filters = filters;
    }

    public static HvsDeviceQueryBuilder builder() {
        return new HvsDeviceQueryBuilder();
    }

    public int getIndex() {
        return this.index;
    }

    public int getCount() {
        return this.count;
    }

    public Map<String, Object> getFilters() {
        return this.filters;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setFilters(Map<String, Object> filters) {
        this.filters = filters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HvsDeviceQuery)) {
            return false;
        }
        HvsDeviceQuery other = (HvsDeviceQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        Map<String, Object> this$filters = this.getFilters();
        Map<String, Object> other$filters = other.getFilters();
        return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HvsDeviceQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        result = result * 59 + this.getCount();
        Map<String, Object> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        return result;
    }

    public String toString() {
        return "HvsDeviceQuery(index=" + this.getIndex() + ", count=" + this.getCount() + ", filters=" + this.getFilters() + ")";
    }

    public static class HvsDeviceQueryBuilder {
        private int index;
        private int count;
        private Map<String, Object> filters;

        HvsDeviceQueryBuilder() {
        }

        public HvsDeviceQueryBuilder index(int index) {
            this.index = index;
            return this;
        }

        public HvsDeviceQueryBuilder count(int count) {
            this.count = count;
            return this;
        }

        public HvsDeviceQueryBuilder filters(Map<String, Object> filters) {
            this.filters = filters;
            return this;
        }

        public HvsDeviceQuery build() {
            return new HvsDeviceQuery(this.index, this.count, this.filters);
        }

        public String toString() {
            return "HvsDeviceQuery.HvsDeviceQueryBuilder(index=" + this.index + ", count=" + this.count + ", filters=" + this.filters + ")";
        }
    }
}

