/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.storage.handler.IStorageBackupPlanHandler;
import com.huawei.ism.drm.storage.hvs.handler.impl.AbstractRestStorageHandler;
import com.huawei.ism.drm.storage.sdk.model.BackupPlan;
import com.huawei.ism.drm.storage.sdk.model.BackupTask;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageBackupPlanHandlerImpl
extends AbstractRestStorageHandler
implements IStorageBackupPlanHandler {
    protected Map<String, String> constructCreatePlanParameter(BackupPlan backupPlan) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)backupPlan)) {
            logger.error((Object)"constructCreatePlanParameter Parameter error,BackupPlan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String backupPlanName = backupPlan.getName();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)backupPlanName)) {
            logger.error((Object)"constructCreatePlanParameter Parameter error, backupPlanName is null.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            paramMap.put("NAME", StringUtil.substr((String)backupPlanName, (int)Math.min(31, backupPlanName.getBytes("UTF-8").length), (String)"UTF-8"));
        }
        catch (Exception e) {
            logger.error((Object)"constructCreatePlanParameter Parameter error, backupPlanName is \"%s\".", new Object[]{backupPlanName});
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        paramMap.put("activated", String.valueOf(backupPlan.getActivated()));
        paramMap.put("dataLayout", String.valueOf(backupPlan.getDataLayout()));
        paramMap.put("onceDate", String.valueOf(backupPlan.getOnceDate()));
        paramMap.put("repositoryName", backupPlan.getRepositoryName());
        paramMap.put("retentionType", String.valueOf(backupPlan.getRetentionType()));
        paramMap.put("retryEnable", String.valueOf(backupPlan.getRetryEnable()));
        if (backupPlan.getRetryEnable().booleanValue()) {
            paramMap.put("retry", String.valueOf(backupPlan.getRetryTimes()));
            paramMap.put("retryDuration", String.valueOf(backupPlan.getRetryDuration()));
        }
        paramMap.put("scheduleType", String.valueOf(backupPlan.getScheduleType()));
        return paramMap;
    }

    protected Map<String, String> constructModifyPlanParameter(BackupPlan backupPlan) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)backupPlan)) {
            logger.error((Object)"construct modify backupPlan Parameter error, BackupPlan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Boolean retryEnable = backupPlan.getRetryEnable();
        if (null != retryEnable) {
            paramMap.put("retryEnable", String.valueOf(retryEnable));
            if (retryEnable.booleanValue()) {
                paramMap.put("retry", String.valueOf(backupPlan.getRetryTimes()));
                paramMap.put("retryDuration", String.valueOf(backupPlan.getRetryDuration()));
            }
        }
        return paramMap;
    }

    private BackupPlan transitionBackupPlan(Map<String, String> resultMap) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(resultMap)) {
            logger.error((Object)"transitionBackupPlan parameter error, input param is null");
            throw new LegoCheckedException(1073947393L);
        }
        BackupPlan backupPlan = new BackupPlan();
        backupPlan.setId(resultMap.get("ID"));
        backupPlan.setName(resultMap.get("NAME"));
        backupPlan.setLastRunStatus(NumberUtil.convertToInteger((Object)resultMap.get("lastRunStatus")));
        backupPlan.setRepositoryName(resultMap.get("repositoryName"));
        backupPlan.setActivated(NumberUtil.convertToInteger((Object)resultMap.get("activated")));
        backupPlan.setDataLayout(NumberUtil.convertToInteger((Object)resultMap.get("dataLayout")));
        backupPlan.setRetentionType(NumberUtil.convertToInteger((Object)resultMap.get("retentionType")));
        Boolean retryEnable = Boolean.valueOf(resultMap.get("retryEnable"));
        backupPlan.setRetryEnable(retryEnable);
        if (retryEnable.booleanValue()) {
            backupPlan.setRetryTimes(NumberUtil.convertToInteger((Object)resultMap.get("retry")));
            backupPlan.setRetryDuration(NumberUtil.convertToInteger((Object)resultMap.get("retryDuration")));
        }
        backupPlan.setScheduleType(NumberUtil.convertToInteger((Object)resultMap.get("scheduleType")).intValue());
        backupPlan.setOfflineTransferStatus(BackupPlan.OFFLINE_TRANSFER_STATUS_ENUM.getStatus((int)NumberUtil.convertToInteger((Object)resultMap.get("offlineTransEnabled"))));
        return backupPlan;
    }

    public BackupPlan createBackupPlan(BackupPlan info) {
        if (null == info) {
            logger.error((Object)"create BackupPlan error param, param is null.");
            throw new LegoCheckedException(1073947393L);
        }
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{info.getDevSn(), info.getName()});
        Map<String, String> paramMap = this.constructCreatePlanParameter(info);
        String url = "/rest/${deviceID}/backup_plan/";
        try {
            RestConnection connection = this.getConnection(info.getDevSn());
            logger.debug((Object)"Post createBackupPlan: url = %s, param = %s", new Object[]{url, paramMap});
            Map map = connection.post(url, paramMap);
            logger.debug((Object)"Post createBackupPlan, response = %s", new Object[]{map.toString()});
            BackupPlan result = this.transitionBackupPlan(map);
            result.setDevSn(info.getDevSn());
            return result;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("create backupPlan failed. url = " + url + ", param = " + paramMap), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("create backupPlan failed. url = " + url + ", param = " + paramMap), (Throwable)e);
            throw new LegoCheckedException("create backupPlan failed." + info.toString(), (Throwable)e);
        }
    }

    public void addLun(String devSn, String backupPlanId, String lunId, String wwn) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn, backupPlanId, lunId});
        logger.debug((Object)"add lun to backupPlan. devSn is %s, backupPlanId is %s, lunId is %s", new Object[]{devSn, backupPlanId, lunId});
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ID", backupPlanId);
        paramMap.put("associateObjType", String.valueOf(XveMOType.LUN.getValue()));
        paramMap.put("associateObjID", lunId);
        JSONObject wwnJsonObject = new JSONObject();
        wwnJsonObject.put((Object)"wwn", (Object)wwn);
        paramMap.put("associateMetadata", wwnJsonObject.toString());
        paramMap.put("type", String.valueOf(XveMOType.CLOUDBACKUP_PLAN.getValue()));
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/backup_plan/create_associate/";
        try {
            logger.debug((Object)"Post addLun: url = %s, param = %s", new Object[]{url, paramMap});
            connection.post(url, paramMap);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("add lun to backupPlan failed. url  = " + url + ", paramMap = " + paramMap), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("add lun to backupPlan failed. url  = " + url + ", paramMap = " + paramMap), (Throwable)e);
            throw new LegoCheckedException("add lun to backupPlan failed.", (Throwable)e);
        }
    }

    public void removeLun(String devSn, String backupPlanId, String lunId, String wwn) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn, backupPlanId, lunId});
        logger.debug((Object)"remove lun from BackupPlan. devSn: %s, planId: %s, lunId: %s .", new Object[]{devSn, backupPlanId, lunId});
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ID", backupPlanId);
        paramMap.put("associateObjType", String.valueOf(XveMOType.LUN.getValue()));
        paramMap.put("associateObjID", lunId);
        JSONObject wwnJsonObject = new JSONObject();
        wwnJsonObject.put((Object)"wwn", (Object)wwn);
        paramMap.put("associateMetadata", wwnJsonObject.toString());
        paramMap.put("type", String.valueOf(XveMOType.CLOUDBACKUP_PLAN.getValue()));
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/backup_plan/remove_associate/";
        try {
            logger.debug((Object)"remove lun from bakcup plan. Put url = %s, paramMap = %s", new Object[]{url, paramMap});
            connection.put(url, paramMap);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("remove lun from backupPlan failed. url = " + url + ", paramMap = " + paramMap), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("remove lun from backupPlan failed. url = " + url + ", paramMap = " + paramMap), (Throwable)e);
            throw new LegoCheckedException("remove lun from backupPlan failed.", (Throwable)e);
        }
    }

    public void deleteBackupPlan(String devSn, String backupPlanId) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn, backupPlanId});
        logger.debug((Object)"delete cloudBackupPlan. devSn: %s, backupPlanId: %s", new Object[]{devSn, backupPlanId});
        JSONObject params = new JSONObject();
        params.put((Object)"force", (Object)Boolean.TRUE);
        params.put((Object)"type", (Object)String.valueOf(XveMOType.CLOUDBACKUP_PLAN.getValue()));
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/backup_plan/" + backupPlanId;
        try {
            logger.debug((Object)"Delete backup plan: url = %s, params = %s", new Object[]{url, params});
            connection.deleteForObject(url, (Object)params);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("delete cloudBackupPlan failed. url = " + url + ", params = " + params), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("delete cloudBackupPlan failed. url = " + url + ", params = " + params), (Throwable)e);
            throw new LegoCheckedException("delete cloudBackupPlan failed.", (Throwable)e);
        }
    }

    public void enable(String devSn, String backupPlanId, boolean enable) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn, backupPlanId});
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("activated", String.valueOf(enable ? 1 : 0));
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/backup_plan/" + backupPlanId;
        try {
            logger.debug((Object)"Put enable backupPlan. url = %s, param = %s", new Object[]{url, paramMap});
            connection.put(url, paramMap);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("enable cloudBackupPlan failed. url = " + url + ", param = " + paramMap), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("enable cloudBackupPlan failed. url = " + url + ", param = " + paramMap), (Throwable)e);
            throw new LegoCheckedException("enabled cloudBackupPlan failed.", (Throwable)e);
        }
    }

    public BackupPlan queryBackupPlan(String devSn, String backupPlanId) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn, backupPlanId});
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/backup_plan/" + backupPlanId;
        try {
            logger.debug((Object)"Get backupPlan: url = %s, deviceID = %s", new Object[]{url, devSn});
            Map map = connection.get(url, null);
            logger.debug((Object)"Get backupPlan plan, response map = %s", new Object[]{map});
            if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Map)map)) {
                BackupPlan result = this.transitionBackupPlan(map);
                result.setDevSn(devSn);
                logger.debug((Object)("query cloudBackupPlan:" + result.toString()));
                return result;
            }
            return null;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("query cloudBackupPlan error. url = " + url), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("query cloudBackupPlan error. url = " + url), (Throwable)e);
            throw new LegoCheckedException("query cloudBackupPlan failed.", (Throwable)e);
        }
    }

    public void modifyBackupPlan(BackupPlan backupPlan) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{backupPlan.getDevSn(), backupPlan.getId()});
        Map<String, String> paramMap = this.constructModifyPlanParameter(backupPlan);
        RestConnection connection = this.getConnection(backupPlan.getDevSn());
        String url = "/rest/${deviceID}/backup_plan/" + backupPlan.getId();
        try {
            logger.debug((Object)"Put modify backupPlan: url = %s, param = %s", new Object[]{url, paramMap});
            connection.put(url, paramMap);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("modify backupPlan failed. url = " + url + ", param = " + paramMap), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("modify backupPlan failed. url = " + url + ", param = " + paramMap), (Throwable)e);
            throw new LegoCheckedException("modify backupPlan failed.", (Throwable)e);
        }
    }

    public String run(BackupPlan backupPlan, Map<String, String> extendParameters) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObject((Object)backupPlan);
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObject(extendParameters);
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{backupPlan.getDevSn(), backupPlan.getId()});
        JSONObject paramMap = new JSONObject();
        paramMap.put((Object)"ID", (Object)backupPlan.getId());
        paramMap.put((Object)"backupMode", (Object)backupPlan.getBackupMode());
        String snapshotList = extendParameters.get("snapshotList");
        paramMap.put((Object)"snapShotList", (Object)snapshotList);
        paramMap.put((Object)"domainTagRunType", (Object)2);
        RestConnection connection = this.getConnection(backupPlan.getDevSn());
        String url = "/rest/${deviceID}/backup_plan/run/";
        try {
            logger.debug((Object)"start run backup plan. url = %s, params:[%s]", new Object[]{url, paramMap.toString()});
            Map response = connection.putForObject(url, (Object)paramMap);
            logger.debug((Object)"end run backup plan. response:[%s]", new Object[]{response.toString()});
            return (String)response.get("requestID");
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("run backupPlan failed. url = " + url + ", param = " + paramMap), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("run backupPlan failed. url = " + url + ", param = " + paramMap), (Throwable)e);
            throw new LegoCheckedException("run backupPlan failed.", (Throwable)e);
        }
    }

    public BackupPlan queryBackupPlanByLun(String devSn, String lunId, String lunType, String wwn) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn, lunId});
        HashMap<String, String> paramMap = new HashMap<String, String>();
        RestConnection connection = this.getConnection(devSn);
        paramMap.put("type", String.valueOf(XveMOType.CLOUDBACKUP_PLAN.getValue()));
        paramMap.put("associateObjID", String.valueOf(lunId));
        paramMap.put("associateObjType", String.valueOf(lunType));
        JSONObject wwnJsonObject = new JSONObject();
        wwnJsonObject.put((Object)"wwn", (Object)wwn);
        paramMap.put("associateMetadata", wwnJsonObject.toString());
        String url = "/rest/${deviceID}/backup_plan/associate";
        try {
            logger.debug((Object)"Get backup plan by lun: url = %s, param = %s, deviceID = %s", new Object[]{url, paramMap, devSn});
            Map result = connection.get(url, paramMap);
            logger.debug((Object)"Get backup plan by lun: response map = %s", new Object[]{result});
            if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Map)result)) {
                BackupPlan backupPlan = this.transitionBackupPlan(result);
                backupPlan.setDevSn(devSn);
                logger.debug((Object)("query cloudBackupPlan:" + result.toString()));
                return backupPlan;
            }
            return null;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("query backup plan by lun error. url = " + url + ", param = " + paramMap), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("query backup plan by lun error. url = " + url + ", param = " + paramMap), (Throwable)e);
            throw new LegoCheckedException("query cloudBackupPlan failed.", (Throwable)e);
        }
    }

    public List<BackupTask> queryTask(String engineId, Map<String, String> filter) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{engineId});
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObject(filter);
        RestConnection connection = this.getConnection(engineId);
        StringBuilder url = new StringBuilder("/rest/${deviceID}/cloudbackup_task?filter=");
        try {
            ArrayList<BackupTask> backupTasks = new ArrayList<BackupTask>();
            for (Map.Entry<String, String> entry : filter.entrySet()) {
                url.append(entry.getKey()).append("::").append(entry.getValue()).append("&");
            }
            url.append("range=[0-100]");
            logger.debug((Object)"Get task: url = %s, deviceID = %s", new Object[]{url, engineId});
            List results = connection.getBatch(url.toString(), null, false);
            for (Map result : results) {
                backupTasks.add(this.transitionBackupTask(result));
            }
            return backupTasks;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("query BackupTask error. url = " + url + "deviceID = " + engineId), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("query BackupTask error. url = " + url + "deviceID = " + engineId), (Throwable)e);
            throw new LegoCheckedException("query BackupTask failed.", (Throwable)e);
        }
    }

    public BackupTask queryTask(String engineId, String taskId) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{engineId, taskId});
        RestConnection connection = this.getConnection(engineId);
        String url = "/rest/${deviceID}/cloudbackup_task/" + taskId;
        try {
            logger.debug((Object)"Get task: url = %s, deviceID = %s", new Object[]{url, engineId});
            Map map = connection.get(url, null);
            logger.debug((Object)"Get task response map = %s", new Object[]{map});
            if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Map)map)) {
                return this.transitionBackupTask(map);
            }
            return null;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("queryTask error. url = " + url), (Throwable)le);
            if (1077948996L == le.getErrorCode()) {
                return null;
            }
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("queryTask error. url = " + url), (Throwable)e);
            throw new LegoCheckedException("queryTask failed.", (Throwable)e);
        }
    }

    public void offlineTransfer(String engineId, String planId, int status) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{engineId, planId});
        logger.debug((Object)"modify backup plan %s offlineTransfer status, status is %s", new Object[]{planId, String.valueOf(status)});
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("offlineTransEnabled", status);
        RestConnection connection = this.getConnection(engineId);
        String url = "/rest/${deviceID}/backup_plan/" + planId;
        try {
            logger.debug((Object)"Put offline transfer: url = %s, param = %s", new Object[]{url, paramMap});
            connection.putForObject(url, paramMap);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("backupPlan offline transfer status failed. url " + url + ", param = " + paramMap), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("backupPlan offline transfer status failed. url " + url + ", param = " + paramMap), (Throwable)e);
            throw new LegoCheckedException("modify backupPlan failed.", (Throwable)e);
        }
    }

    BackupTask transitionBackupTask(Map<String, String> resultMap) {
        if (VerifyUtil.isEmpty(resultMap)) {
            logger.error((Object)"Input param of transitionBackupTask is null");
            throw new LegoCheckedException(1073947393L);
        }
        BackupTask backupTask = new BackupTask();
        backupTask.setId(resultMap.get("ID"));
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)resultMap.get("status"))) {
            Integer status = NumberUtil.convertToInteger((Object)resultMap.get("status"));
            backupTask.setStatus(BackupTask.STATUS.getStatus((int)status));
        }
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)resultMap.get("progress"))) {
            backupTask.setProgress(NumberUtil.convertToInteger((Object)resultMap.get("progress")).intValue());
        }
        backupTask.setAssociateImageID(resultMap.get("associateImageID"));
        backupTask.setTaskDetails(resultMap.get("taskDetails"));
        return backupTask;
    }
}

