/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.storage.handler.IStorageInitiatorHandler;
import com.huawei.ism.drm.storage.hvs.handler.impl.AbstractRestStorageHandler;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.ubase.adaptor.hvs.discovery.util.HVSRestTransition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageInitiatorHandlerRestImpl
extends AbstractRestStorageHandler
implements IStorageInitiatorHandler {
    public List<Initiator> queryInitiators(String devSn) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<Initiator> list = new ArrayList<Initiator>();
        List<Initiator> fcInitiators = this.queryFcInitiators(devSn, null);
        List<Initiator> iScsiInitiators = this.queryIScsiInitiators(devSn, null);
        List<Initiator> roceInitiators = this.queryRoCEInitiators(devSn, null);
        list.addAll(fcInitiators);
        list.addAll(iScsiInitiators);
        list.addAll(roceInitiators);
        return list;
    }

    private List<Initiator> queryFcInitiators(String devSn, String hostId) {
        RestConnection connection = this.getConnection(devSn);
        StringBuilder url = new StringBuilder("/rest/${deviceID}/fc_initiator?range=[0-65536]");
        if (!VerifyUtil.isEmpty((String)hostId)) {
            url.append("&PARENTID=").append(hostId);
        }
        ArrayList<Initiator> list = new ArrayList<Initiator>();
        List records = connection.getBatch(url.toString(), null);
        if (!VerifyUtil.isEmpty((Collection)records)) {
            for (Map record : records) {
                Initiator fciInitiator = HVSRestTransition.transitionFcInitiator((String)devSn, (Map)record);
                list.add(fciInitiator);
            }
        }
        return list;
    }

    private List<Initiator> queryIScsiInitiators(String devSn, String hostId) {
        RestConnection connection = this.getConnection(devSn);
        StringBuilder url = new StringBuilder("/rest/${deviceID}/iscsi_initiator?range=[0-65536]");
        if (!VerifyUtil.isEmpty((String)hostId)) {
            url.append("&PARENTID=").append(hostId);
        }
        ArrayList<Initiator> list = new ArrayList<Initiator>();
        logger.debug((Object)"query iscsi initiators.url=%s", new Object[]{url.toString()});
        List records = connection.getBatch(url.toString(), null);
        if (!VerifyUtil.isEmpty((Collection)records)) {
            for (Map record : records) {
                Initiator iScsiInitiator = HVSRestTransition.transitionIscsiInitiator((String)devSn, (Map)record);
                list.add(iScsiInitiator);
            }
        }
        return list;
    }

    private List<Initiator> queryRoCEInitiators(String devSn, String hostId) {
        RestConnection connection = this.getConnection(devSn);
        StringBuilder url = new StringBuilder("/rest/${deviceID}/NVMe_over_RoCE_initiator?range=[0-65536]");
        if (!VerifyUtil.isEmpty((String)hostId)) {
            url.append("&PARENTID=").append(hostId);
        }
        ArrayList<Initiator> list = new ArrayList<Initiator>();
        logger.debug((Object)"query roce initiators.url=%s", new Object[]{url.toString()});
        List records = connection.getBatch(url.toString(), null);
        if (!VerifyUtil.isEmpty((Collection)records)) {
            for (Map record : records) {
                Initiator roceInitiator = HVSRestTransition.transitionRoCEInitiator((String)devSn, (Map)record);
                list.add(roceInitiator);
            }
        }
        return list;
    }

    private Initiator queryFcInitiator(String devSn, String id) {
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/fc_initiator/" + id;
        logger.debug((Object)"query fc initiators.url=%s", new Object[]{url});
        Map record = connection.get(url, null);
        Initiator fcInitiator = null;
        if (!VerifyUtil.isEmpty((Map)record)) {
            fcInitiator = HVSRestTransition.transitionFcInitiator((String)devSn, (Map)record);
        }
        return fcInitiator;
    }

    private Initiator queryIScsiInitiator(String devSn, String id) {
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/iscsi_initiator/" + id;
        logger.debug((Object)"query iscsi initiators.url=%s", new Object[]{url});
        Map record = connection.get(url, null);
        Initiator iScsiInitiator = null;
        if (!VerifyUtil.isEmpty((Map)record)) {
            iScsiInitiator = HVSRestTransition.transitionIscsiInitiator((String)devSn, (Map)record);
        }
        return iScsiInitiator;
    }

    private Initiator queryRoCEInitiator(String devSn, String id) {
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/NVMe_over_RoCE_initiator/" + id;
        logger.debug((Object)"query roce initiators.url=%s", new Object[]{url});
        Map record = connection.get(url, null);
        Initiator roceInitiator = null;
        if (!VerifyUtil.isEmpty((Map)record)) {
            roceInitiator = HVSRestTransition.transitionRoCEInitiator((String)devSn, (Map)record);
        }
        return roceInitiator;
    }

    public Initiator queryInitiator(String devSn, Initiator initiator) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (null == initiator) {
            throw new LegoCheckedException(1073947393L);
        }
        if ("FC".equals(initiator.getHbaType())) {
            Initiator fcInitiator = this.queryFcInitiator(devSn, initiator.getIdentity());
            return fcInitiator;
        }
        if ("ISCSI".equals(initiator.getHbaType())) {
            Initiator iScsiInitiator = this.queryIScsiInitiator(devSn, initiator.getIdentity());
            return iScsiInitiator;
        }
        Initiator roceInitiator = this.queryRoCEInitiator(devSn, initiator.getIdentity());
        return roceInitiator;
    }

    public List<Initiator> queryInitiatorsByHost(String devSn, String hostId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, hostId});
        ArrayList<Initiator> inits = new ArrayList<Initiator>();
        List<Initiator> iScsiInitiators = this.queryIScsiInitiators(devSn, hostId);
        List<Initiator> fcInitiators = this.queryFcInitiators(devSn, hostId);
        List<Initiator> roceInitiators = this.queryRoCEInitiators(devSn, hostId);
        inits.addAll(iScsiInitiators);
        inits.addAll(fcInitiators);
        inits.addAll(roceInitiators);
        return inits;
    }

    public void addInitiatorToHost(String devSn, String hostId, XveMOType initiatorType, String initiatorId) {
        String url;
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)hostId)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (null == initiatorType) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)initiatorId)) {
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = this.getConnection(devSn);
        if (XveMOType.ISCSI_INITIATOR.equals((Object)initiatorType)) {
            url = "/rest/${deviceID}/iscsi_initiator/" + initiatorId;
        } else if (XveMOType.FC_INITIATOR.equals((Object)initiatorType)) {
            url = "/rest/${deviceID}/fc_initiator/" + initiatorId;
        } else {
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TYPE", Integer.toString(initiatorType.getValue()));
        params.put("ID", initiatorId);
        params.put("PARENTTYPE", Integer.toString(XveMOType.HOST.getValue()));
        params.put("PARENTID", hostId);
        logger.debug((Object)"add initiators.url=%s,param=%s", new Object[]{url, params});
        connection.put(url, params);
    }
}

