/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.handler.IStorageLunConsistencyGroupHandler;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.sdk.model.LunConsistencyGroup;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageLunConsistencyGroupHandlerImpl
implements IStorageLunConsistencyGroupHandler {
    private static final Log logger = LogFactory.getInstance(StorageLunConsistencyGroupHandlerImpl.class);
    private final RestConnectionManager connMgr = RestConnectionManager.getInstance();

    public LunConsistencyGroup createLunConsistencyGroup(String devSn, String name, String description, String vstoreId) {
        LunConsistencyGroup result;
        VerifyUtil.checkStrs((String[])new String[]{devSn, name});
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(devSn);
        if (drResource.getIsAirGapResource().booleanValue() && !VerifyUtil.isEmpty((String)vstoreId)) {
            return this.createProtectionGroup(devSn, name, description, vstoreId);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("NAME", name);
        paramMap.put("DESCRIPTION", description);
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/LUN_CONSISTENCY_GROUP";
        try {
            logger.debug((Object)"Start to create lun consistency group.url=%s,param=%s", new Object[]{url, paramMap});
            Map map = connection.post(url, paramMap);
            result = HVSRestTransitionExtend.transitionLunConsistencyGroup(map);
            result.setDevSn(devSn);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"Create Lun consistency group failed.url=%s, params=%s", new Object[]{url, paramMap, le});
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)"Create Lun consistency group failed.url=%s, params=%s", new Object[]{url, paramMap, e});
            throw new LegoCheckedException("create Lun consistency group failed.", (Throwable)e);
        }
        logger.debug((Object)"Create Lun consistency group: %s", new Object[]{result});
        return result;
    }

    private LunConsistencyGroup createProtectionGroup(String devSn, String name, String description, String vstoreId) {
        LunConsistencyGroup result;
        logger.info((Object)"Begin to create protection group by devSn: %s, and name: %s", new Object[]{devSn, name});
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("protectGroupName", name);
        paramMap.put("description", description);
        paramMap.put("vstoreId", vstoreId);
        RestConnection connection = this.getConnection(devSn);
        String url = "/api/v2/protectgroup";
        try {
            logger.debug((Object)"Start to create lun consistency group.url=%s,param=%s", new Object[]{url, paramMap});
            Map map = connection.postByPipe(url, paramMap, true);
            result = HVSRestTransitionExtend.transitionLunProtectGroup(map);
            result.setDevSn(devSn);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Create Lun protection group failed.url=%s, params=%s", new Object[]{url, paramMap, e});
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Create Lun consistency group failed.url = %s, params = %s", new Object[]{url, paramMap, e});
            throw new LegoCheckedException("Create protection group failed.", (Throwable)e);
        }
        logger.debug((Object)"Create Lun protection group result: %s", new Object[]{result});
        return result;
    }

    protected RestConnection getConnection(String devSn) {
        RestConnection connection = this.connMgr.getConnection(devSn);
        if (null == connection) {
            logger.error((Object)("The connection does not exist. sn=" + devSn));
            throw new LegoCheckedException(1073947649L);
        }
        return connection;
    }

    public void addLun(String devSn, String consistencyGroupId, String lunId, String vstoreId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, consistencyGroupId, lunId});
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ID", consistencyGroupId);
        paramMap.put("ASSOCIATEOBJTYPE", String.valueOf(XveMOType.LUN.getValue()));
        paramMap.put("ASSOCIATEOBJID", lunId);
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(devSn);
        if (!VerifyUtil.isEmpty((String)vstoreId) && drResource.getIsAirGapResource().booleanValue()) {
            paramMap.put("vstoreId", vstoreId);
        }
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/LUN_CONSISTENCY_GROUP/CREATE_ASSOCIATE";
        try {
            logger.debug((Object)"start to add lun to group.url=%s,devsn=%s,param=%s", new Object[]{url, devSn, paramMap});
            connection.post("/rest/${deviceID}/LUN_CONSISTENCY_GROUP/CREATE_ASSOCIATE", paramMap);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("add lun to consistencyGroup failed.url=" + url + ",devsn=" + devSn + ",param=" + paramMap), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("add lun to consistencyGroup failed.url=" + url + ",devsn=" + devSn + ",param=" + paramMap), (Throwable)e);
            throw new LegoCheckedException("add lun to consistencyGroup failed.", (Throwable)e);
        }
    }

    public void removeLun(String devSn, String consistencyGroupId, String lunId, boolean removeSnapshot) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, consistencyGroupId, lunId});
        String request = "?ID=" + consistencyGroupId + "&ASSOCIATEOBJTYPE=" + String.valueOf(XveMOType.LUN.getValue()) + "&ASSOCIATEOBJID=" + lunId;
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/LUN_CONSISTENCY_GROUP/associate" + request;
        try {
            logger.debug((Object)"start to remove lun to group.url=%s,devsn=%s", new Object[]{url, devSn});
            connection.delete(url, null);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("add lun to consistencyGroup failed.url=" + url + ",devsn=" + devSn), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("add lun to consistencyGroup failed.url=" + url + ",devsn=" + devSn), (Throwable)e);
            throw new LegoCheckedException("add lun to consistencyGroup failed.", (Throwable)e);
        }
    }

    public void deleteConsistencyGroup(String devSn, String lunConsistencyGroupId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, lunConsistencyGroupId});
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/LUN_CONSISTENCY_GROUP/" + lunConsistencyGroupId;
        try {
            logger.debug((Object)"start to delete group.url=%s,devsn=%s", new Object[]{url, devSn});
            connection.delete(url, null);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("delete consistencyGroup failed.url=" + url + ",devsn=" + devSn), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("delete consistencyGroup failed.url=" + url + ",devsn=" + devSn), (Throwable)e);
            throw new LegoCheckedException("add lun to consistencyGroup failed.", (Throwable)e);
        }
    }

    public LunConsistencyGroup queryConsistencyGroup(String devSn, String id) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/LUN_CONSISTENCY_GROUP/" + id;
        try {
            logger.debug((Object)"start to query lun consisten group. url=%s,devSn=%s", new Object[]{url, devSn});
            Map result = connection.get(url, null);
            if (VerifyUtil.isEmpty((Map)result)) {
                return null;
            }
            return HVSRestTransitionExtend.transitionLunConsistencyGroup(result);
        }
        catch (LegoCheckedException le) {
            if (1073748824L == le.getErrorCode()) {
                return null;
            }
            logger.error((Object)"add lun to consistencyGroup failed.", (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)"add lun to consistencyGroup failed.", (Throwable)e);
            throw new LegoCheckedException("add lun to consistencyGroup failed.", (Throwable)e);
        }
    }

    public List<LunConsistencyGroup> queryConsistencyGroups(String devSn, XveMOType associateObjType, String associateObjId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, associateObjId});
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/LUN_CONSISTENCY_GROUP/associate?ASSOCIATEOBJID=" + associateObjId + "&ASSOCIATEOBJTYPE=" + associateObjType.getValue();
        try {
            ArrayList<LunConsistencyGroup> list = new ArrayList<LunConsistencyGroup>();
            logger.debug((Object)"start to query lun consisten groups. url=%s,devSn=%s", new Object[]{url, devSn});
            List records = connection.getBatch(url, null);
            if (!VerifyUtil.isEmpty((Collection)records)) {
                records.forEach(map -> list.add(HVSRestTransitionExtend.transitionLunConsistencyGroup(map)));
            }
            return list;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"add lun to consistencyGroup failed.", (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)"add lun to consistencyGroup failed.", (Throwable)e);
            throw new LegoCheckedException("add lun to consistencyGroup failed.", (Throwable)e);
        }
    }
}

