/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.storage.handler.IStorageReplicationHandler;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.hvs.handler.impl.AbstractRestStorageHandler;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StorageReplicationHandlerRestImpl
extends AbstractRestStorageHandler
implements IStorageReplicationHandler {
    public ReplicationRelation queryReplication(String deviceSN, String replicationId, boolean isConsistentGroup) {
        ReplicationGroup replicationRelation;
        RestConnection connection = this.getConnection(deviceSN);
        logger.debug((Object)"query Replication start. devSn=%s, id=%s, isConsistentGroup=%s.", new Object[]{deviceSN, replicationId, isConsistentGroup});
        try {
            if (isConsistentGroup) {
                String url = "/rest/${deviceID}/consistentgroup/" + replicationId;
                Map record = connection.get(url, null);
                replicationRelation = HVSRestTransitionExtend.transitionReplicationGroup(record, deviceSN);
            } else {
                String url = "/rest/${deviceID}/replicationpair/" + replicationId;
                Map record = connection.get(url, null);
                replicationRelation = HVSRestTransitionExtend.transitionReplicationPair(record, deviceSN);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error while replicationRelation transition, devSn=" + deviceSN + ", id=" + replicationId + ", isConsistentGroup=" + isConsistentGroup + ExceptionUtil.getErrorMessage((Throwable)e)));
            replicationRelation = null;
        }
        logger.debug((Object)"query Replication finished.");
        return replicationRelation;
    }

    public List<ReplicationPair> queryReplicationByAssociation(String devSn, int assObjType, String assObjID) {
        RestConnection connection = this.getConnection(devSn);
        StringBuilder sb = new StringBuilder("/rest/${deviceID}/replicationpair/associate");
        sb.append("?TYPE=").append(XveMOType.REPLICATIONPAIR.getValue());
        sb.append("&ASSOCIATEOBJTYPE=").append(assObjType);
        sb.append("&ASSOCIATEOBJID=").append(assObjID);
        logger.debug((Object)"query replication by association start. devSn=%s, url=%s.", new Object[]{devSn, sb.toString()});
        List records = connection.getBatch(sb.toString(), null);
        ArrayList<ReplicationPair> list = new ArrayList<ReplicationPair>();
        for (Map record : records) {
            try {
                ReplicationPair replicationPair = HVSRestTransitionExtend.transitionReplicationPair(record, devSn);
                list.add(replicationPair);
            }
            catch (Exception e) {
                logger.error((Object)("Error while Replication transition, devSn=" + devSn + ", assObjType=" + assObjType + ", assObjID=" + assObjID), 90160777658373L);
            }
        }
        logger.debug((Object)"query replication by association finished. devSn=%s, assObjID=%s, returned replicationPair size=%s.", new Object[]{devSn, assObjID, list.size()});
        return list;
    }

    public void modify(String sn, String id, boolean isCg, Map<String, Object> params) {
        logger.debug((Object)("Begin modify, sn=" + sn + ", id=" + id + ", isCg=" + isCg + ", " + params));
        VerifyUtil.checkStrs((String[])new String[]{sn, id});
        if (VerifyUtil.isEmpty(params)) {
            logger.error((Object)"info can not be empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String url = isCg ? "/rest/${deviceID}/consistentgroup/" + id : "/rest/${deviceID}/replicationpair/" + id;
        Map<String, String> paramsNew = this.transform(params);
        logger.debug((Object)("transform result=" + paramsNew));
        this.getConnection(sn).put(url, paramsNew);
        logger.debug((Object)"End modify.");
    }
}

