/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.backup.IBackupManager;
import com.huawei.ism.drm.backup.model.BackupProxy;
import com.huawei.ism.drm.backup.model.BackupStoragePool;
import com.huawei.ism.drm.backup.model.BackupStorageRepository;
import com.huawei.ism.drm.storage.handler.IStorageBackupPlanHandler;
import com.huawei.ism.drm.storage.handler.IStorageBackupProxyHandler;
import com.huawei.ism.drm.storage.handler.IStorageBackupStorageHandler;
import com.huawei.ism.drm.storage.handler.IStorageLunHandler;
import com.huawei.ism.drm.storage.hvs.handler.impl.StorageBackupImageHandlerImpl;
import com.huawei.ism.drm.storage.sdk.model.BackupImage;
import com.huawei.ism.drm.storage.sdk.model.BackupPlan;
import com.huawei.ism.drm.storage.sdk.model.BackupTask;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HvsStorageBackupManager
implements IBackupManager {
    public static final String BACKUP_ENGINE_TYPE = "NativeBackupEngine";
    private static final Log logger = LogFactory.getInstance(HvsStorageBackupManager.class);
    private StorageBackupImageHandlerImpl storageBackupImageHandler;
    private IStorageBackupPlanHandler backupPlanHandler;
    private IStorageLunHandler lunHandler;
    private IStorageBackupStorageHandler storageBackupStorageHandler;
    private IStorageBackupProxyHandler storageBackupProxyHandler;

    public void setStorageBackupImageHandler(StorageBackupImageHandlerImpl storageBackupImageHandler) {
        this.storageBackupImageHandler = storageBackupImageHandler;
    }

    public void setBackupPlanHandler(IStorageBackupPlanHandler handler) {
        this.backupPlanHandler = handler;
    }

    public void setStorageBackupStorageHandler(IStorageBackupStorageHandler storageBackupStorageHandler) {
        this.storageBackupStorageHandler = storageBackupStorageHandler;
    }

    public void setStorageBackupProxyHandler(IStorageBackupProxyHandler storageBackupProxyHandler) {
        this.storageBackupProxyHandler = storageBackupProxyHandler;
    }

    public void setLunHandler(IStorageLunHandler lunHandler) {
        this.lunHandler = lunHandler;
    }

    public String getBackupEngineType() {
        return BACKUP_ENGINE_TYPE;
    }

    public String restore(String engineId, String imageId, Map<String, String> lunRelationships) {
        return this.storageBackupImageHandler.restore(engineId, imageId, lunRelationships);
    }

    public String run(BackupPlan backupPlan, Map<String, String> extendParameters) {
        return this.backupPlanHandler.run(backupPlan, extendParameters);
    }

    public BackupImage queryImage(String engineId, String imageId) {
        return this.storageBackupImageHandler.query(engineId, imageId);
    }

    public List<BackupImage> queryImage(String engineId, Map<String, String> filter) {
        return this.storageBackupImageHandler.query(engineId, filter);
    }

    public String deleteImage(String engineId, String imageId) {
        return this.storageBackupImageHandler.delete(engineId, imageId);
    }

    public BackupTask queryTask(String engineId, String taskId) {
        return this.backupPlanHandler.queryTask(engineId, taskId);
    }

    public List<BackupTask> queryTask(String engineId, Map<String, String> filter) {
        return this.backupPlanHandler.queryTask(engineId, filter);
    }

    public BackupTask queryTaskByRequestID(String engineId, String requestID) {
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("requestID", requestID);
        List list = this.backupPlanHandler.queryTask(engineId, paraMap);
        return (BackupTask)CommonUtil.getFirstElement((Collection)list);
    }

    public BackupPlan createBackupPlan(BackupPlan backupPlan) {
        return this.backupPlanHandler.createBackupPlan(backupPlan);
    }

    public void addLun(String engineId, String backupPlanId, String lunId, String wwn) {
        this.backupPlanHandler.addLun(engineId, backupPlanId, lunId, wwn);
    }

    public void removeLun(String engineId, String backupPlanId, String lunId, String wwn) {
        this.backupPlanHandler.removeLun(engineId, backupPlanId, lunId, wwn);
    }

    public void deleteBackupPlan(String engineId, String backupPlanId) {
        this.backupPlanHandler.deleteBackupPlan(engineId, backupPlanId);
    }

    public void enable(String engineId, String backupPlanId, boolean enable) {
        this.backupPlanHandler.enable(engineId, backupPlanId, enable);
    }

    public BackupPlan queryBackupPlan(String engineId, String backupPlanId) {
        BackupPlan backupPlan = this.backupPlanHandler.queryBackupPlan(engineId, backupPlanId);
        return backupPlan;
    }

    public void modifyBackupPlan(BackupPlan backupPlan) {
        this.backupPlanHandler.modifyBackupPlan(backupPlan);
    }

    public List<Lun> getBackupLun(String engineId, String backupPlanId) {
        List luns = this.lunHandler.queryLuns(engineId, XveMOType.CLOUDBACKUP_PLAN, backupPlanId);
        return luns;
    }

    public BackupStoragePool createBackupStoragePool(BackupStoragePool pool) {
        return this.storageBackupStorageHandler.createBackupStoragePool(pool);
    }

    public void updateBackupStoragePool(String backupEngineId, String poolId, BackupStoragePool newPool) {
        this.storageBackupStorageHandler.updateBackupStoragePool(backupEngineId, poolId, newPool);
    }

    public void deleteBackupStoragePool(String backupEngineId, String poolId) {
        this.storageBackupStorageHandler.deleteBackupStoragePool(backupEngineId, poolId);
    }

    public List<BackupStoragePool> listBackupStoragePool(String backupEngineId, Map<String, String> filter) {
        return this.storageBackupStorageHandler.listBackupStoragePool(backupEngineId, filter);
    }

    public BackupStoragePool getBackupStoragePool(String backupEngineId, String poolId) {
        return this.storageBackupStorageHandler.getBackupStoragePool(backupEngineId, poolId);
    }

    public void createBackupStorageRepository(BackupStorageRepository repository) {
        this.storageBackupStorageHandler.createBackupStorageRepository(repository);
    }

    public void updateBackupStorageRepository(String backupEngineId, String repositoryId, BackupStorageRepository repository) {
        this.storageBackupStorageHandler.updateBackupStorageRepository(backupEngineId, repositoryId, repository);
    }

    public void deleteBackupStorageRepository(String backupEngineId, String repositoryId) {
        this.storageBackupStorageHandler.deleteBackupStorageRepository(backupEngineId, repositoryId);
    }

    public List<BackupStorageRepository> listBackupStorageRepository(String backupEngineId, Map<String, String> filter) {
        return this.storageBackupStorageHandler.listBackupStorageRepository(backupEngineId, filter);
    }

    public BackupStorageRepository getBackupStorageRepository(String backupEngineId, String repositoryId) {
        return this.storageBackupStorageHandler.getBackupStorageRepository(backupEngineId, repositoryId);
    }

    public BackupProxy createBackupProxy(BackupProxy proxy, String backupEngineId, String verifyAddr) {
        return this.storageBackupProxyHandler.createBackupProxy(proxy, backupEngineId, verifyAddr);
    }

    public void verifyBackupProxy(String proxyId, String backupEngineId, String verifyAddr) {
        this.storageBackupProxyHandler.verifyBackupProxy(proxyId, backupEngineId, verifyAddr);
    }

    public void updateBackupProxy(BackupProxy proxy, String backupEngineId) {
        this.storageBackupProxyHandler.updateBackupProxy(proxy, backupEngineId);
    }

    public void deleteBackupProxy(String proxyId, String backupEngineId) {
        this.storageBackupProxyHandler.deleteBackupProxy(proxyId, backupEngineId);
    }

    public List<BackupProxy> listBackupProxy(String backupEngineId, Map<String, String> filter) {
        return this.storageBackupProxyHandler.listBackupProxy(backupEngineId, filter);
    }

    public BackupProxy getBackupProxy(String proxyId, String backupEngineId) {
        return this.storageBackupProxyHandler.getBackupProxy(proxyId, backupEngineId);
    }

    public void offlineTransfer(String engineId, String backupPlanId, int status) {
        this.backupPlanHandler.offlineTransfer(engineId, backupPlanId, status);
    }
}

