/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.HyperVault;
import com.huawei.ism.array.sdk.model.HyperVaultCopy;
import com.huawei.ism.array.sdk.model.HyperVaultJob;
import com.huawei.ism.array.sdk.model.RemoteDevice;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefinePParent;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.storage.handler.IStorageHyperVaultHandler;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperVaultManager;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class HvsStorageHyperVaultManager
implements IStorageHyperVaultManager {
    private static final Log logger = LogFactory.getInstance(HvsStorageHyperVaultManager.class);
    private IStorageHyperVaultHandler hyperVaultHandler;

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    public HyperVault queryHyperVaultByResourceId(String sn, String resourceId) {
        VerifyUtil.checkStrs((String[])new String[]{sn, resourceId});
        IStorageResourceService resSvc = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        NasFileSystem fs = (NasFileSystem)resSvc.getStorageResource(sn, resourceId, NasFileSystem.class);
        if (null == fs) {
            logger.error((Object)("FileSystem not exist, sn=" + sn + ", id=" + resourceId));
            throw new LegoCheckedException(2117645L);
        }
        List list = this.getHyperVaultHandler().queryHyperVaultByResName(sn, fs.getName());
        HyperVault result = null;
        for (HyperVault temp : list) {
            if (!resourceId.equals(temp.getLocalResourceId())) continue;
            logger.info((Object)("find one HyperVault, sn=" + sn + ", resId=" + resourceId + ", id=" + temp.getId()));
            result = temp;
            break;
        }
        if (null != result) {
            List remoteDevices = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).queryRemoteDevices(sn);
            for (RemoteDevice remoteDevice : remoteDevices) {
                if (!remoteDevice.getId().equals(result.getRemoteDeviceId())) continue;
                result.setRemoteDeviceSn(remoteDevice.getSn());
                break;
            }
        }
        return result;
    }

    public List<HyperVault> queryHyperVaultListByResourceIds(String sn, List<String> resourceIds) {
        VerifyUtil.checkStrs((String[])new String[]{sn});
        VerifyUtil.checkObject(resourceIds);
        IStorageResourceService resSvc = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        List fileSystemList = resSvc.getStorageResources(sn, resourceIds, NasFileSystem.class);
        if (VerifyUtil.isEmpty((Collection)fileSystemList) || fileSystemList.size() != resourceIds.size()) {
            logger.error((Object)("FileSystem not exist, sn=" + sn + ", id=" + resourceIds));
            throw new LegoCheckedException(2117645L);
        }
        long startA = System.currentTimeMillis();
        long startB = 0L;
        HashSet<String> fileSet = new HashSet<String>();
        for (NasFileSystem fs : fileSystemList) {
            fileSet.add(fs.getResourceId());
        }
        ArrayList<HyperVault> result = new ArrayList<HyperVault>();
        List list = this.getHyperVaultHandler().queryHyperVaultByResName(sn, null);
        for (HyperVault temp : list) {
            if (!fileSet.contains(temp.getLocalResourceId())) continue;
            logger.debug((Object)("find one HyperVault, sn=" + sn + ", resId=" + temp.getLocalResourceId() + ", id=" + temp.getId()));
            result.add(temp);
        }
        startB = System.currentTimeMillis();
        logger.debug((Object)("queryHyperVaultListByResourceIds cost time:" + (startA - startB)));
        if (!VerifyUtil.isEmpty(result) && result.size() == resourceIds.size()) {
            List remoteDevices = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).queryRemoteDevices(sn);
            block2: for (HyperVault vault : result) {
                for (RemoteDevice remoteDevice : remoteDevices) {
                    if (!remoteDevice.getId().equals(vault.getRemoteDeviceId())) continue;
                    vault.setRemoteDeviceSn(remoteDevice.getSn());
                    continue block2;
                }
            }
        }
        return result;
    }

    public HyperVault createHyperVault(HyperVault info, boolean backupInit) {
        String remoteDeviceSn;
        String devSn;
        if (null == info) {
            logger.error((Object)"info is null.");
            throw new LegoCheckedException(1073947393L);
        }
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        RemoteDevice remoteDevice = storageService.queryRemoteDevice(devSn = info.getDevSn(), remoteDeviceSn = info.getRemoteDeviceSn());
        if (null == remoteDevice) {
            logger.error((Object)("storage not exsit, devSn=" + devSn + ", remoteSn=" + remoteDeviceSn));
            throw new LegoCheckedException(1073947393L);
        }
        info.setRemoteDeviceId(remoteDevice.getId());
        HyperVault hyperVault = this.getHyperVaultHandler().createHyperVault(info, backupInit);
        return hyperVault;
    }

    public HyperVaultJob queryJob(String sn, String jobId) {
        HyperVaultJob job = this.getHyperVaultHandler().queryJob(sn, jobId);
        return job;
    }

    public List<HyperVaultCopy> queryCopysByHyperVault(String sn, String vaultId) {
        List copys = this.getHyperVaultHandler().queryCopysByHyperVault(sn, vaultId);
        return copys;
    }

    public void deleteCopy(String sn, String copyId) {
        this.getHyperVaultHandler().deleteCopy(sn, copyId);
    }

    public void disablePolicys(String sn, String vaultId, String policyType) {
        List ids = this.getHyperVaultHandler().queryPolicyIds(sn, vaultId, policyType);
        for (String id : ids) {
            this.getHyperVaultHandler().disablePolicy(sn, id);
        }
    }

    public String manualBackup(String sn, String vaultId, XveEnumDefine.VAULT_ACTION_TYPE_E actionType) {
        String jobId = this.getHyperVaultHandler().manualBackup(sn, vaultId, actionType);
        return jobId;
    }

    public String restoreHyperVaultCopy(String sn, String copyId) {
        String jobId = this.getHyperVaultHandler().restoreHyperVaultCopy(sn, copyId);
        return jobId;
    }

    public List<StorageResource> queryRemoteResource(String sn, long capacityByte, String remoteDeviceId, XveEnumDefinePParent.EPL_ARRAY_TYPE_E arrayType, XveMOType resType, XveEnumDefine.RSSLUN_TYPE_E rssType) {
        List resources = this.getHyperVaultHandler().queryRemoteResource(sn, capacityByte, remoteDeviceId, arrayType, resType, rssType);
        return resources;
    }

    public List<RemoteDevice> queryRemoteDevices(String sn) {
        List devices = this.getHyperVaultHandler().queryRemoteDevices(sn);
        return devices;
    }

    public IStorageHyperVaultHandler getHyperVaultHandler() {
        return this.hyperVaultHandler;
    }

    public void setHyperVaultHandler(IStorageHyperVaultHandler hyperVaultHandler) {
        this.hyperVaultHandler = hyperVaultHandler;
    }
}

