/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.manager.AbstractStorageReprotectManager;
import com.huawei.ism.drm.storage.resource.service.ReprotectReplicationReverseService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class HvsStorageReprotectManager
extends AbstractStorageReprotectManager {
    private static final Log logger = LogFactory.getInstance(HvsStorageReprotectManager.class);
    private ReprotectReplicationReverseService reverser;

    public ReprotectReplicationReverseService getReverser() {
        return this.reverser;
    }

    public void setReverser(ReprotectReplicationReverseService reverser) {
        this.reverser = reverser;
    }

    public OperationResult reverseReplication(String srcDeviceId, String targetDeviceId, String replicationId, boolean isConsistentGroup) {
        return this.reverser.reverseReplication(srcDeviceId, targetDeviceId, replicationId, isConsistentGroup);
    }

    public void checkStorageReplication(String deviceId, List<String> resourceIds) {
        if (VerifyUtil.isEmpty((String)deviceId) || VerifyUtil.isEmpty(resourceIds)) {
            logger.error((Object)("Invalid parameters. DevId:" + deviceId), 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        List replicationTargetLunIds = DrmStorageUtil.getReplicationTargetLunIdsByDevId((String)deviceId);
        if (VerifyUtil.isEmpty((Collection)replicationTargetLunIds)) {
            logger.error((Object)("There is no target luns. DevId:" + deviceId), 90160758784001L);
            throw new LegoCheckedException(1073948175L);
        }
        List replicationRelations = DrmStorageUtil.getReplicationRelationsSrcLunIds((String)deviceId, (int)0);
        if (VerifyUtil.isEmpty((Collection)replicationRelations)) {
            logger.error((Object)("There is no replications. DevId:" + deviceId), 90160758784001L);
            throw new LegoCheckedException(1073948175L);
        }
        HashSet tgtResourceIds = new HashSet(replicationTargetLunIds);
        HashSet srcResourceIds = new HashSet(replicationRelations);
        for (String resourceId : resourceIds) {
            if (tgtResourceIds.contains(resourceId) || srcResourceIds.contains(resourceId)) continue;
            logger.error((Object)("The replication does not exist. DevId:" + deviceId + ",ResId:" + resourceId), 90160758784001L);
            throw new LegoCheckedException(1073948175L);
        }
    }

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    public OperationResult setSecondaryLunWriteProtection(String srcDeviceId, String targetDeviceId, String replicationId, boolean isConsistentGroup) {
        return this.reverser.setSecondaryLunWriteProtection(srcDeviceId, targetDeviceId, replicationId, isConsistentGroup);
    }

    public void checkStorageRunningStatus(String deviceId, List<String> usedDrRingIds, String drStrategy) {
        if (CollectionUtils.isEmpty(usedDrRingIds)) {
            return;
        }
        ArrayList<String> productStorages = new ArrayList<String>();
        productStorages.add(deviceId);
        StringBuilder notMatchedDRRings = DRRingUtil.checkRunningStatusNotMatchedRings(productStorages, usedDrRingIds, drStrategy);
        if (notMatchedDRRings.length() != 0) {
            logger.error((Object)("running status of dr-ring list,must be enable.but actual:" + notMatchedDRRings));
            throw new LegoCheckedException(1073948257L);
        }
    }
}

