/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.storage.hvs.manager.HvsStorageVstoreReplicationPairManager;
import com.huawei.ism.unistor.sdk.model.VstoreReplicationPair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Map;
import java.util.Objects;

public class HvsStorageVstoreReplicationPairV6Manager
extends HvsStorageVstoreReplicationPairManager {
    private static final Log logger = LogFactory.getInstance(HvsStorageVstoreReplicationPairV6Manager.class);
    private static final String ACCESS_FORBIDDEN = "1";
    private static final String READ_ONLY = "2";
    private static final String ROLE_PRIMARY = "1";

    public String getVersion() {
        return "V600R000C00";
    }

    @Override
    protected String getSwitchUrl() {
        String url = "/rest/${deviceID}/VSTORE_PAIR/swap";
        return url;
    }

    @Override
    protected boolean getIsPrimary(String role) {
        return "1".equals(role);
    }

    @Override
    protected String getReplicationVstorePairUrl() {
        String url = "/rest/${deviceID}/VSTORE_PAIR/";
        return url;
    }

    @Override
    protected String getSplitUrl() {
        String url = "/rest/${deviceID}/VSTORE_PAIR/split";
        return url;
    }

    @Override
    protected String getSyncUrl() {
        String url = "/rest/${deviceID}/VSTORE_PAIR/sync";
        return url;
    }

    @Override
    protected String getQuerySyncStatusUrl(String devSn, String pairId) {
        String url = "/rest/${deviceID}/REPLICATIONPAIR";
        VstoreReplicationPair vstoreReplicationPair = this.getVstoreReplicationPairById(pairId);
        String vstoreId = vstoreReplicationPair.getLocalVstoreId();
        if (devSn.equals(vstoreReplicationPair.getRemoteDeviceSn())) {
            vstoreId = vstoreReplicationPair.getRemoteVstoreId();
        }
        if (VerifyUtil.isEmpty((String)vstoreId)) {
            logger.error((Object)"vstoreId is empty.devSn=%s, pairId=%s", new Object[]{devSn, pairId});
            throw new LegoCheckedException(1073947393L);
        }
        url = url + "?vstoreId=" + vstoreId;
        return url;
    }

    @Override
    protected String getSecondaryPairReadWrite(Map<String, String> paras, String pairId, String secVstoreAccess) {
        paras.put("ID", pairId);
        String access = secVstoreAccess;
        if (Objects.equals(access, READ_ONLY)) {
            access = "1";
        }
        paras.put("access", access);
        String url = "/rest/${deviceID}/VSTORE_PAIR/change_secondary_fs_access";
        logger.debug((Object)"setVstoreReplicationPairAccess url = %s, params = %s", new Object[]{url, paras});
        return url;
    }

    private VstoreReplicationPair getVstoreReplicationPairById(String pairId) {
        logger.debug((Object)"pairId=%s", new Object[]{pairId});
        if (VerifyUtil.isEmpty((String)pairId)) {
            throw new LegoCheckedException(1073947393L);
        }
        VstoreReplicationPair vstorePair = (VstoreReplicationPair)CommonDAOLocator.getMoDao().getMo(VstoreReplicationPair.class, "vstorePairId", (Object)pairId);
        return vstorePair;
    }
}

