/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.template.filter;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.storage.hvs.protection.util.CommonUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationUtil;
import com.huawei.ism.drm.storage.protection.template.context.PolicyTemplateContext;
import com.huawei.ism.drm.storage.protection.template.filter.ArrayAsynReplicationHyperMetroFilter;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ArrayAsyncHyperMetroDRRingFilter
extends ArrayAsynReplicationHyperMetroFilter {
    private static final Log logger = LogFactory.getInstance(ArrayAsyncHyperMetroDRRingFilter.class);
    private static final String DEVSN_AND_RES_ID_MAP = "devSn_and_resId_map";

    public int getType() {
        return 27;
    }

    protected void checkMultiCgMatch(List<ProtectObject> protectObjects) {
        this.getFilterContext().put("is_multi_hyper_metro_cg_key", Boolean.FALSE);
        HashMap<String, ProtectObject> poByGenerateId = new HashMap<String, ProtectObject>();
        ProtectObject po = (ProtectObject)protectObjects.stream().findFirst().orElseThrow(() -> new LegoCheckedException(1073947393L));
        if (po.getPoType() != 11) {
            return;
        }
        String mainDevSn = po.getProviderSN();
        ArrayList<String> resIdList = new ArrayList<String>();
        this.constructPoAndGenerateId(protectObjects, poByGenerateId, resIdList);
        List repPairs = this.getReplicationFilter().getStorageService().getReplicationPairsByResourceIds(mainDevSn, resIdList, Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
        HashMap poByCgMap = new HashMap();
        HashMap<String, Integer> siteCount = new HashMap<String, Integer>();
        int paisCountWithCG = 0;
        for (ReplicationPair repPair : repPairs) {
            String consistentGroupId = repPair.getConsistentGroupId();
            if (VerifyUtil.isEmpty((String)consistentGroupId) || consistentGroupId.equals("--")) continue;
            siteCount.compute(repPair.getTgtDevSN(), (cgId, cnt) -> {
                int n;
                if (cnt == null) {
                    n = 1;
                } else {
                    cnt = cnt + 1;
                    n = cnt;
                }
                return n;
            });
            siteCount.compute(repPair.getSrcDevSN(), (cgId, cnt) -> {
                int n;
                if (cnt == null) {
                    n = 1;
                } else {
                    cnt = cnt + 1;
                    n = cnt;
                }
                return n;
            });
            if (repPair.isStandby()) continue;
            ++paisCountWithCG;
            ArrayList<ProtectObject> poListByGroup = (ArrayList<ProtectObject>)poByCgMap.get(consistentGroupId);
            if (Objects.isNull(poListByGroup)) {
                poListByGroup = new ArrayList<ProtectObject>();
                poByCgMap.put(consistentGroupId, poListByGroup);
            }
            String generateId = this.generateDevResId(repPair.getSrcDevSN(), repPair.getLocalResType(), repPair.getSrcLunId());
            ProtectObject protectObject = (ProtectObject)poByGenerateId.get(generateId);
            poListByGroup.add(protectObject);
        }
        logger.info((Object)"Count result: paisCountWithCG=%s, siteCount=%s, poByCgMap.size=%s", new Object[]{paisCountWithCG, siteCount.size(), poByCgMap.size()});
        if (paisCountWithCG == protectObjects.size() && siteCount.size() == 3 && poByCgMap.size() > 1) {
            DRRingUtil.checkDRRingCgLimit(poByCgMap.size());
            this.getFilterContext().put("is_multi_hyper_metro_cg_key", Boolean.TRUE);
        }
    }

    private String generateDevResId(String srcDevSN, Integer localResType, String srcLunId) {
        return String.format(Locale.ROOT, "%s:%s:%s", srcDevSN, localResType, srcLunId);
    }

    private void constructPoAndGenerateId(List<ProtectObject> protectObjects, Map<String, ProtectObject> poByGenerateId, List<String> generateIdList) {
        for (ProtectObject protectObject : protectObjects) {
            String lunId = (String)protectObject.getProps().get("lunId");
            String devSn = protectObject.getProviderSN();
            String generateId = this.generateDevResId(devSn, protectObject.getPoType(), lunId);
            poByGenerateId.put(generateId, protectObject);
            generateIdList.add(lunId);
        }
    }

    protected void cascadeFilterOperation(PolicyTemplateContext context) {
        List allRelatedReplicationPairs = (List)context.getObject("DR_RING_ALL_RELATED_PAIR_LIST");
        Map<String, Collection<ReplicationPair>> productStoragePairMap = ReplicationUtil.classifyReplicationPairByProductStorageSn(allRelatedReplicationPairs);
        if (productStoragePairMap.size() != 1) {
            logger.error((Object)("the number of secodary storage should be 1, but actual is " + productStoragePairMap.size()));
            throw new LegoCheckedException(1073948191L);
        }
        Map<String, Collection<ReplicationPair>> recoveryStoragePairMap = ReplicationUtil.classifyReplicationPairBySecondaryStorageSN(allRelatedReplicationPairs);
        if (recoveryStoragePairMap.size() != 2) {
            logger.error((Object)("the number of secodary storage should be 2, but actual is " + recoveryStoragePairMap.size()));
            throw new LegoCheckedException(1073948191L);
        }
        List protectObjects = this.getProtectObjectList(context);
        List storageInfos = this.getAllStorageInfo(protectObjects);
        Map<String, Collection<ReplicationPair>> pairMap = ReplicationUtil.classifyReplicationPairByStorage(storageInfos, allRelatedReplicationPairs);
        StringBuilder pairCountNotMatched = CommonUtil.checkValueCountNotMatched(pairMap, 2);
        if (pairCountNotMatched.length() > 0) {
            logger.error((Object)("number of replication pair for each lun should be 2, but actual is " + pairCountNotMatched));
            throw new LegoCheckedException(1073948191L);
        }
        Set<String> productStorageSNList = productStoragePairMap.keySet();
        StringBuilder productStorageInconsistency = ReplicationUtil.checkProductStorageConsistency(pairMap, productStorageSNList);
        if (productStorageInconsistency.length() > 0) {
            logger.error((Object)("product storage of replication pair is inconsistent. " + productStorageInconsistency));
            throw new LegoCheckedException(1073948191L);
        }
        Set<String> recoveryStorageSNList = recoveryStoragePairMap.keySet();
        StringBuilder recoveryStorageInconsistency = ReplicationUtil.checkRecoveryStorageConsistency(pairMap, recoveryStorageSNList);
        if (recoveryStorageInconsistency.length() > 0) {
            logger.error((Object)("recovery storage of replication pair is inconsistent. " + recoveryStorageInconsistency));
            throw new LegoCheckedException(1073948191L);
        }
        StringBuilder drRingIdInconsistency = DRRingUtil.checkDRRingConsistency(pairMap);
        if (drRingIdInconsistency.length() > 0) {
            logger.error((Object)("DR Ring ID of replication pairs is inconsistent. " + drRingIdInconsistency));
            throw new LegoCheckedException(1073948191L);
        }
        Collection<ReplicationPair> normalSideReplicationPairs = DRRingUtil.getNormalPair(recoveryStoragePairMap.values(), this.isHyperMetroMultiCg());
        Collection<ReplicationPair> standbySideReplicationPairs = DRRingUtil.getStandbyPair(recoveryStoragePairMap.values(), this.isHyperMetroMultiCg());
        if (normalSideReplicationPairs.isEmpty() || normalSideReplicationPairs.size() != standbySideReplicationPairs.size()) {
            logger.error((Object)"replication pair number of normal side should not zero and as many as standby side, but actual is not. normal pair size:%s, standby pair size:%s", new Object[]{normalSideReplicationPairs.size(), standbySideReplicationPairs.size()});
            throw new LegoCheckedException(1073948191L);
        }
        List hyperMetroPairs = (List)context.getObject("PAIR_LIST");
        if (normalSideReplicationPairs.size() * 2 != hyperMetroPairs.size()) {
            logger.error((Object)"number of hyper metro pairs is not double of number of valid dr ring replication pairs.");
            throw new LegoCheckedException(1073948191L);
        }
        StringBuilder normalSideInconsistent = DRRingUtil.checkGroupConsistent(hyperMetroPairs, normalSideReplicationPairs);
        if (normalSideInconsistent.length() > 0) {
            logger.error((Object)new StringBuilder("consistent group member of normal side is not same.").append((CharSequence)normalSideInconsistent));
            throw new LegoCheckedException(1073948191L);
        }
        StringBuilder standbySideInconsistent = DRRingUtil.checkGroupConsistent(hyperMetroPairs, standbySideReplicationPairs);
        if (standbySideInconsistent.length() > 0) {
            logger.error((Object)new StringBuilder("consistent group member of standby side is not same.").append((CharSequence)standbySideInconsistent));
            throw new LegoCheckedException(1073948191L);
        }
        this.checkDRRingForCascadeFilter(allRelatedReplicationPairs, productStoragePairMap, protectObjects);
    }

    private void checkDRRingForCascadeFilter(Collection<ReplicationPair> allRelatedReplicationPairs, Map<String, Collection<ReplicationPair>> productStoragePairMap, List<ProtectObject> protectObjects) {
        String message = DRRingUtil.checkDRRingLimitsForProtectObjects(protectObjects, allRelatedReplicationPairs);
        if (message.length() > 0) {
            logger.error((Object)message);
            throw new LegoCheckedException(1073948191L);
        }
        Map<String, Collection<ReplicationPair>> drRingIdPairMap = DRRingUtil.classifyReplicationPairByDRRingId(allRelatedReplicationPairs);
        Set<String> usedDrRingIds = drRingIdPairMap.keySet();
        Set<String> productStorages = productStoragePairMap.keySet();
        StringBuilder notMatchedDRRings = DRRingUtil.checkRunningStatusNotMatchedRings(productStorages, usedDrRingIds, "1");
        if (notMatchedDRRings.length() != 0) {
            logger.error((Object)("running status of dr-ring list, must be enable. but actual:" + notMatchedDRRings));
            throw new LegoCheckedException(1073948191L);
        }
        DRRingUtil.checkDRRingsUsedByOtherProtectGroup(protectObjects, usedDrRingIds, productStorages);
    }

    protected boolean shouldCheckHyperMetroRunningStatus() {
        return false;
    }

    protected List<ReplicationPair> getReplicationPairsByLun(Lun ... lunArray) {
        if (VerifyUtil.isEmpty((Object[])lunArray)) {
            return Collections.emptyList();
        }
        List pairs = super.getReplicationPairsByLun(lunArray);
        List<Lun> resources = Arrays.asList(lunArray);
        return DRRingUtil.processDRRingReplicationPairs(pairs, resources);
    }

    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        this.isMatch(protectObjects);
        List storageInfos = this.getAllStorageInfo(protectObjects);
        return DRRingUtil.getProtectLocationPaths(protectObjects, storageInfos);
    }

    protected void checkConsistentGroup(PolicyTemplateContext context, List<HyperMetroPair> pairs, Set<String> cgs) {
        Collection protectObjects = (Collection)context.getObject("PO_LIST");
        for (ProtectObject protectObject : protectObjects) {
            this.checkConsistentGroup(context, pairs, protectObject);
        }
    }

    private void checkConsistentGroup(PolicyTemplateContext context, List<HyperMetroPair> pairs, ProtectObject protectObject) {
        pairs = DRRingUtil.getTargetHyperMetroPairsOfProtectObject(pairs, protectObject);
        Collection<String> cgs = DRRingUtil.getCgidOfHyperMetroPair(pairs);
        int drRingLimits = DRRingUtil.getDRRingLimits(protectObject);
        if (drRingLimits == 0) {
            logger.error((Object)"May encounter tampering attacks, because drRingLimits should be 1 or 2, not 0");
            throw new LegoCheckedException(1073948191L);
        }
        int limits = drRingLimits * 2;
        if (VerifyUtil.isEmpty(cgs) && pairs.size() != limits) {
            logger.error((Object)new StringBuilder("size of pairs list, must be ").append(limits).append(". but actual: ").append(pairs.size()));
            throw new LegoCheckedException(1073948191L);
        }
        limits = drRingLimits;
        if (!VerifyUtil.isEmpty(cgs) && cgs.size() != limits) {
            logger.error((Object)new StringBuilder("size of cgs list, must be ").append(limits).append(". but actual: ").append(cgs.size()));
            throw new LegoCheckedException(1073948191L);
        }
        for (String cg : cgs) {
            this.checkConsistentGroupHealthStatus(context, new HashSet<String>(Arrays.asList(cg)));
        }
    }

    protected void appendTargetLunWwn(Set<String> lunWwnSet, String errorMsg, List<ReplicationPair> pairs, PolicyTemplateContext context) {
        String tgtDevSN = null;
        HashMap<String, Set> tgtLunIdMap = new HashMap<String, Set>();
        for (ReplicationPair replicationPair : pairs) {
            if (VerifyUtil.isEmpty((Collection)replicationPair.getRepTgtLuns())) {
                logger.error((Object)"There is no tgtLun. replicationPairId: %s, errMsg=%s", new Object[]{replicationPair.getId(), errorMsg});
                throw new LegoCheckedException(1073948191L);
            }
            for (ReplicationTargetLun repTargetLun : replicationPair.getRepTgtLuns()) {
                if (repTargetLun.getPairStatus() == 110) continue;
                if (tgtDevSN != null && !tgtDevSN.equals(repTargetLun.getTgtDevSN()) && !this.isHyperMetroMultiCg()) {
                    logger.error((Object)"Device SN is not same as last, last: %s, replicationPairId: %s, TargetLUN devID: %s, TargetLUN lunID", new Object[]{tgtDevSN, replicationPair.getId(), repTargetLun.getTgtDevSN(), repTargetLun.getTgtLunId()});
                    throw new LegoCheckedException(1073948191L);
                }
                tgtDevSN = repTargetLun.getTgtDevSN();
                String tgtLunId = repTargetLun.getTgtLunId();
                Set tgtLunIdSet = tgtLunIdMap.computeIfAbsent(tgtDevSN, idSet -> new HashSet());
                tgtLunIdSet.add(tgtLunId);
            }
        }
        for (Map.Entry entry : tgtLunIdMap.entrySet()) {
            String tempTgtDevSn = (String)entry.getKey();
            Set tgtLunIdSet = (Set)entry.getValue();
            this.fillStorageResourceWwnSet(lunWwnSet, context, tempTgtDevSn, tgtLunIdSet);
        }
        Set devSnSet = tgtLunIdMap.keySet();
        if (Objects.isNull(context.getObject("REMOTE_HYPER_METRA_SITE"))) {
            context.addObject("REMOTE_HYPER_METRA_SITE", (Object)this.getSiteFromSn(tgtDevSN));
        }
        if (Objects.isNull(context.getObject("REMOTE_DEVICESN"))) {
            context.addObject("REMOTE_DEVICESN", devSnSet);
        }
        context.addObject(DEVSN_AND_RES_ID_MAP, tgtLunIdMap);
    }

    protected Set<String> getHyperMetroDeviceSN(PolicyTemplateContext context, List<Lun> resources) {
        HashSet<String> devSnSet = new HashSet<String>();
        Map tgtLunIdMap = (Map)context.getObject(DEVSN_AND_RES_ID_MAP);
        VerifyUtil.checkObject((Object)tgtLunIdMap);
        HashSet<Lun> targetLunSet = new HashSet<Lun>();
        for (Lun res : resources) {
            String devSn = res.getDevSn();
            if (VerifyUtil.isEmpty((String)devSn)) {
                logger.error((Object)"devSn is empty! storageResource: %s, id: %s,devSnSet: %s", new Object[]{res.getName(), res.getResourceId(), this.getSetStr(devSnSet)});
                throw new LegoCheckedException(1073948191L);
            }
            devSnSet.add(devSn);
            Set lunIdSet = Optional.ofNullable(tgtLunIdMap.get(devSn)).orElseGet(HashSet::new);
            if (VerifyUtil.isEmpty((Collection)lunIdSet) && tgtLunIdMap.size() == 2) {
                logger.error((Object)"RemoteDeviceSN is null! devSn=%s", new Object[]{devSn});
                throw new LegoCheckedException(1073948191L);
            }
            if (lunIdSet.contains(res.getLunId())) continue;
            targetLunSet.add(res);
        }
        context.addObject("HYPER_METRO_OTHER_RESOURCES", targetLunSet);
        return devSnSet;
    }
}

