/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.util;

import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationPairQueryAtMineSideService;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.Collections;

public class ReplicationPairQueryAtBothSideService
extends ReplicationPairQueryAtMineSideService {
    private static final ReplicationPairQueryAtBothSideService INSTANCE = new ReplicationPairQueryAtBothSideService();
    private static final Log logger = LogFactory.getInstance(ReplicationPairQueryAtBothSideService.class);
    private ISiteService siteService;
    private IResourceService resourceService;

    protected ReplicationPairQueryAtBothSideService() {
    }

    public static ReplicationPairQueryAtBothSideService getInstance() {
        return INSTANCE;
    }

    public ISiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(ISiteService siteService) {
        this.siteService = siteService;
    }

    public IResourceService getResourceService() {
        return this.resourceService;
    }

    public void setResourceService(IResourceService resourceService) {
        this.resourceService = resourceService;
    }

    @Override
    public Collection<ReplicationPair> getReplicationPairsByLun(String devSn, Collection<String> luns) {
        Site site = this.getSiteByDeviceSN(devSn);
        if (site == null) {
            logger.error((Object)"site param is null");
            return Collections.emptyList();
        }
        Collection<ReplicationPair> pairs = super.getReplicationPairsByLun(devSn, luns);
        return DRRingUtil.defaults(pairs);
    }

    protected Site getSiteByDeviceSN(String deviceSN) {
        if (deviceSN == null) {
            logger.error((Object)"deviceSN param is null");
            return null;
        }
        DrResource drResource = this.getResourceService().getDrResourceBySn(deviceSN, "ism.deviceType.storage.mainType");
        if (null != drResource) {
            return this.getSiteService().getSiteById(drResource.getSiteId());
        }
        return null;
    }
}

