/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.adapter.service.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.oracle.sdk.model.OracleInstance;
import com.huawei.ism.database.sdk.model.Database;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.util.JsonUtil;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationDiscoverer;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.model.AppStorageInfo;
import com.huawei.ism.drm.application.model.ApplicationResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.cluster.ClusterAdapter;
import com.huawei.ism.drm.db.util.DatabaseApplicationUtil;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.oracle.cluster.OracleDefaultAdapter;
import com.huawei.ism.drm.oracle.cluster.OracleHpServiceGuradAdapter;
import com.huawei.ism.drm.oracle.cluster.OraclePowerHAAdapter;
import com.huawei.ism.drm.oracle.cluster.OracleSunClusterAdapter;
import com.huawei.ism.drm.oracle.constant.OracleErrorCode;
import com.huawei.ism.drm.oracle.hostagent.action.OracleAction;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class OracleManagerImpl
implements IApplicationManager,
IApplicationDiscoverer {
    private static final Log LOGGER = LogFactory.getInstance(OracleManagerImpl.class);
    private static final int TIMES = 3;
    private static final int SLEEP_TIME = 5;
    private static final String IS_PDB = "1";
    private static final String IS_ASM = "1";
    private static final int ADG_STATUS_NORMAL = 0;
    private INeMgrProtocolExtendService neMgr;

    public OracleManagerImpl() {
        String dbAndClusterKey = "1_";
        ClusterAdapter.registerAdapter((String)dbAndClusterKey, (ClusterAdapter)new OracleDefaultAdapter());
        dbAndClusterKey = "1_" + DrmAppEnumDefine.CLUSTER_TYPE_E.DB2_HACMP.getValue();
        ClusterAdapter.registerAdapter((String)dbAndClusterKey, (ClusterAdapter)new OraclePowerHAAdapter());
        dbAndClusterKey = "1_" + DrmAppEnumDefine.CLUSTER_TYPE_E.HP_SERVICEGUARD.getValue();
        ClusterAdapter.registerAdapter((String)dbAndClusterKey, (ClusterAdapter)new OracleHpServiceGuradAdapter());
        dbAndClusterKey = "1_" + DrmAppEnumDefine.CLUSTER_TYPE_E.RHCS.getValue();
        ClusterAdapter.registerAdapter((String)dbAndClusterKey, (ClusterAdapter)new OraclePowerHAAdapter());
        dbAndClusterKey = "1_" + DrmAppEnumDefine.CLUSTER_TYPE_E.SUNCLUSTER.getValue();
        ClusterAdapter.registerAdapter((String)dbAndClusterKey, (ClusterAdapter)new OracleSunClusterAdapter());
    }

    public void setNeMgr(INeMgrProtocolExtendService neMgr) {
        this.neMgr = neMgr;
    }

    public int getAppType() {
        return 1;
    }

    public void freeze(ProtectObject po) {
        if (po == null) {
            LOGGER.error((Object)"Exec freeze, po is null.");
            throw new LegoCheckedException(1073947393L);
        }
        LOGGER.debug((Object)"Exec freeze, po is %s", new Object[]{po.getName()});
        List<ProtectObject> freezePos = OracleAppUtil.buildProtectObjects(po);
        LegoCheckedException legoException = null;
        for (ProtectObject tempPo : freezePos) {
            try {
                OracleAppUtil.checkOperationParameters(tempPo);
                ProtectObject poParam = OracleAppUtil.getOperateParam(tempPo);
                NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)tempPo.getProviderSN());
                OracleAppUtil.freezeOracle(poParam, ne);
                return;
            }
            catch (LegoCheckedException le) {
                LOGGER.error((Object)"Exec freezeDB on %s, provider: %s failed, errorMsg: %s", new Object[]{tempPo.getName(), tempPo.getProviderSN(), ExceptionUtil.getErrorMessage((Throwable)le)});
                legoException = 0L != le.getErrorCode() ? le : new LegoCheckedException(1073948171L);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Exec freezeDB on %s, provider: %s failed, errorMsg: %s", new Object[]{tempPo.getName(), tempPo.getProviderSN(), ExceptionUtil.getErrorMessage((Throwable)e)});
                legoException = new LegoCheckedException(1073948171L);
            }
        }
        if (legoException != null) {
            throw legoException;
        }
    }

    public void thaw(ProtectObject po) {
        if (null == po) {
            LOGGER.error((Object)"Exec thaw, po is null.");
            throw new LegoCheckedException(1073947393L);
        }
        LOGGER.debug((Object)"Exec thaw, poName is %s", new Object[]{po.getName()});
        List<ProtectObject> thawPos = OracleAppUtil.buildProtectObjects(po);
        LegoCheckedException legoException = null;
        for (ProtectObject tempPo : thawPos) {
            try {
                OracleAppUtil.checkOperationParameters(tempPo);
                ProtectObject poParam = OracleAppUtil.getOperateParam(tempPo);
                NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)tempPo.getProviderSN());
                OracleAppUtil.thrawOracle(poParam, ne);
                return;
            }
            catch (LegoCheckedException le) {
                LOGGER.error((Object)"Exec freezeDB on %s, provider: %s failed, errorMsg: %s", new Object[]{tempPo.getName(), tempPo.getProviderSN(), ExceptionUtil.getErrorMessage((Throwable)le)});
                legoException = 0L != le.getErrorCode() ? le : new LegoCheckedException(1073948172L);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Exec freezeDB on %s, provider: %s failed, errorMsg: %s", new Object[]{tempPo.getName(), tempPo.getProviderSN(), ExceptionUtil.getErrorMessage((Throwable)e)});
                legoException = new LegoCheckedException(1073948172L);
            }
        }
        if (null != legoException) {
            throw legoException;
        }
    }

    public void launch(ProtectObject po) {
        ClusterAdapter adapter;
        OracleAppUtil.checkOperationParameters(po);
        LOGGER.debug((Object)"Start launch, po is %s, provider: %s", new Object[]{po.getName(), po.getProviderSN()});
        String dbAndClusterKey = "1_";
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(po.getProviderSN());
        if (drResource instanceof DrHostGroup) {
            dbAndClusterKey = dbAndClusterKey + ((DrHostGroup)drResource).getClusterType();
        }
        if ((adapter = ClusterAdapter.getAdapter((String)dbAndClusterKey)) == null) {
            LOGGER.error((Object)"ClusterAdapter is null: %s", new Object[]{dbAndClusterKey});
            throw new LegoCheckedException(1073947393L);
        }
        adapter.startDatabase(po);
        LOGGER.debug((Object)"End lauch,po is %s, provider: %s", new Object[]{po.getName(), po.getProviderSN()});
    }

    public void suspend(ProtectObject po) {
        ClusterAdapter adapter;
        OracleAppUtil.checkAuthorityParameters(po);
        LOGGER.debug((Object)"Start suspend,po is %s, provider: %s", new Object[]{po.getName(), po.getProviderSN()});
        String dbAndClusterKey = "1_";
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(po.getProviderSN());
        if (drResource instanceof DrHostGroup) {
            dbAndClusterKey = dbAndClusterKey + ((DrHostGroup)drResource).getClusterType();
        }
        if ((adapter = ClusterAdapter.getAdapter((String)dbAndClusterKey)) == null) {
            LOGGER.error((Object)"ClusterAdapter is null: %s", new Object[]{dbAndClusterKey});
            throw new LegoCheckedException(1073947393L);
        }
        adapter.stopDatabase(po);
        LOGGER.debug((Object)"End suspend, po is %s, provider is: %s", new Object[]{po.getName(), po.getProviderSN()});
    }

    public void testConnecting(ProtectObject po) {
        if (po == null) {
            LOGGER.error((Object)"Test connecting, po is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (po.getPoType() == 14) {
            LOGGER.debug((Object)"The po is nas, poName = %s", new Object[]{po.getName()});
            return;
        }
        ProtectObject temp = OracleAppUtil.clone(po);
        if ("true".equalsIgnoreCase((String)temp.getProps().get("HAS_SWITCHOVER"))) {
            OracleAppUtil.updatePoPropsWithStandbyAfterSwitchover(temp);
        }
        if (DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue() == NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE")).intValue()) {
            OracleAppUtil.updateProtectObjectInstanceAndServiceName(temp);
        }
        OracleAppUtil.checkAuthorityParameters(temp);
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)temp.getProviderSN());
        String operType = (String)temp.getProps().get("OPER_TYPE");
        int opType = null != operType ? NumberUtil.convertToInteger((Object)operType) : -1;
        int times = 1;
        if (DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue() == NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE")).intValue() && 0 == opType) {
            times = 3;
        }
        this.testOracleDatabase(po, temp, ne, times);
    }

    private void testOracleDatabase(ProtectObject po, ProtectObject temp, NeMgrProtocolExtend ne, int times) {
        ProtectObject poParam = new ProtectObject();
        poParam.setProviderSN(po.getProviderSN());
        poParam.setPoType(1);
        poParam.getProps().putAll(temp.getProps());
        LegoCheckedException legoException = null;
        for (int i = 0; i < times; ++i) {
            try {
                this.testOracleDatabase(po, temp, poParam, ne);
                return;
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Test connect db(%s) on %s, errorMsg: %s", new Object[]{po.getName(), po.getProviderSN(), ExceptionUtil.getErrorMessage((Throwable)e)});
                legoException = e;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Test connect db(%s) on: %s, errorMsg: %s", new Object[]{po.getName(), po.getProviderSN(), ExceptionUtil.getErrorMessage((Throwable)e)});
                legoException = new LegoCheckedException(1073948167L);
            }
            try {
                TimeUnit.SECONDS.sleep(i + 1 < times ? 5L : 0L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"Thread error", (Throwable)e);
            }
        }
        if (null != legoException) {
            throw legoException;
        }
    }

    private void testOracleDatabase(ProtectObject po, ProtectObject temp, ProtectObject poParam, NeMgrProtocolExtend ne) {
        LOGGER.debug((Object)"Begin test oracle db(%s) on %s, ip: %s", new Object[]{po.getName(), po.getProviderSN(), ne.getNetworkIpAddress()});
        this.testOracleDatabaseConnecting(ne, poParam);
        LOGGER.debug((Object)"End test oracle db(%s) on %s, ip: %s", new Object[]{po.getName(), po.getProviderSN(), ne.getNetworkIpAddress()});
        if ("1".equals(po.getProps().get("IS_PDB"))) {
            return;
        }
        if ("1".equals(po.getProps().get("IS_ASM"))) {
            LOGGER.debug((Object)"Begin test oracle db(%s) on %s, ip: %s", new Object[]{po.getName(), po.getProviderSN(), ne.getNetworkIpAddress()});
            ProtectObject asmParam = new ProtectObject();
            asmParam.setProviderSN(po.getProviderSN());
            asmParam.setPoType(1);
            asmParam.getProps().putAll(temp.getProps());
            boolean osAuth = "1".equals(po.getProps().get("AUTH_TYPE"));
            String username = osAuth ? "" : (String)asmParam.getProps().get("ASM_USERNAME");
            asmParam.getProps().put("INSTANCENAME", asmParam.getProps().get("ASM_INSTANCENAME"));
            asmParam.getProps().put("USERNAME", username);
            if (osAuth) {
                asmParam.getProps().put("PASSWD", "");
            } else {
                asmParam.getProps().put("PASSWD", asmParam.getProps().get("ASM_PASSWD"));
            }
            this.testOracleDatabaseConnecting(ne, asmParam);
            LOGGER.debug((Object)"End test oracle asm (%s) on %s, ip: %s", new Object[]{po.getName(), po.getProviderSN(), ne.getNetworkIpAddress()});
        }
    }

    public void generateLUNDetail(ProtectObject po) {
        OracleAppUtil.checkAuthorityParameters(po);
        LOGGER.debug((Object)"Begin query storage info(%s) on %s", new Object[]{po.getName(), po.getProviderSN()});
        ProtectObject poParam = new ProtectObject();
        poParam.setPoType(1);
        poParam.getProps().putAll(po.getProps());
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)po.getProviderSN());
        try {
            OracleAction action = new OracleAction(ne, (String)ne.getExtendParams().get("mac_address"));
            Set<ProtectObjectStorageInfo> storageInfoSet = action.queryLuns(poParam.getProps());
            if (!VerifyUtil.isEmpty(storageInfoSet)) {
                DrHostUtil.updateVolumeGroupInfo(storageInfoSet, (NeMgrProtocolExtend)ne);
            }
            poParam.setUsedStorageResourceSet(storageInfoSet);
        }
        catch (LegoCheckedException le) {
            LOGGER.error((Object)"Query storage info(%s) error on %s", new Object[]{po.getName(), po.getProviderSN(), le});
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Query storage info(" + po.getName() + ") error on " + po.getProviderSN()), (long)1073948168L, null, (Log)LOGGER);
        }
        po.clearUsedStorageResource();
        for (ProtectObjectStorageInfo info : poParam.getUsedStorageResourceSet()) {
            info.setResourceType(Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
            po.addHostStorageResourceInfo(info);
        }
        LOGGER.debug((Object)"End query storage info(%s) on %s", new Object[]{po.getName(), po.getProviderSN()});
    }

    public List<ManagedObject> discoverApplication(NeMgrProtocolExtend extend) {
        ArrayList<ManagedObject> resultList = new ArrayList<ManagedObject>();
        if (extend == null) {
            LOGGER.error((Object)"Extend is null.");
            return resultList;
        }
        LOGGER.debug((Object)"Start discover oracle db on ip: %s", new Object[]{extend.getNetworkIpAddress()});
        String macAddress = (String)extend.getExtendParams().get("mac_address");
        OracleAction action = new OracleAction(extend, macAddress);
        List<DatabaseInstance> queryResult = action.queryDatabases();
        if (VerifyUtil.isEmpty(queryResult)) {
            LOGGER.info((Object)"Discover oracle db is empty, ip: %s", new Object[]{extend.getNetworkIpAddress()});
        }
        StringBuffer buffer = new StringBuffer();
        IMoDao moDao = CommonDAOLocator.getMoDao();
        for (DatabaseInstance dbInstance : queryResult) {
            DatabaseInstance oldInstance = (DatabaseInstance)moDao.getMo(DatabaseInstance.class, "uuid", (Object)dbInstance.getUuid());
            if (oldInstance != null) {
                dbInstance.setResourceGroupName(oldInstance.getResourceGroupName());
                dbInstance.setClusterName(oldInstance.getClusterName());
                dbInstance.setCluster(oldInstance.isCluster());
            }
            buffer.append(dbInstance.getName() + ",");
        }
        resultList.addAll(queryResult);
        LOGGER.info((Object)"End discover oracle db result on %s", new Object[]{extend.getNetworkIpAddress()});
        return resultList;
    }

    private void testOracleDatabaseConnecting(NeMgrProtocolExtend ne, ProtectObject param) {
        try {
            OracleAppUtil.testConnection(param, ne);
        }
        catch (LegoCheckedException le) {
            LOGGER.error((Object)"Test connecting Database(%s) error on %s, errorMsg: %s", new Object[]{param.getName(), ne.getNetworkIpAddress(), le});
            throw le;
        }
        catch (Exception e) {
            String errorMsg = "Test connecting Database(" + param.getName() + ") error on " + ne.getNetworkIpAddress();
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)1073948167L, null, (Log)LOGGER);
        }
    }

    public Set<ProtectObject> combineProtectObject(Set<ProtectObject> poSet) {
        HashSet<ProtectObject> oraclePoSet = new HashSet<ProtectObject>();
        for (ProtectObject po : poSet) {
            if (po.getPoType() != 1) continue;
            oraclePoSet.add(po);
        }
        LOGGER.debug((Object)"Combine oracle protect oObject.");
        return oraclePoSet;
    }

    public void checkEnvForFreeze(ProtectObject po) {
        if (po == null) {
            LOGGER.error((Object)"Exec checkEnvForFreeze failed, po is null.");
            return;
        }
        ProtectObject temp = OracleAppUtil.clone(po);
        if (DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue() == NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE")).intValue()) {
            OracleAppUtil.updateProtectObjectInstanceAndServiceName(temp);
        }
        OracleAppUtil.checkAuthorityParameters(temp);
        String capThreashold = (String)temp.getProps().get("ORACLE_CAP_THREASHOLD");
        LOGGER.info((Object)"Check checkEnvForFreeze, capThreashold = %s, ProviderSN = %s, poName = %s", new Object[]{capThreashold, temp.getProviderSN(), temp.getName()});
        NeMgrProtocolExtend neExtend = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)temp.getProviderSN());
        Map params = temp.getProps();
        OracleAction action = new OracleAction(neExtend, (String)neExtend.getExtendParams().get("mac_address"));
        action.checkThreshold(params);
    }

    public void checkEnvStatus(ProtectObject po) {
        String result;
        Optional<ProtectObject> poOpt = this.getAndCheckProtectObject(po);
        if (!poOpt.isPresent()) {
            LOGGER.error((Object)"Not find po.");
            return;
        }
        ProtectObject tempPo = poOpt.get();
        NeMgrProtocolExtend neExtend = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)((String)tempPo.getProps().get("hostSn")));
        Map params = tempPo.getProps();
        OracleAction action = new OracleAction(neExtend, (String)neExtend.getExtendParams().get("mac_address"));
        String instanceName = (String)params.get("INSTANCENAME");
        try {
            result = action.inspectAdgStatus(params);
        }
        catch (LegoCheckedException e) {
            if (OracleErrorCode.CONTROL_FILE_ERRORS.contains(e.getErrorCode())) {
                throw e;
            }
            LOGGER.error((Object)"Oracle ADG status is not matched, errorCode: %s", new Object[]{String.valueOf(e.getErrorCode())});
            throw new LegoCheckedException(1073948515L, new String[]{instanceName, neExtend.getNetworkIpAddress()});
        }
        LOGGER.info((Object)"Oracle ADG exist.");
        if (!this.checkAdgWorkStatus(result)) {
            LOGGER.error((Object)"Oracle adg(%s) on host(%s) status: %s illegal, need send alarm.", new Object[]{instanceName, tempPo.getProps().get("hostSn"), result});
            throw new LegoCheckedException(1073948515L, new String[]{instanceName, neExtend.getNetworkIpAddress()});
        }
    }

    private Optional<ProtectObject> getAndCheckProtectObject(ProtectObject po) {
        if (VerifyUtil.isEmpty((Object)po)) {
            LOGGER.error((Object)"The po is null when check env adg status.");
            return Optional.empty();
        }
        ProtectObject tempPo = OracleAppUtil.clone(po);
        int proType = NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE"));
        if (DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue() == proType) {
            OracleAppUtil.updateProtectObjectInstance(tempPo, po);
        } else {
            tempPo.getProps().put("hostSn", tempPo.getProviderSN());
        }
        OracleAppUtil.checkAuthorityParameters(tempPo);
        return Optional.of(tempPo);
    }

    private boolean checkAdgWorkStatus(String result) {
        if (VerifyUtil.isEmpty((String)result)) {
            LOGGER.info((Object)"Not find inspect result.");
            return true;
        }
        JSONObject json = JSONObject.fromObject((Object)result);
        return JsonUtil.getInteger((JSONObject)json, (String)"state", (Integer[])new Integer[]{0}) == 0;
    }

    public List<ApplicationResource> getAppStandbyResource(ProtectObject po) {
        String dbId = (String)po.getProps().get("DB_ID");
        if (VerifyUtil.isEmpty((String)dbId)) {
            LOGGER.error((Object)"Not find dbId, return.");
            return Collections.emptyList();
        }
        Set<String> hostSns = OracleAppUtil.getNeedCheckHosts();
        if (CollectionUtils.isEmpty(hostSns)) {
            LOGGER.error((Object)"Not hostSns, return.");
            return Collections.emptyList();
        }
        String archiveFlag = (String)po.getProps().get("ARCHIVE_LOG");
        List resultList = ExecutionService.map(hostSns, hostSn -> {
            ArrayList<ApplicationResource> resources = new ArrayList<ApplicationResource>();
            List databases = DatabaseApplicationUtil.queryAllDatabaseInstance((String)hostSn, (int)1, new HashMap());
            NeMgrProtocolExtend neExtend = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)hostSn);
            OracleAction action = new OracleAction(neExtend, (String)neExtend.getExtendParams().get("mac_address"));
            for (Database database : databases) {
                this.setResourceWithDatabase(dbId, resources, action, database, archiveFlag);
            }
            return resources;
        }, null, (int)1800, (int)20);
        return resultList.stream().filter(list -> !list.isEmpty()).map(list -> (ApplicationResource)list.get(0)).collect(Collectors.toList());
    }

    public void switchover(ProtectObject po) {
        Optional<ProtectObject> poOpt = this.getAndCheckProtectObject(po);
        if (!poOpt.isPresent()) {
            LOGGER.error((Object)"Not find po.");
            return;
        }
        ProtectObject tempPo = poOpt.get();
        Map props = tempPo.getProps();
        props.put("PASSWD", po.getProps().get("PASSWD"));
        props.put("USERNAME", po.getProps().get("USERNAME"));
        NeMgrProtocolExtend neExtend = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)((String)tempPo.getProps().get("hostSn")));
        Map params = tempPo.getProps();
        OracleAction action = new OracleAction(neExtend, (String)neExtend.getExtendParams().get("mac_address"));
        action.switchoverOracle(params);
    }

    public void config(ProtectObject po) {
        if (po == null) {
            LOGGER.error((Object)"Config oracle adg, po is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String drHostSn = po.getProperty("drHostSn");
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)drHostSn);
        this.oracleAdgConfig(ne, po);
    }

    public void adgStartup(ProtectObject po) {
        String hostSn = po.getProperty("drHostSn");
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)hostSn);
        try {
            OracleAppUtil.adgStartupDB(po, ne);
        }
        catch (LegoCheckedException le) {
            LOGGER.error((Object)"Adg start oracle(%s) error on %s, errorMsg: %s", new Object[]{po.getName(), ne.getNetworkIpAddress(), le});
            throw le;
        }
        catch (Exception e) {
            String errorMsg = "Adg start oracle(" + po.getName() + ") error on " + ne.getNetworkIpAddress();
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)1073948167L, null, (Log)LOGGER);
        }
    }

    private void oracleAdgConfig(NeMgrProtocolExtend ne, ProtectObject param) {
        try {
            OracleAppUtil.restorePreparePDB(param, ne);
        }
        catch (LegoCheckedException le) {
            LOGGER.error((Object)"Adg start oracle(%s) error on %s, errorMsg: %s", new Object[]{param.getName(), ne.getNetworkIpAddress(), le});
            throw le;
        }
        catch (Exception e) {
            String errorMsg = "Adg start oracle(" + param.getName() + ") error on " + ne.getNetworkIpAddress();
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)1073948167L, null, (Log)LOGGER);
        }
    }

    public void adgDrilling(ProtectObject po) {
        if (null == po) {
            LOGGER.error((Object)"Config oracle adg, po is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String drHostSn = po.getProperty("drHostSn");
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)drHostSn);
        this.oracleAdgDrilling(ne, po);
    }

    private void oracleAdgDrilling(NeMgrProtocolExtend ne, ProtectObject param) {
        try {
            OracleAppUtil.adgDrilling(param, ne);
        }
        catch (LegoCheckedException le) {
            LOGGER.error((Object)"Adg start oracle(%s) error on %s, errorMsg: %s", new Object[]{param.getName(), ne.getNetworkIpAddress(), le});
            throw le;
        }
        catch (Exception e) {
            String errorMsg = "Adg start oracle(" + param.getName() + ") error on " + ne.getNetworkIpAddress();
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)1073948167L, null, (Log)LOGGER);
        }
    }

    private void setResourceWithDatabase(String dbId, List<ApplicationResource> resources, OracleAction action, Database database, String archiveFlag) {
        ManagedObject managedObject = database.getParentMo();
        if (!(managedObject instanceof OracleInstance)) {
            return;
        }
        OracleInstance dbInstance = (OracleInstance)managedObject;
        if (!dbId.equals(dbInstance.getDbId())) {
            LOGGER.debug((Object)"Not need to check dbName: %s", new Object[]{database.getName()});
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DB_ID", dbId);
        params.put("INSTANCENAME", dbInstance.getInstanceName());
        if (action.checkIsAdgStandbyHost(params)) {
            Optional<ApplicationResource> opt = this.getOracleAdgResourceInfo(action, database, dbInstance, archiveFlag);
            opt.ifPresent(resources::add);
        }
    }

    private Optional<ApplicationResource> getOracleAdgResourceInfo(OracleAction action, Database database, OracleInstance oracleInstance, String archiveFlag) {
        Optional infoOpt;
        HashMap<String, String> getLunsMap = new HashMap<String, String>();
        getLunsMap.put("INSTANCENAME", oracleInstance.getInstanceName());
        getLunsMap.put("DATABASES", database.getName());
        getLunsMap.put("ORACLE_HOME", oracleInstance.getOracleHome());
        getLunsMap.put("ARCHIVE_LOG", "0");
        Set<ProtectObjectStorageInfo> storageInfos = action.queryLuns(getLunsMap);
        Set storageInfosForArchive = Collections.emptySet();
        if ("1".equals(archiveFlag)) {
            getLunsMap.put("ARCHIVE_LOG", archiveFlag);
            storageInfosForArchive = action.queryLuns(getLunsMap);
            storageInfosForArchive = Optional.ofNullable(storageInfosForArchive).orElseGet(Collections::emptySet);
        }
        if (!(infoOpt = storageInfos.stream().findFirst()).isPresent()) {
            LOGGER.error((Object)"Not find po storage info by database: %s", new Object[]{database.getName()});
            return Optional.empty();
        }
        ApplicationResource resource = new ApplicationResource();
        resource.setDevSn(((ProtectObjectStorageInfo)infoOpt.get()).getResourceProviderSN());
        resource.setHostSn(action.getDevSn());
        Set<AppStorageInfo> infoSet = this.getAppStorageInfos(storageInfos, false);
        infoSet.addAll(this.getAppStorageInfos(storageInfosForArchive, true));
        resource.setAppStorageInfos(infoSet);
        HashMap<String, String> extendMap = new HashMap<String, String>();
        extendMap.put("STANDBY_DB_NAME", database.getName());
        resource.setExtendParams(extendMap);
        return Optional.of(resource);
    }

    private Set<AppStorageInfo> getAppStorageInfos(Set<ProtectObjectStorageInfo> storageInfos, boolean isArchive) {
        HashSet<AppStorageInfo> infoSet = new HashSet<AppStorageInfo>();
        for (ProtectObjectStorageInfo storageInfo : storageInfos) {
            AppStorageInfo info = new AppStorageInfo();
            info.setResourceId(storageInfo.getResourceId());
            info.setWwn(storageInfo.getLunWWN());
            info.setMountPoint(storageInfo.getMountPoint());
            info.setAsmDg(storageInfo.getAsmDiskGroupName());
            info.setVgName(storageInfo.getVolumeGroupName());
            info.setDeviceName(storageInfo.getDeviceName());
            info.setAsmDgType(storageInfo.getAsmDiskGroupType());
            infoSet.add(info);
        }
        return infoSet;
    }
}

