/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.cluster;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.cluster.ClusterAdapter;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Map;

public class OracleDefaultAdapter
extends ClusterAdapter {
    private static final Log LOGGER = LogFactory.getInstance(OracleDefaultAdapter.class);

    public void startDatabase(ProtectObject po) {
        if (null == po) {
            LOGGER.error((Object)"start db,po is null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        LOGGER.debug((Object)("begin start db(" + po.getName() + "," + po.getProviderSN() + ")."), 90160758786988L);
        ProtectObject temp = OracleAppUtil.clone(po);
        if (DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue() == NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE")).intValue()) {
            OracleAppUtil.updateProtectObjectInstanceAndServiceName(temp);
        }
        Map params = temp.getProps();
        String cluster = (String)po.getProps().get("DISASTER_IS_CLUSTER");
        if (VerifyUtil.isEmpty((String)cluster) || !"1".equals(cluster)) {
            cluster = "0";
        }
        params.put("IS_CLUSTER", cluster);
        if (!params.containsKey("APP_VERSION")) {
            params.put("APP_VERSION", params.get("VERSION"));
        }
        ProtectObject poParam = OracleAppUtil.getOperateParam(temp);
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)temp.getProviderSN());
        try {
            OracleAppUtil.startOracleDatabase(poParam, ne);
            LOGGER.info((Object)("start db(" + poParam.getName() + ") success in " + ne.getNetworkIpAddress()), 90160758786988L);
        }
        catch (LegoCheckedException le) {
            LOGGER.error((Object)("start db(" + po.getName() + ") error in " + ne.getNetworkIpAddress()), (Throwable)le, 90160758786989L);
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("start db(" + po.getName() + ") error in " + ne.getNetworkIpAddress()), (long)1073948170L, null, (Log)LOGGER);
        }
    }

    public void stopDatabase(ProtectObject po) {
        if (null == po) {
            LOGGER.error((Object)"stop db,po is null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        LOGGER.debug((Object)("stop db(" + po.getName() + "," + po.getProviderSN() + ")."), 90160758786988L);
        ProtectObject temp = OracleAppUtil.clone(po);
        boolean cluster = false;
        if (DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue() == NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE")).intValue()) {
            cluster = true;
            OracleAppUtil.updateProtectObjectInstanceAndServiceName(temp);
        }
        Map params = temp.getProps();
        params.put("IS_CLUSTER", cluster ? "1" : "0");
        if (!params.containsKey("APP_VERSION")) {
            params.put("APP_VERSION", params.get("VERSION"));
        }
        ProtectObject poParam = OracleAppUtil.getOperateParam(temp);
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)temp.getProviderSN());
        try {
            if ("1".equals(po.getProps().get("IS_CLOSE_ASM"))) {
                OracleAppUtil.stopAsmInstance(poParam, ne);
                LOGGER.info((Object)("stop asm success in " + ne.getNetworkIpAddress()), 90160758786988L);
            } else {
                OracleAppUtil.stopOracleDatabase(poParam, ne);
                LOGGER.info((Object)("stop db(" + poParam.getName() + ") success in " + ne.getNetworkIpAddress()), 90160758786988L);
            }
        }
        catch (LegoCheckedException le) {
            LOGGER.error((Object)("stop  db or asm(" + po.getName() + ") error."), (Throwable)le, 90160758786989L);
            throw le;
        }
        catch (Exception e) {
            String errorMsg = "stop db or asm(" + po.getName() + ")  error.";
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)1073948169L, null, (Log)LOGGER);
        }
    }
}

