/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.hostagent.action;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.oracle.sdk.model.OracleDatabase;
import com.huawei.ism.database.oracle.sdk.model.OracleInstance;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.util.JsonUtil;
import com.huawei.ism.drm.host.agent.action.AgentRestAction;
import com.huawei.ism.drm.oracle.hostagent.action.OracleActionApi;
import com.huawei.ism.drm.oracle.hostagent.action.OracleParam;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OracleAction
extends AgentRestAction {
    private final OracleActionApi api;

    public OracleAction(NeMgrProtocolExtend extend, String devSn) {
        super(extend, devSn);
        this.api = OracleActionApi.create(extend, devSn);
    }

    public List<DatabaseInstance> queryDatabases() {
        String result = this.api.queryDatabases();
        if (this.isResultEmpty(result)) {
            LOGGER.debug((Object)("query oracle database is null,IP:" + this.getExtend().getNetworkIpAddress()));
            return Collections.emptyList();
        }
        JSONArray myJsonArray = JSONArray.fromObject((Object)result);
        HashMap<String, OracleInstance> instanceMap = new HashMap<String, OracleInstance>();
        for (Object obj : myJsonArray) {
            JSONObject jsonObject = JSONObject.fromObject(obj);
            String instanceName = JsonUtil.getString((JSONObject)jsonObject, (String)"instName", (String[])new String[]{""});
            String dbName = JsonUtil.getString((JSONObject)jsonObject, (String)"dbName", (String[])new String[]{""});
            if (VerifyUtil.isEmpty((String)dbName)) {
                LOGGER.debug((Object)"DbName is null,instanceName: %s", new Object[]{instanceName});
                continue;
            }
            String dbVersion = JsonUtil.getString((JSONObject)jsonObject, (String)"version", (String[])new String[]{""});
            String dbStatus = JsonUtil.getString((JSONObject)jsonObject, (String)"state", (String[])new String[]{""});
            String dbId = JsonUtil.getString((JSONObject)jsonObject, (String)"dbId", (String[])new String[]{""});
            String isAsmInst = JsonUtil.getString((JSONObject)jsonObject, (String)"isAsmInst", (String[])new String[]{""});
            String oracleHome = JsonUtil.getString((JSONObject)jsonObject, (String)"oracleHome", (String[])new String[]{""});
            OracleInstance oracleInstance = (OracleInstance)instanceMap.get(instanceName);
            if (oracleInstance == null) {
                oracleInstance = new OracleInstance();
                oracleInstance.setOracleHome(oracleHome);
                oracleInstance.setDbId(dbId);
                oracleInstance.setInstanceName(instanceName);
                oracleInstance.setDbVersion(dbVersion);
                oracleInstance.setDbType(1);
                oracleInstance.setServiceName(dbName);
                oracleInstance.setUseAsm(Boolean.valueOf("1".equals(isAsmInst)));
                oracleInstance.setHostSN(this.getDevSn());
                oracleInstance.setName(instanceName);
                oracleInstance.setUuid(this.getDevSn() + ":" + instanceName);
                instanceMap.put(instanceName, oracleInstance);
            }
            OracleDatabase database = new OracleDatabase();
            database.setDbStatus(dbStatus);
            database.setName(dbName);
            String uuId = oracleInstance.getUuid() + ":" + dbName.hashCode();
            database.setUuid(uuId);
            oracleInstance.addChildMo((ManagedObject)database);
            database.setParentMo((ManagedObject)oracleInstance);
        }
        return new ArrayList<DatabaseInstance>(instanceMap.values());
    }

    public Set<ProtectObjectStorageInfo> queryLuns(Map<String, String> params) {
        if (VerifyUtil.isEmpty(params)) {
            LOGGER.error((Object)"query lun,params is null.");
            return null;
        }
        HashSet<ProtectObjectStorageInfo> resources = new HashSet<ProtectObjectStorageInfo>();
        String instanceName = params.get("INSTANCENAME");
        String databaseName = params.get("DATABASES");
        String asmInstName = this.getParamValue(params, "ASM_INSTANCENAME", "");
        String isArchieve = this.getParamValue(params, "ARCHIVE_LOG", "0");
        String oracleHome = this.getParamValue(params, "ORACLE_HOME", "");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setInstanceName(instanceName);
        oracleParam.setDatabaseName(databaseName);
        oracleParam.setAsmInstName(asmInstName);
        oracleParam.setIsArchieve(isArchieve);
        oracleParam.setOracleHome(oracleHome);
        oracleParam.setExtendParam(params);
        String result = this.api.queryLunList(oracleParam);
        if (this.isResultEmpty(result)) {
            LOGGER.debug((Object)("query lun resturn null,db=" + databaseName + ",isArchieve=" + isArchieve));
            return resources;
        }
        JSONArray myJsonArray = JSONArray.fromObject((Object)result);
        for (Object obj : myJsonArray) {
            JSONObject jsonObject = JSONObject.fromObject(obj);
            ProtectObjectStorageInfo resource = new ProtectObjectStorageInfo();
            resource.setResourceId(JsonUtil.getString((JSONObject)jsonObject, (String)"lunId", (String[])new String[]{""}));
            resource.setResourceProviderSN(JsonUtil.getString((JSONObject)jsonObject, (String)"arraySn", (String[])new String[]{""}));
            resource.setLunWWN(JsonUtil.getString((JSONObject)jsonObject, (String)"wwn", (String[])new String[]{""}));
            resource.setVolumeGroupName(JsonUtil.getString((JSONObject)jsonObject, (String)"vgName", (String[])new String[]{""}));
            resource.setDeviceName(JsonUtil.getString((JSONObject)jsonObject, (String)"deviceName", (String[])new String[]{""}));
            resource.setStorageSubType(JsonUtil.getInteger((JSONObject)jsonObject, (String)"volType", (Integer[])new Integer[]{0}));
            resource.setLabAddress(JsonUtil.getString((JSONObject)jsonObject, (String)"LBA", (String[])new String[]{""}));
            this.setStorageType(resource, JsonUtil.getString((JSONObject)jsonObject, (String)"lunId", (String[])new String[]{""}), JsonUtil.getString((JSONObject)jsonObject, (String)"arraySn", (String[])new String[]{""}), JsonUtil.getString((JSONObject)jsonObject, (String)"deviceType", (String[])new String[]{""}));
            resource.setPvName(JsonUtil.getString((JSONObject)jsonObject, (String)"uuid", (String[])new String[]{""}));
            resource.setMountPoint(JsonUtil.getString((JSONObject)jsonObject, (String)"devicePath", (String[])new String[]{""}));
            resource.setAsmDiskGroupName(JsonUtil.getString((JSONObject)jsonObject, (String)"asmDiskGroup", (String[])new String[]{""}));
            resource.setUdevFlag(JsonUtil.getString((JSONObject)jsonObject, (String)"udevRules", (String[])new String[]{""}));
            resource.setPvName(JsonUtil.getString((JSONObject)jsonObject, (String)"pvName", (String[])new String[]{""}));
            resource.setAsmDiskGroupType(JsonUtil.getString((JSONObject)jsonObject, (String)"asmDiskGroupType", (String[])new String[]{""}));
            resource.setAppName(this.getDevSn());
            resources.add(resource);
        }
        return resources;
    }

    public void startDatabase(Map<String, String> params) {
        if (VerifyUtil.isEmpty(params)) {
            LOGGER.error((Object)"start db,params is null.", 90160758786989L);
            return;
        }
        String instanceName = params.get("INSTANCENAME");
        String databaseName = params.get("DATABASES");
        String version = params.get("VERSION");
        String isASM = this.getParamValue(params, "IS_ASM", "0");
        String asmInstName = this.getParamValue(params, "ASM_INSTANCENAME", "");
        String oracleHome = this.getParamValue(params, "ORACLE_HOME", "");
        String asmDiskGroups = this.getParamValue(params, "ASMGroupName", "");
        String isIncludeArchLog = this.getParamValue(params, "ARCHIVE_LOG", "0");
        String logLunTag = this.getParamValue(params, "SHARE_LOG_LUN", "1");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setInstanceName(instanceName);
        oracleParam.setDatabaseName(databaseName);
        oracleParam.setVersion(version);
        oracleParam.setIsASM(isASM);
        oracleParam.setAsmInstName(asmInstName);
        oracleParam.setAsmDiskGroups(asmDiskGroups);
        oracleParam.setOracleHome(oracleHome);
        oracleParam.setExtendParam(params);
        if ("0".equals(logLunTag)) {
            oracleParam.setIsIncludeArchLog("0");
        } else {
            oracleParam.setIsIncludeArchLog(isIncludeArchLog);
        }
        this.api.startDatabase(oracleParam);
    }

    public void stopDatabase(Map<String, String> params) {
        if (VerifyUtil.isEmpty(params)) {
            LOGGER.error((Object)"stop db,params is null.");
            return;
        }
        String instanceName = params.get("INSTANCENAME");
        String databaseName = params.get("DATABASES");
        String version = params.get("VERSION");
        String isASM = this.getParamValue(params, "IS_ASM", "0");
        String asmInstName = this.getParamValue(params, "ASM_INSTANCENAME", "");
        String asmDiskGroups = this.getParamValue(params, "ASMGroupName", "");
        String oracleHome = this.getParamValue(params, "ORACLE_HOME", "");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setInstanceName(instanceName);
        oracleParam.setDatabaseName(databaseName);
        oracleParam.setVersion(version);
        oracleParam.setIsASM(isASM);
        oracleParam.setAsmInstName(asmInstName);
        oracleParam.setAsmDiskGroups(asmDiskGroups);
        oracleParam.setOracleHome(oracleHome);
        oracleParam.setExtendParam(params);
        this.api.stopDatabase(oracleParam);
    }

    public void testConnection(Map<String, String> params) {
        if (VerifyUtil.isEmpty(params)) {
            LOGGER.error((Object)"test db,params is null.");
            return;
        }
        String instanceName = params.get("INSTANCENAME");
        String databaseName = params.get("DATABASES");
        String oracleHome = this.getParamValue(params, "ORACLE_HOME", "");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setInstanceName(instanceName);
        oracleParam.setDatabaseName(databaseName);
        oracleParam.setOracleHome(oracleHome);
        oracleParam.setExtendParam(params);
        this.api.testConnection(oracleParam);
    }

    public String queryDatabaseAuth(Map<String, String> params) {
        if (VerifyUtil.isEmpty(params)) {
            LOGGER.error((Object)"database auth, params is null or empty");
            return null;
        }
        String instanceName = params.get("INSTANCENAME");
        String oracleHome = this.getParamValue(params, "ORACLE_HOME", "");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setInstanceName(instanceName);
        oracleParam.setOracleHome(oracleHome);
        oracleParam.setExtendParam(params);
        return this.api.queryDatabaseAuth(oracleParam);
    }

    public String queryPlugDatabase(Map<String, String> params) {
        if (VerifyUtil.isEmpty(params)) {
            LOGGER.error((Object)"query pdbs db, params is null or empty");
            return null;
        }
        String instanceName = params.get("INSTANCENAME");
        String oracleHome = this.getParamValue(params, "ORACLE_HOME", "");
        String pdbName = this.getParamValue(params, "PDB_NAME", "");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setPdbName(pdbName);
        oracleParam.setInstanceName(instanceName);
        oracleParam.setOracleHome(oracleHome);
        oracleParam.setExtendParam(params);
        String result = this.api.queryPlugDatabase(oracleParam);
        if (VerifyUtil.isEmpty((String)result)) {
            LOGGER.debug((Object)("query pdbs db,result is null, pdbName=" + pdbName + ",instName=" + instanceName));
            return null;
        }
        JSONArray list = new JSONArray();
        for (Object obj : JSONArray.fromObject((Object)result)) {
            JSONObject pdb = JSONObject.fromObject(obj);
            pdb.put((Object)"type", (Object)DrmAppEnumDefine.PDB_NAME_TYPE.getValue((String)pdb.getString("pdbName")));
            list.add((Object)pdb);
        }
        return list.toString();
    }

    public void freeze(Map<String, String> params) {
        if (VerifyUtil.isEmpty(params)) {
            LOGGER.error((Object)"freeze, params is null or empty.");
            return;
        }
        String instanceName = params.get("INSTANCENAME");
        String databaseName = params.get("DATABASES");
        String oracleHome = this.getParamValue(params, "ORACLE_HOME", "");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setInstanceName(instanceName);
        oracleParam.setDatabaseName(databaseName);
        oracleParam.setOracleHome(oracleHome);
        oracleParam.setExtendParam(params);
        this.api.freeze(oracleParam);
    }

    public void thraw(Map<String, String> params) {
        if (VerifyUtil.isEmpty(params)) {
            LOGGER.error((Object)"thraw, params is null or empty.");
            return;
        }
        String instanceName = params.get("INSTANCENAME");
        String databaseName = params.get("DATABASES");
        String oracleHome = this.getParamValue(params, "ORACLE_HOME", "");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setInstanceName(instanceName);
        oracleParam.setDatabaseName(databaseName);
        oracleParam.setOracleHome(oracleHome);
        oracleParam.setExtendParam(params);
        this.api.thaw(oracleParam);
    }

    public void forcedArchive(Map<String, String> params) {
        if (VerifyUtil.isEmpty(params)) {
            LOGGER.error((Object)"forced archive,params is null or empty.");
            return;
        }
        String instanceName = params.get("INSTANCENAME");
        String databaseName = params.get("DATABASES");
        String oracleHome = this.getParamValue(params, "ORACLE_HOME", "");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setInstanceName(instanceName);
        oracleParam.setDatabaseName(databaseName);
        oracleParam.setOracleHome(oracleHome);
        oracleParam.setExtendParam(params);
        this.api.forcedArchive(oracleParam);
    }

    public void checkThreshold(Map<String, String> params) {
        String instanceName = params.get("INSTANCENAME");
        String asmInstName = this.getParamValue(params, "ASM_INSTANCENAME", "");
        String capThreshold = params.get("ORACLE_CAP_THREASHOLD");
        String oracleHome = this.getParamValue(params, "ORACLE_HOME", "");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setInstanceName(instanceName);
        oracleParam.setAsmInstName(asmInstName);
        oracleParam.setCapThreshold(capThreshold);
        oracleParam.setOracleHome(oracleHome);
        oracleParam.setExtendParam(params);
        this.api.checkThreshold(oracleParam);
    }

    public void startAsmInstance(Map<String, String> params) {
        if (VerifyUtil.isEmpty(params)) {
            LOGGER.error((Object)"start asm,params is null or empty.");
            return;
        }
        String instanceName = params.get("ASM_INSTANCENAME");
        String asmDiskGroups = params.get("ASMGroupName");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setInstanceName(instanceName);
        oracleParam.setAsmDiskGroups(asmDiskGroups);
        oracleParam.setExtendParam(params);
        this.api.startAsmInstance(oracleParam);
    }

    public String inspectAdgStatus(Map<String, String> params) {
        String instanceName = params.get("INSTANCENAME");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setInstanceName(instanceName);
        oracleParam.setExtendParam(params);
        return this.api.inspectAdgStatus(oracleParam);
    }

    public boolean checkIsAdgStandbyHost(Map<String, String> params) {
        String dbId = params.get("DB_ID");
        String instanceName = params.get("INSTANCENAME");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setDbId(dbId);
        oracleParam.setInstanceName(instanceName);
        oracleParam.setExtendParam(params);
        String result = this.api.queryAdgStandby(oracleParam);
        if (VerifyUtil.isEmpty((String)result)) {
            LOGGER.debug((Object)"Query oracle adg standby failed, result is null, dbId: %s, instanceName: %s", new Object[]{dbId, instanceName});
            return false;
        }
        JSONObject json = JSONObject.fromObject((Object)result);
        String isAdgStandby = JsonUtil.getString((JSONObject)json, (String)"isAdgStandby", (String[])new String[]{""});
        return "true".equalsIgnoreCase(isAdgStandby);
    }

    public void switchoverOracle(Map<String, String> params) {
        String databaseName = params.get("DATABASES");
        String instanceName = params.get("INSTANCENAME");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setDatabaseName(databaseName);
        oracleParam.setInstanceName(instanceName);
        oracleParam.setExtendParam(params);
        this.api.switchoverDatabase(oracleParam);
    }

    public void stopAsmInstance(Map<String, String> params) {
        if (VerifyUtil.isEmpty(params)) {
            LOGGER.error((Object)"stop asm,params is null or empty.");
            return;
        }
        String instanceName = params.get("INSTANCENAME");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setInstanceName(instanceName);
        oracleParam.setExtendParam(params);
        this.api.stopAsmInstance(oracleParam);
    }

    private String getParamValue(Map<String, String> params, String key, String defaultValue) {
        String value = params.get(key);
        if (null == value) {
            value = defaultValue;
        }
        return value;
    }

    public void startPDB(Map<String, String> params) {
        if (VerifyUtil.isEmpty(params)) {
            LOGGER.error((Object)"startPDB,params is null or empty.");
            return;
        }
        String instName = params.get("INSTANCENAME");
        String oracleHome = this.getParamValue(params, "ORACLE_HOME", "");
        String pdbName = params.get("PDB_NAME");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setInstanceName(instName);
        oracleParam.setOracleHome(oracleHome);
        oracleParam.setPdbName(pdbName);
        oracleParam.setExtendParam(params);
        this.api.startPDB(oracleParam);
    }

    public void testPDB(Map<String, String> params) {
        if (VerifyUtil.isEmpty(params)) {
            LOGGER.error((Object)"testPDB, params is null or empty.");
            return;
        }
        String result = this.queryPlugDatabase(params);
        String pdbName = params.get("PDB_NAME");
        JSONArray myJsonArray = JSONArray.fromObject((Object)result);
        JSONObject jsonObject = JSONObject.fromObject((Object)myJsonArray.get(0));
        String name = JsonUtil.getString((JSONObject)jsonObject, (String)"pdbName", (String[])new String[]{""});
        String status = JsonUtil.getString((JSONObject)jsonObject, (String)"status", (String[])new String[]{""});
        if (!pdbName.equals(name) || !"2".equals(status)) {
            LOGGER.error((Object)("testPDB " + pdbName + " fail."));
            throw new LegoCheckedException(1073948956L);
        }
        LOGGER.info((Object)("testPDB " + pdbName + ", success."));
    }

    public void replaceUdevRule(Map<String, String> params) {
        if (VerifyUtil.isEmpty(params)) {
            LOGGER.error((Object)"ReplaceUdevRule, params is null or empty.");
            return;
        }
        this.buildHeaders(params);
        String databaseName = params.get("DATABASES");
        String lunMapping = params.get("lunMapping");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setDatabaseName(databaseName);
        oracleParam.setLunMapping(lunMapping);
        oracleParam.setExtendParam(new HashMap<String, String>());
        this.api.replaceUdevRule(oracleParam);
    }

    public void adgStartupDb(Map<String, String> params) {
        if (VerifyUtil.isEmpty(params)) {
            LOGGER.warn((Object)"AdgStartupDb, params is null or empty.");
            return;
        }
        this.buildHeaders(params);
        String instName = params.get("INSTANCENAME");
        String password = params.get("PASSWD");
        String databaseName = params.get("DB_NAMES");
        String pdbName = params.get("PDB_NAME");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setInstanceName(instName);
        oracleParam.setDatabaseName(databaseName);
        oracleParam.setPdbName(pdbName);
        oracleParam.setDatabasePassword(password);
        this.api.adgRecovery(oracleParam);
    }

    public void replaceUdevRuleDrilling(Map<String, String> params) {
        if (VerifyUtil.isEmpty(params)) {
            LOGGER.error((Object)"ReplaceUdevRule, params is null or empty.");
            return;
        }
        this.buildHeaders(params);
        String databaseName = params.get("DATABASES");
        String dataWwn = params.get("dataWwn");
        String redoWwn = params.get("redoWwn");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setDatabaseName(databaseName);
        oracleParam.setDataLunWwn(dataWwn);
        oracleParam.setRedoLunWwn(redoWwn);
        this.api.adgDrilling(oracleParam);
    }

    public void cleanDrilling(Map<String, String> params) {
        if (VerifyUtil.isEmpty(params)) {
            LOGGER.warn((Object)"Clean drilling, params is empty.");
            return;
        }
        this.buildHeaders(params);
        String databaseName = params.get("DATABASES");
        OracleParam oracleParam = new OracleParam();
        oracleParam.setDatabaseName(databaseName);
        oracleParam.setDataLunWwn(params.get("dataWwn"));
        oracleParam.setRedoLunWwn(params.get("redoWwn"));
        this.api.cleanDrilling(oracleParam);
    }
}

