/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.protect.action;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.operation.sdk.model.OperationResultBill;
import com.huawei.ism.drm.oracle.protect.action.OracleAsyncReplicateAction;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OracleArchieveAsyncReplicateAction
extends OracleAsyncReplicateAction {
    private static final Log LOGGER = LogFactory.getInstance(OracleArchieveAsyncReplicateAction.class);

    public void preExcute(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        boolean archieveLog = OracleAppUtil.isProtectArchieveLog(protectGroup.getPolist());
        this.setEnable(archieveLog);
    }

    @Override
    public Set<RelicaStorageInfo> filterStorageInfo(Set<String> archieveLogWwn, Set<RelicaStorageInfo> replicaStorageInfos) {
        HashSet<RelicaStorageInfo> storageInfos = new HashSet<RelicaStorageInfo>();
        if (VerifyUtil.isEmpty(archieveLogWwn)) {
            LOGGER.error((Object)"filter storageInfo,archieveLogWwn is valid.", 90160758786989L);
            return storageInfos;
        }
        if (VerifyUtil.isEmpty(replicaStorageInfos)) {
            LOGGER.error((Object)"filter storageInfo,replicaStorageInfos is valid.", 90160758786989L);
            return storageInfos;
        }
        StringBuffer buffer = new StringBuffer();
        for (RelicaStorageInfo relicaStorageInfo : replicaStorageInfos) {
            if (!archieveLogWwn.contains(relicaStorageInfo.getProtectObjectStorageWwn())) continue;
            storageInfos.add(relicaStorageInfo);
            buffer.append(relicaStorageInfo.getProtectObjectStorageWwn() + ",");
        }
        LOGGER.debug((Object)("filter storageInfo,archieveLogWwn\uff1a" + archieveLogWwn + ",result:" + buffer), 90160758786988L);
        return storageInfos;
    }

    protected boolean asyncReplicate(ActionContext context) {
        boolean flag = false;
        List bos = this.getReplicationRelationBos(context);
        try {
            if (this.checkSyncReplicationRelation(bos)) {
                return true;
            }
            if (!this.checkReplicationRelation(bos)) {
                LOGGER.error((Object)"Sync is running.");
                return flag;
            }
            IRecoveryProcessHandler recoveryProcHandler = (IRecoveryProcessHandler)RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
            for (ReplicationRelationBo obj : bos) {
                LOGGER.debug((Object)"Begin to sync once {srcSN: %s, tgtSN: %s, replicationID: %s, isConsistGroup: %s}", new Object[]{obj.getSrcDeviceSn(), obj.getTgtDeviceSn(), obj.getReplicationId(), obj.isConsistentGroup()});
                OperationResultBill optResultBill = recoveryProcHandler.synchronize(obj.getReplicationId(), obj.getSrcDeviceSn(), obj.getTgtDeviceSn(), obj.isConsistentGroup());
                if (null != optResultBill && optResultBill.isHasFailRecord()) {
                    OperationResult optResult = (OperationResult)optResultBill.getOperationResults().get(0);
                    LOGGER.error((Object)"Sync failed {srcSN: %s, tgtSN: %s, replicationID: %s, isConsistGroup: %s, errorCode: %s}", new Object[]{obj.getSrcDeviceSn(), obj.getTgtDeviceSn(), obj.getReplicationId(), obj.isConsistentGroup(), optResult.getErrorCode()});
                    this.setDetail("lego.err.1073948448");
                    return flag;
                }
                LOGGER.debug((Object)"End to sync once: %s", new Object[]{obj.getReplicationId()});
            }
            LOGGER.debug((Object)"BaseAsyncReplicateAction end to execute!");
            flag = true;
            return flag;
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            LOGGER.error((Object)"BaseAsyncReplicateAction executed failed!", (Throwable)e);
            return flag;
        }
        catch (Exception e) {
            this.setDetail("lego.err.1073948448");
            LOGGER.error((Object)("BaseAsyncReplicateAction executed failed!" + ExceptionUtil.getErrorMessage((Throwable)e)), 1073948448L);
            return flag;
        }
    }
}

