/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.protect.action;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.CloneConsistentGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.HyperClonePair;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.StorageHyperCloneReplica;
import com.huawei.ism.drm.storage.protection.action.SplitMultiHyperCloneSubAction;
import com.huawei.ism.drm.storage.protection.util.HyperCloneProtectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OracleSplitDataHyperCloneAction
extends SplitMultiHyperCloneSubAction {
    protected Set<HyperClonePair> groupHyperClonePairs(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        List<String> dataLunIds = this.getDataLunIds(protectGroup);
        HashSet<HyperClonePair> storageInfos = new HashSet<HyperClonePair>();
        Set pgReplicaList = protectGroup.getReplicaList();
        if (VerifyUtil.isEmpty((Collection)pgReplicaList)) {
            ProtectGroupReplica pgReplica = HyperCloneProtectionUtil.createProtectGroupReplica((ProtectGroup)protectGroup, (CloneConsistentGroup)((CloneConsistentGroup)context.getObject("CloneCG")));
            this.generatePoReplicas(dataLunIds, storageInfos, pgReplica);
            return storageInfos;
        }
        for (ProtectGroupReplica pgReplica : protectGroup.getReplicaList()) {
            this.generatePoReplicas(dataLunIds, storageInfos, pgReplica);
        }
        return storageInfos;
    }

    private void generatePoReplicas(List<String> dataLunIds, Set<HyperClonePair> storageInfos, ProtectGroupReplica pgReplica) {
        for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
            this.generateHyperClonePairs(dataLunIds, storageInfos, poReplica);
        }
    }

    private void generateHyperClonePairs(List<String> dataLunIds, Set<HyperClonePair> storageInfos, ProtectObjectReplica poReplica) {
        for (RelicaStorageInfo storageInfo : poReplica.getStorageInfos()) {
            if (!dataLunIds.contains(storageInfo.getSrcStorageId())) continue;
            StorageHyperCloneReplica replica = (StorageHyperCloneReplica)storageInfo;
            HyperClonePair hyperClonePair = new HyperClonePair();
            hyperClonePair.setDeviceSn(replica.getSrcStorageProviderSN());
            hyperClonePair.setSrcLunId(replica.getSrcStorageId());
            hyperClonePair.setTgtLunId(replica.getStorageId());
            hyperClonePair.setPairId(replica.getPairId());
            storageInfos.add(hyperClonePair);
        }
    }

    private List<String> getDataLunIds(ProtectGroup protectGroup) {
        ArrayList<String> dataLunIds = new ArrayList<String>();
        if (VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            return dataLunIds;
        }
        for (ProtectObject po : protectGroup.getPolist()) {
            Set storageInfoSet = po.getUsedStorageResourceSet();
            if (VerifyUtil.isEmpty((Collection)storageInfoSet)) {
                return dataLunIds;
            }
            for (ProtectObjectStorageInfo storageInfo : storageInfoSet) {
                if (storageInfo.getArchiveLog() != 0) continue;
                dataLunIds.add(storageInfo.getResourceId());
            }
        }
        return dataLunIds;
    }
}

