/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.protect.template.filter;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.drm.app.util.JsonUtil;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.application.model.AppStorageInfo;
import com.huawei.ism.drm.application.model.ApplicationResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.sdk.service.IHostService;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.oracle.constant.OracleConst;
import com.huawei.ism.drm.oracle.hostagent.action.OracleAction;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.template.context.PolicyTemplateContext;
import com.huawei.ism.drm.storage.protection.template.filter.ArraySyncReplicationFilter;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.util.CastUtil;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class OracleAllFlashFilter
extends ArraySyncReplicationFilter {
    public static final String SITE_A_SN = "siteASn";
    public static final String SITE_B_SN = "siteBSn";
    public static final String OCACLE_SITE_A = "OCACLE_SITE_A";
    public static final String OCACLE_SITE_B = "OCACLE_SITE_B";
    public static final String STAND_BY_HOSTSNS = "STAND_BY_HOSTSNS";
    public static final String REMOTE_PAIR_SRCLUNIDS = "REMOTE_PAIR_SRCLUNIDS";
    public static final String REMOTE_PAIR_TRGLUNIDS = "REMOTE_PAIR_TRGLUNIDS";
    public static final String DB_NAMES = "DB_NAMES";
    public static final String PRD_DATA_LUN_WWN = "PRD_DATA_LUN_WWN";
    public static final String DATA_LUN_WWN = "DATA_LUN_WWN";
    public static final String REDO_LUN_WWN = "REDO_LUN_WWN";
    public static final String ARCHIVE_LUN_WWN = "ARCHIVE_LUN_WWN";
    public static final String REDO_BACK_UP_LUN_IDS = "REDO_BACK_UP_LUN_IDS";
    public static final String REDO = "REDO";
    public static final String ARCHIVE = "ARCHIVE";
    private static final Log LOGGER = LogFactory.getInstance(OracleAllFlashFilter.class);
    private static final long PAIR_NOT_IN_SAME_CG = 1073948176L;

    public int getType() {
        return 47;
    }

    public boolean isMatch(List<ProtectObject> protectObjects) {
        if (VerifyUtil.isEmpty(protectObjects)) {
            LOGGER.warn((Object)"The parameter protectObjects is empty!");
            LOGGER.info((Object)"End %s", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
            throw new LegoCheckedException(1073948191L);
        }
        LOGGER.info((Object)"Start %s isMatch", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        String arraySn = this.checkSameSrcDevice(protectObjects);
        Site site = this.getSiteFromSn(arraySn);
        if (VerifyUtil.isEmpty((Object)site)) {
            LOGGER.warn((Object)"Can't get site by deviceSN: %s", new Object[]{arraySn});
            throw new LegoCheckedException(1073948449L);
        }
        this.getFilterContext().clear();
        return this.isMatchByLocation(DrmEnumDefine.ProtectLocation.A_B.getValue(), protectObjects);
    }

    protected boolean isMatchByLocation(int locationType, List<ProtectObject> protectObjects) {
        boolean isMatch;
        this.getLunTgtDevs().clear();
        this.getLunTgtdevSn().clear();
        ExecutionContext context = this.init(locationType, protectObjects);
        try {
            isMatch = this.arrayFilterRules(protectObjects, context);
        }
        catch (LegoCheckedException e) {
            LOGGER.warn((Object)"Array replication filter failed!");
            throw e;
        }
        this.getLunTgtDevs().clear();
        this.getLunTgtdevSn().clear();
        if (!isMatch) {
            LOGGER.error((Object)"The template is not match.");
            throw new LegoCheckedException(1073948191L);
        }
        return true;
    }

    public boolean arrayFilterRules(List<ProtectObject> protectObjects, ExecutionContext context) {
        String devSn = (String)context.getAttribute("DEVICE_SN", String.class);
        Set resourceIdSet = null;
        if (context.getAttribute("RESOURCE_ID_SET") instanceof Set) {
            resourceIdSet = (Set)context.getAttribute("RESOURCE_ID_SET");
        }
        LOGGER.info((Object)"ResourceIdSet: %s", new Object[]{resourceIdSet.toString()});
        List lunList = this.queryLuns(devSn, resourceIdSet);
        Lun[] lunArray = new Lun[lunList.size()];
        lunList.toArray(lunArray);
        List<ApplicationResource> appStandbyResource = this.getApplicationResources(protectObjects);
        HashMap<String, String> siteSns = new HashMap<String, String>();
        siteSns.put(SITE_A_SN, ((ProtectObjectStorageInfo)protectObjects.get(0).getUsedStorageResourceSet().iterator().next()).getResourceProviderSN());
        ApplicationResource applicationResource = appStandbyResource.get(0);
        siteSns.put(SITE_B_SN, applicationResource.getDevSn());
        this.checkSites(siteSns);
        ArrayList dbNames = new ArrayList();
        dbNames.add(applicationResource.getExtendParams().get("STANDBY_DB_NAME"));
        List pairList = this.getPairsByLun(lunArray);
        List<String> hostSnList = this.getStandbyHostSns(appStandbyResource, protectObjects.get(0));
        HashMap<String, String> extendParams = new HashMap<String, String>();
        extendParams.put(STAND_BY_HOSTSNS, String.join((CharSequence)",", hostSnList));
        extendParams.put(DB_NAMES, String.join((CharSequence)",", dbNames));
        this.filterPairsByTgtSN(pairList, (String)siteSns.get(SITE_B_SN));
        List<ReplicationPair> remotePairs = this.getpairsByApplicationResource(appStandbyResource);
        this.filterPairsByTgtSN(remotePairs, (String)siteSns.get(SITE_A_SN));
        if (this.checkPairEqualNum(pairList, remotePairs) && this.checkReplicationPairs(siteSns, applicationResource, pairList, remotePairs) && this.checkArchivePairs(remotePairs, appStandbyResource)) {
            this.updatePrdWwnInfo(extendParams, lunList, pairList, protectObjects.get(0));
            OracleAllFlashFilter.updateStandbyWwnInfo(extendParams, applicationResource.getAppStorageInfos());
            this.fillContext(siteSns, extendParams, remotePairs);
            this.fillDeviceSnPairMap(pairList);
            return true;
        }
        return false;
    }

    private List<String> getStandbyHostSns(List<ApplicationResource> appStandbyResource, ProtectObject po) {
        Object[] hostSnArray = (String[])appStandbyResource.stream().map(ApplicationResource::getHostSn).toArray(String[]::new);
        IHostService hostService = (IHostService)ServiceLocator.getInstance().getService(IHostService.class);
        Optional hostOp = hostService.getDrHostsBySns((String[])hostSnArray).stream().findAny();
        if (!hostOp.isPresent()) {
            LOGGER.error((Object)"Can not get host by sns:%s", new Object[]{Arrays.toString(hostSnArray)});
            throw new LegoCheckedException(2117645L);
        }
        DrHost drHost = (DrHost)hostOp.get();
        int proType = NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE"));
        ArrayList<String> snList = new ArrayList<String>();
        if (DrmEnumDefine.ProviderTypeE.HOST.getValue() == proType) {
            snList.add(drHost.getDeviceSn());
        } else {
            DrResource drResource = drHost.getParentDrResource();
            if (VerifyUtil.isEmpty((Object)drResource)) {
                LOGGER.error((Object)"Host do not have parent resource, sn:%s", new Object[]{drHost.getDeviceSn()});
                throw new LegoCheckedException(2117645L);
            }
            if (drResource instanceof DrHostGroup) {
                Set hosts = drResource.getChildResources();
                hosts.forEach(host -> snList.add(host.getDeviceSn()));
            }
        }
        return snList;
    }

    private void updatePrdWwnInfo(Map<String, String> extendParams, List<Lun> lunList, List<ReplicationPair> pairList, ProtectObject protectObject) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(protectObject.getProviderSN());
        HashSet<String> hostSnSet = new HashSet<String>();
        if (drResource instanceof DrHostGroup) {
            DrHostGroup drHostGroup = (DrHostGroup)CastUtil.castTo((Object)drResource, DrHostGroup.class);
            Set childResources = drHostGroup.getChildResources();
            childResources.stream().map(DrResource::getDeviceSn).forEach(hostSnSet::add);
        } else {
            hostSnSet.add(drResource.getDeviceSn());
        }
        List storageInfoOfHosts = ExecutionService.map(hostSnSet, hostSn -> {
            ProtectObject clonePo = OracleAppUtil.clone(protectObject);
            clonePo.setProviderSN(hostSn);
            return OracleAppUtil.queryMatchedStorages(clonePo);
        }, null, (int)1800, (int)20);
        Set storageInfos = storageInfoOfHosts.stream().filter(list -> !list.isEmpty()).findFirst().orElseThrow(() -> new LegoCheckedException(1073948516L));
        String prdDataWwnStr = storageInfos.stream().filter(storageInfo -> OracleConst.DiskGroupType.DATA.getVal().equals(storageInfo.getAsmDiskGroupType())).map(ProtectObjectStorageInfo::getLunWWN).collect(Collectors.joining(","));
        extendParams.put(PRD_DATA_LUN_WWN, prdDataWwnStr);
        Set controlLunIdSet = storageInfos.stream().filter(info -> OracleConst.DiskGroupType.CONTROL.getVal().equals(info.getAsmDiskGroupType())).map(ProtectObjectStorageInfo::getResourceId).collect(Collectors.toSet());
        HashMap<String, Lun> lunMap = new HashMap<String, Lun>();
        for (Lun lun : lunList) {
            lunMap.put(lun.getLunId(), lun);
        }
        HashSet<ReplicationPair> prdControlPairSet = new HashSet<ReplicationPair>();
        for (ReplicationPair pair : pairList) {
            pair.setSrcLunWWN(((Lun)lunMap.get(pair.getSrcLunId())).getWwn());
            if (controlLunIdSet.contains(pair.getSrcLunId())) {
                prdControlPairSet.add(pair);
            }
            if (!prdDataWwnStr.contains(pair.getSrcLunWWN())) continue;
            LOGGER.error((Object)"Data lun has pair: %s", new Object[]{pair.getSrcLunWWN()});
            throw new LegoCheckedException(1073948191L);
        }
        if (!controlLunIdSet.isEmpty() && prdControlPairSet.isEmpty()) {
            LOGGER.error((Object)"Control file lun doesnt have pair: %s", new Object[]{controlLunIdSet});
            throw new LegoCheckedException(1073948518L);
        }
        extendParams.put(REDO_BACK_UP_LUN_IDS, OracleAllFlashFilter.updateRedoBackupLunIdByGroup(storageInfos, pairList).toString());
    }

    public static JSONObject updateRedoBackupLunIdByGroup(Set<ProtectObjectStorageInfo> storageInfos, List<ReplicationPair> pairList) {
        HashMap<String, Set<String>> backupArchLunMap = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> backupRedoLunMap = new HashMap<String, Set<String>>();
        for (ProtectObjectStorageInfo storageInfo : storageInfos) {
            if (OracleConst.DiskGroupType.DATA.getVal().equals(storageInfo.getAsmDiskGroupType())) continue;
            String dgName = storageInfo.getAsmDiskGroupName();
            Integer archiveLog = storageInfo.getArchiveLog();
            String wwn = storageInfo.getLunWWN();
            AppStorageInfo info = new AppStorageInfo();
            info.setWwn(wwn);
            info.setAsmDg(dgName);
            if ("1".equals(archiveLog.toString())) {
                OracleAllFlashFilter.groupWwnByDiskGroup(info, backupArchLunMap);
                continue;
            }
            OracleAllFlashFilter.groupWwnByDiskGroup(info, backupRedoLunMap);
        }
        JSONObject redoBackupIdByGroup = OracleAllFlashFilter.queryBackupLunByGroup(backupRedoLunMap, pairList);
        JSONObject archBackupIdByGroup = OracleAllFlashFilter.queryBackupLunByGroup(backupArchLunMap, pairList);
        JSONObject backupIdObj = new JSONObject();
        backupIdObj.put((Object)REDO, (Object)redoBackupIdByGroup);
        backupIdObj.put((Object)ARCHIVE, (Object)archBackupIdByGroup);
        return backupIdObj;
    }

    private static JSONObject queryBackupLunByGroup(Map<String, Set<String>> wwnLunByGroup, List<ReplicationPair> pairList) {
        HashMap<String, String> wwnToPair = new HashMap<String, String>();
        for (ReplicationPair replicationPair : pairList) {
            wwnToPair.put(replicationPair.getSrcLunWWN(), replicationPair.getTgtLunId());
        }
        HashMap lunIdByGroup = new HashMap();
        Set<Map.Entry<String, Set<String>>> entrySet = wwnLunByGroup.entrySet();
        for (Map.Entry<String, Set<String>> entry : entrySet) {
            String asmDgName = entry.getKey();
            Set<String> lunWwn = entry.getValue();
            lunIdByGroup.put(asmDgName, lunWwn.stream().map(wwnToPair::get).collect(Collectors.toSet()));
        }
        return JSONObject.fromObject(lunIdByGroup);
    }

    public static void updateStandbyWwnInfo(Map<String, String> extendParams, Set<AppStorageInfo> appStandbyInfoSet) {
        HashMap<String, Set<String>> archGroupMap = new HashMap<String, Set<String>>();
        HashSet<String> archiveWwns = new HashSet<String>();
        for (AppStorageInfo appStorageInfo : appStandbyInfoSet) {
            if (!OracleAppUtil.isArchive(appStorageInfo)) continue;
            archiveWwns.add(appStorageInfo.getWwn());
            OracleAllFlashFilter.groupWwnByDiskGroup(appStorageInfo, archGroupMap);
        }
        String archiveWwnStr = "";
        archiveWwnStr = archGroupMap.isEmpty() ? "--" : OracleAllFlashFilter.toStringWwnByGroup(archGroupMap);
        extendParams.put(ARCHIVE_LUN_WWN, archiveWwnStr);
        HashSet<String> remoteRedoWwns = new HashSet<String>();
        HashMap<String, Set<String>> redoGroupMap = new HashMap<String, Set<String>>();
        for (AppStorageInfo appStorageInfo : appStandbyInfoSet) {
            if (!OracleConst.DiskGroupType.LOG.getVal().equals(appStorageInfo.getAsmDgType()) && !OracleConst.DiskGroupType.CONTROL.getVal().equals(appStorageInfo.getAsmDgType())) continue;
            remoteRedoWwns.add(appStorageInfo.getWwn());
            OracleAllFlashFilter.groupWwnByDiskGroup(appStorageInfo, redoGroupMap);
        }
        extendParams.put(REDO_LUN_WWN, OracleAllFlashFilter.toStringWwnByGroup(redoGroupMap));
        Set dataWwns = appStandbyInfoSet.stream().filter(OracleAppUtil::isData).map(AppStorageInfo::getWwn).collect(Collectors.toSet());
        extendParams.put(DATA_LUN_WWN, String.join((CharSequence)",", dataWwns));
        LOGGER.info((Object)"Standby wwn size: data=%s, redo=%s, archive=%s", new Object[]{dataWwns.size(), remoteRedoWwns.size(), archiveWwns.size()});
    }

    private static String toStringWwnByGroup(Map<String, Set<String>> wwnGroupMap) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Set<String>> entry : wwnGroupMap.entrySet()) {
            String groupName = entry.getKey();
            Set<String> wwnByGroup = entry.getValue();
            builder.append(";");
            builder.append(groupName);
            builder.append(":");
            builder.append(String.join((CharSequence)",", wwnByGroup));
        }
        builder.delete(0, 1);
        return builder.toString();
    }

    private static void groupWwnByDiskGroup(AppStorageInfo info, Map<String, Set<String>> archGroupMap) {
        String asmDg = info.getAsmDg();
        String wwn = info.getWwn();
        Set wwnSetByGroup = archGroupMap.getOrDefault(asmDg, Collections.emptySet());
        if (VerifyUtil.isEmpty(wwnSetByGroup)) {
            wwnSetByGroup = new HashSet();
        }
        wwnSetByGroup.add(wwn);
        archGroupMap.put(asmDg, wwnSetByGroup);
    }

    private void checkSites(Map<String, String> siteSns) {
        String siteBsn;
        String devAsn = siteSns.get(SITE_A_SN);
        String devBsn = siteSns.get(SITE_B_SN);
        String siteAsn = this.checkSite(devAsn);
        if (Objects.equals(siteAsn, siteBsn = this.checkSite(devBsn))) {
            throw new LegoCheckedException(1073948210L);
        }
    }

    private boolean checkArchivePairs(List<ReplicationPair> remotePairs, List<ApplicationResource> appStandbyResource) {
        Set appStorageInfos = appStandbyResource.get(0).getAppStorageInfos();
        Set archiveSrcLunId = appStorageInfos.stream().filter(OracleAppUtil::isArchive).map(AppStorageInfo::getResourceId).collect(Collectors.toSet());
        long countArchiveLunWithPair = remotePairs.stream().filter(pair -> archiveSrcLunId.contains(pair.getSrcLunId())).count();
        return countArchiveLunWithPair == 0L || countArchiveLunWithPair == (long)archiveSrcLunId.size();
    }

    private List<ApplicationResource> getApplicationResources(List<ProtectObject> protectObjects) {
        ProtectObject po = protectObjects.get(0);
        IApplicationManager applicationManager = ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType());
        int proType = NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE"));
        if (DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue() == proType) {
            OracleAppUtil.checkAllInstanceStatus(po, false);
        } else {
            applicationManager.checkEnvStatus(po);
        }
        List appStandbyResource = applicationManager.getAppStandbyResource(po);
        if (VerifyUtil.isEmpty((Collection)appStandbyResource)) {
            LOGGER.error((Object)"%s has no data in siteB.", new Object[]{po.getName()});
            throw new LegoCheckedException(1073948191L);
        }
        this.checkControlFilePath(po, appStandbyResource);
        return appStandbyResource;
    }

    private void checkControlFilePath(ProtectObject po, List<ApplicationResource> appStandbyResource) {
        String productControlFilePath = this.getProductControlFilePath(po);
        if (VerifyUtil.isEmpty((String)productControlFilePath)) {
            throw new LegoCheckedException(1073947394L);
        }
        JSONObject proPath = JSONObject.fromObject((Object)productControlFilePath);
        if (proPath.containsKey((Object)"controlfiles")) {
            JSONArray proPaths = proPath.getJSONArray("controlfiles");
            String pathString = String.join((CharSequence)" ", (Iterable<? extends CharSequence>)proPaths);
            this.checkDisasterControlFilePath(po, appStandbyResource, pathString);
        }
    }

    private String getProductControlFilePath(ProtectObject po) {
        String instanceNames = (String)po.getProps().get("INSTANCENAME");
        if (VerifyUtil.isEmpty((String)instanceNames)) {
            LOGGER.error((Object)"Not find any instanceNames.");
            return "";
        }
        if (DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue() != NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE")).intValue()) {
            ProtectObject tempPo = OracleAppUtil.clone(po);
            tempPo.getProps().put("hostSn", po.getProviderSN());
            tempPo.getProps().put("QUERY_TYPE", "1");
            OracleAppUtil.checkAuthorityParameters(tempPo);
            OracleAction action = this.getActionByHostSn(po.getProviderSN());
            return action.inspectAdgStatus(tempPo.getProps());
        }
        JSONArray instanceArray = JSONArray.fromObject((Object)instanceNames);
        for (Object instanceObj : instanceArray) {
            JSONObject instance = JSONObject.fromObject(instanceObj);
            String hostSn = JsonUtil.getString((JSONObject)instance, (String)"ip", (String[])new String[]{""});
            String instanceName = JsonUtil.getString((JSONObject)instance, (String)"INSTANCENAME", (String[])new String[]{""});
            if (VerifyUtil.isEmpty((String)instanceName) || VerifyUtil.isEmpty((String)hostSn)) continue;
            ProtectObject tempPo = OracleAppUtil.clone(po);
            tempPo.getProps().put("INSTANCENAME", instanceName);
            tempPo.getProps().put("hostSn", hostSn);
            tempPo.getProps().put("QUERY_TYPE", "1");
            OracleAction action = this.getActionByHostSn(hostSn);
            OracleAppUtil.checkAuthorityParameters(tempPo);
            try {
                return action.inspectAdgStatus(tempPo.getProps());
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Can not find control file, hostSn:%s", new Object[]{hostSn});
            }
        }
        return "";
    }

    private OracleAction getActionByHostSn(String hostSn) {
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)hostSn);
        return new OracleAction(ne, (String)ne.getExtendParams().get("mac_address"));
    }

    private void checkDisasterControlFilePath(ProtectObject po, List<ApplicationResource> appStandbyResource, String path) {
        List hostSnList = appStandbyResource.stream().map(ApplicationResource::getHostSn).collect(Collectors.toList());
        String dbId = (String)po.getProps().get("DB_ID");
        LegoCheckedException otherException = null;
        for (String hostSn : hostSnList) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("hostSN", hostSn);
            params.put("dbId", dbId);
            List instances = CommonDAOLocator.getMoDao().findMoBy(DatabaseInstance.class, params);
            ProtectObject tempPo = OracleAppUtil.clone(po);
            tempPo.getProps().put("INSTANCENAME", ((DatabaseInstance)instances.get(0)).getInstanceName());
            tempPo.getProps().put("hostSn", hostSn);
            tempPo.getProps().put("controlfile", path);
            tempPo.getProps().put("QUERY_TYPE", "1");
            OracleAction action = this.getActionByHostSn(hostSn);
            OracleAppUtil.checkAuthorityParameters(tempPo);
            try {
                action.inspectAdgStatus(tempPo.getProps());
                break;
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() == 1073948533L) {
                    LOGGER.error((Object)"Check control file failed, dbId:%s, hostSn:%s", new Object[]{dbId, hostSn});
                    throw e;
                }
                otherException = e;
            }
        }
        if (!VerifyUtil.isEmpty(otherException)) {
            LOGGER.error((Object)"Can not check control file in all nodes.");
            throw otherException;
        }
    }

    private void filterPairsByTgtSN(List<ReplicationPair> pairList, String tgtSN) {
        pairList.removeIf(pair -> !tgtSN.equals(pair.getTgtDevSN()));
    }

    private void fillDeviceSnPairMap(List<ReplicationPair> pairList) {
        Object policyTemplateContext = this.getFilterContext().get("temp_policy_template_context");
        if (policyTemplateContext instanceof PolicyTemplateContext) {
            LOGGER.debug((Object)"Begin fill PairMap");
            Map devicesnPairMap = this.classifyPair(pairList);
            ((PolicyTemplateContext)policyTemplateContext).addObject("DR_RING_SITE_A_SYNC_PAIR_MAP", (Object)devicesnPairMap);
        }
    }

    private void fillContext(Map<String, String> siteSns, Map<String, String> extendParams, List<ReplicationPair> remotePairs) {
        this.getFilterContext().put(SITE_A_SN, siteSns.get(SITE_A_SN));
        this.getFilterContext().put(SITE_B_SN, siteSns.get(SITE_B_SN));
        this.getFilterContext().put(OCACLE_SITE_A, this.getSiteByDeviceSN(siteSns.get(SITE_A_SN)).getSiteId());
        this.getFilterContext().put(OCACLE_SITE_B, this.getSiteByDeviceSN(siteSns.get(SITE_B_SN)).getSiteId());
        this.getFilterContext().put(STAND_BY_HOSTSNS, extendParams.get(STAND_BY_HOSTSNS));
        this.getFilterContext().put(REDO_LUN_WWN, extendParams.get(REDO_LUN_WWN));
        this.getFilterContext().put(DATA_LUN_WWN, extendParams.get(DATA_LUN_WWN));
        this.getFilterContext().put(PRD_DATA_LUN_WWN, extendParams.get(PRD_DATA_LUN_WWN));
        this.getFilterContext().put(ARCHIVE_LUN_WWN, extendParams.get(ARCHIVE_LUN_WWN));
        this.getFilterContext().put(DB_NAMES, extendParams.get(DB_NAMES));
        this.getFilterContext().put(REDO_BACK_UP_LUN_IDS, extendParams.get(REDO_BACK_UP_LUN_IDS));
        ArrayList srcLunIds = new ArrayList();
        ArrayList trgLunIds = new ArrayList();
        remotePairs.forEach(pair -> {
            srcLunIds.add(pair.getSrcLunId());
            trgLunIds.add(pair.getTgtLunId());
        });
        this.getFilterContext().put(REMOTE_PAIR_SRCLUNIDS, String.join((CharSequence)",", srcLunIds));
        this.getFilterContext().put(REMOTE_PAIR_TRGLUNIDS, String.join((CharSequence)",", trgLunIds));
    }

    private List<ReplicationPair> getpairsByApplicationResource(List<ApplicationResource> appStandbyResource) {
        if (VerifyUtil.isEmpty(appStandbyResource)) {
            LOGGER.warn((Object)"The parameter appStandbyResource is empty!");
            LOGGER.info((Object)"End %s", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
            throw new LegoCheckedException(1073948191L);
        }
        String siteBSn = appStandbyResource.get(0).getDevSn();
        Set appLunInfos = appStandbyResource.get(0).getAppStorageInfos();
        List lunIdList = appLunInfos.stream().map(AppStorageInfo::getResourceId).collect(Collectors.toList());
        Site site = this.getSiteByDeviceSN(siteBSn);
        if (VerifyUtil.isEmpty((Object)site)) {
            LOGGER.warn((Object)"Can't get site by deviceSN: %s", new Object[]{siteBSn});
            throw new LegoCheckedException(1073948449L);
        }
        return this.getPairsByResourceIds(siteBSn, lunIdList, site, DrmEnumDefine.ResourceTypeE.LUN.getValue());
    }

    private boolean checkPairEqualNum(List<ReplicationPair> pairs, List<ReplicationPair> remotePairs) {
        boolean isPairEqual = pairs.size() == remotePairs.size();
        LOGGER.info((Object)"Compare pair size: A->B=%s, B->A=%s", new Object[]{pairs.size(), remotePairs.size()});
        return isPairEqual;
    }

    private boolean checkReplicationPairs(Map<String, String> siteSns, ApplicationResource applicationResource, List<ReplicationPair> replicationPairs, List<ReplicationPair> remotePairs) {
        Set controlPair;
        if (!siteSns.containsKey(SITE_A_SN) || !siteSns.containsKey(SITE_B_SN)) {
            LOGGER.error((Object)"SiteSn doesnt have enough site: %s", new Object[]{siteSns});
            return false;
        }
        LOGGER.debug((Object)"Begin Check Pairs");
        Set controlLunIdSet = applicationResource.getAppStorageInfos().stream().filter(info -> OracleConst.DiskGroupType.CONTROL.getVal().equals(info.getAsmDgType())).map(AppStorageInfo::getResourceId).collect(Collectors.toSet());
        if (!controlLunIdSet.isEmpty() && (controlPair = remotePairs.stream().filter(pair -> controlLunIdSet.contains(pair.getSrcLunId())).collect(Collectors.toSet())).isEmpty()) {
            LOGGER.error((Object)"Control file dont have pair: %s", new Object[]{controlLunIdSet});
            throw new LegoCheckedException(1073948518L);
        }
        return this.checkSiteAPairs(siteSns, replicationPairs) && this.checkSiteBPairs(siteSns, remotePairs);
    }

    private boolean checkSiteA(Map<String, String> siteSns, ReplicationPair replicationPair) {
        boolean isMatch = false;
        String siteBSn = siteSns.get(SITE_B_SN);
        LOGGER.debug((Object)"Begin check siteA pairs");
        if (!siteBSn.equals(replicationPair.getTgtDevSN())) {
            return isMatch;
        }
        boolean isSync = replicationPair.getReplicationMode() == 1;
        boolean isPairNormalOrSynchorizing = String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()).equals(replicationPair.getRunningState()) || String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue()).equals(replicationPair.getRunningState());
        LOGGER.info((Object)"IsSync: %s. IsPairNormalOrSynchorizing: %s.", new Object[]{String.valueOf(isSync), String.valueOf(isPairNormalOrSynchorizing)});
        return isSync && isPairNormalOrSynchorizing;
    }

    private boolean checkSiteAPairs(Map<String, String> siteSns, List<ReplicationPair> replicationPairs) {
        if (VerifyUtil.isEmpty(replicationPairs)) {
            LOGGER.error((Object)"There are no pairs");
            return false;
        }
        String siteASn = siteSns.get(SITE_A_SN);
        String siteBSn = siteSns.get(SITE_B_SN);
        LOGGER.debug((Object)"Begin check siteA pairs");
        boolean isConsistentGroup = false;
        boolean isSiteAAndSiteB = true;
        boolean isSync = true;
        boolean isPairNormalOrSynchorizing = true;
        HashSet<String> cgIdSet = new HashSet<String>();
        ArrayList<ReplicationPair> cgIdNullList = new ArrayList<ReplicationPair>();
        for (ReplicationPair pair : replicationPairs) {
            String cgId = pair.getConsistentGroupId();
            if (!VerifyUtil.isEmpty((String)cgId) && !"--".equals(cgId)) {
                isConsistentGroup = true;
                cgIdSet.add(cgId);
            } else {
                cgIdNullList.add(pair);
            }
            isSiteAAndSiteB = siteASn.equals(pair.getSrcDevSN()) && siteBSn.equals(pair.getTgtDevSN());
            isSync = pair.getReplicationMode() == 1;
            boolean bl = isPairNormalOrSynchorizing = String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()).equals(pair.getRunningState()) || String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue()).equals(pair.getRunningState());
            if (isSync && isPairNormalOrSynchorizing && isSiteAAndSiteB) continue;
            LOGGER.warn((Object)"IsSync: %s. IsPairNormalOrSynchorizing: %s.IsSiteAAndSiteB: %s.", new Object[]{isSync, isPairNormalOrSynchorizing, isSiteAAndSiteB});
            return false;
        }
        this.checkConsistentGroup(isConsistentGroup, replicationPairs, cgIdSet, cgIdNullList);
        return true;
    }

    private void checkConsistentGroup(boolean isConsistentGroup, List<ReplicationPair> replicationPairs, Set<String> cgIdSet, List<ReplicationPair> cgIdNullList) {
        if (!isConsistentGroup && replicationPairs.size() > 1) {
            LOGGER.error((Object)"Pairs of SiteA doesnt in the same cg: %s", new Object[]{String.valueOf(replicationPairs.size())});
            throw new LegoCheckedException(1073948176L);
        }
        if (isConsistentGroup && cgIdSet.size() != 1) {
            LOGGER.error((Object)"Some pair of SiteA doesnt in the same cg: %s", new Object[]{String.join((CharSequence)",", cgIdSet)});
            throw new LegoCheckedException(1073948176L);
        }
        if (isConsistentGroup && cgIdNullList.size() != 0) {
            List lunNames = cgIdNullList.stream().map(ReplicationPair::getSrcLunName).collect(Collectors.toList());
            LOGGER.error((Object)"Some pair of SiteA doesnt in the cg: %s", new Object[]{String.join((CharSequence)",", lunNames)});
            throw new LegoCheckedException(1073948176L);
        }
    }

    private boolean checkSiteB(Map<String, String> siteSns, ReplicationPair replicationPair) {
        boolean isMatch = false;
        String siteASn = siteSns.get(SITE_A_SN);
        LOGGER.debug((Object)"Begin check siteB pairs");
        if (!siteASn.equals(replicationPair.getTgtDevSN())) {
            return isMatch;
        }
        return replicationPair.getReplicationMode() == 1;
    }

    private boolean checkSiteBPairs(Map<String, String> siteSns, List<ReplicationPair> replicationPairs) {
        if (VerifyUtil.isEmpty(replicationPairs)) {
            return false;
        }
        String siteASn = siteSns.get(SITE_A_SN);
        String siteBSn = siteSns.get(SITE_B_SN);
        LOGGER.debug((Object)"Begin check siteA pairs");
        boolean isConsistentGroup = false;
        HashMap<String, String> cgIdMap = new HashMap<String, String>();
        boolean isSiteAAndSiteB = true;
        boolean isSync = true;
        LOGGER.debug((Object)"Begin check siteB pairs");
        for (ReplicationPair pair : replicationPairs) {
            String cgId = pair.getConsistentGroupId();
            if (!VerifyUtil.isEmpty((String)cgId) && !"--".equals(cgId)) {
                isConsistentGroup = true;
                cgIdMap.putIfAbsent(cgId, "");
            }
            isSiteAAndSiteB = siteBSn.equals(pair.getSrcDevSN()) && siteASn.equals(pair.getTgtDevSN());
            boolean bl = isSync = pair.getReplicationMode() == 1;
            if (isSync && isSiteAAndSiteB) continue;
            return false;
        }
        LOGGER.debug((Object)"IsSync: %s.IsSiteAAndSiteB: %s.IsConsistentGroup: %s", new Object[]{String.valueOf(isSync), String.valueOf(isSiteAAndSiteB), String.valueOf(isConsistentGroup)});
        if (!isConsistentGroup && replicationPairs.size() > 1) {
            LOGGER.error((Object)"Pair of SiteB doesnt in the same cg: %s", new Object[]{String.valueOf(replicationPairs.size())});
            throw new LegoCheckedException(1073948176L);
        }
        if (isConsistentGroup && cgIdMap.size() != 1) {
            LOGGER.error((Object)"Some pair of SiteB doesnt in the same cg: %s", new Object[]{cgIdMap.keySet()});
            throw new LegoCheckedException(1073948176L);
        }
        return true;
    }

    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        this.isMatch(protectObjects);
        String siteA = null;
        String siteB = null;
        if (this.getFilterContext().get(OCACLE_SITE_A) instanceof String) {
            siteA = (String)this.getFilterContext().get(OCACLE_SITE_A);
        }
        if (this.getFilterContext().get(OCACLE_SITE_B) instanceof String) {
            siteB = (String)this.getFilterContext().get(OCACLE_SITE_B);
        }
        ArrayList<ProtectLocationPath> path = new ArrayList<ProtectLocationPath>();
        path.add(this.constructSitePath(DrmEnumDefine.ProtectLocation.A_B.getValue(), siteA, siteB));
        return path;
    }
}

