/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.application.model.AppStorageInfo;
import com.huawei.ism.drm.application.model.ApplicationResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.service.impl.DrmStorageServiceImpl;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AdgCheckProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgCheckProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        IApplicationManager applicationManager = ApplicationAdapterProxy.getInstance().getAppManager(protectGroup.getPoType());
        DrmStorageServiceImpl drmStorageService = (DrmStorageServiceImpl)ServiceLocator.getInstance().getService(DrmStorageServiceImpl.class);
        for (ProtectObject po : protectGroup.getPolist()) {
            po.getProps().put("QUERY_TYPE", "0");
            applicationManager.checkEnvStatus(po);
            List appStandbyResources = applicationManager.getAppStandbyResource(po);
            if (VerifyUtil.isEmpty((Collection)appStandbyResources)) {
                LOGGER.error((Object)"The adg environment is not ready.");
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("ism.drm.recovery.adg.env.not.ready", new String[]{protectGroup.getName()});
                return false;
            }
            ApplicationResource resource = (ApplicationResource)appStandbyResources.get(0);
            String oldPrdDataWwn = protectGroup.getProps().getOrDefault("PRD_DATA_LUN_WWN", "");
            List standByRedoWwnList = resource.getAppStorageInfos().stream().map(AppStorageInfo::getWwn).filter(wwn -> !oldPrdDataWwn.contains((CharSequence)wwn)).distinct().collect(Collectors.toList());
            List standbyPairList = drmStorageService.queryReplicationPairsByMasterLunWWN(standByRedoWwnList, true);
            for (ReplicationPair pair : standbyPairList) {
                standByRedoWwnList.remove(pair.getSrcLunWWN());
            }
            if (!VerifyUtil.isEmpty(standByRedoWwnList)) {
                String logWwnStr = String.join((CharSequence)",", standByRedoWwnList);
                LOGGER.error((Object)"There are no remote replications created for log LUN(%s).", new Object[]{logWwnStr});
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("ism.drm.recovery.lun.not.pair", new String[]{logWwnStr});
                return false;
            }
            if (this.checkPrdRedoLun(context, protectGroup, drmStorageService)) continue;
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private boolean checkPrdRedoLun(RecoveryProcessorContext context, ProtectGroup protectGroup, DrmStorageServiceImpl drmStorageService) {
        String disasterDeviceSn = DBRecoveryTools.getDisasterHostSn((RecoveryPlan)context.getRecoveryPlan(), (String)protectGroup.getUuid(), (int)this.getProcType());
        DrResource drGroupResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(disasterDeviceSn);
        HashSet<ProtectObjectStorageInfo> storageInfoList = new HashSet<ProtectObjectStorageInfo>();
        Set<DrResource> childResources = drGroupResource instanceof DrHostGroup ? drGroupResource.getChildResources() : Collections.singleton(drGroupResource);
        for (DrResource childResource : childResources) {
            if (this.checkOracleDatabase(childResource.getDeviceSn(), storageInfoList, protectGroup)) continue;
            return false;
        }
        List prdRedoList = storageInfoList.stream().map(ProtectObjectStorageInfo::getLunWWN).distinct().collect(Collectors.toList());
        List prdPairList = drmStorageService.queryReplicationPairsByMasterLunWWN(prdRedoList, true);
        for (ReplicationPair pair : prdPairList) {
            prdRedoList.remove(pair.getSrcLunWWN());
        }
        String prdDataStr = protectGroup.getProps().getOrDefault("DATA_LUN_WWN", "");
        prdRedoList.removeAll(Arrays.asList(prdDataStr.split(",")));
        if (!VerifyUtil.isEmpty(prdRedoList)) {
            LOGGER.error((Object)"No remote replication is created for LUN(%s).", new Object[]{String.join((CharSequence)",", prdRedoList)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("ism.drm.recovery.lun.not.pair", new String[]{String.join((CharSequence)",", prdRedoList)});
            return false;
        }
        return true;
    }

    private boolean checkOracleDatabase(String sn, Set<ProtectObjectStorageInfo> storageInfoList, ProtectGroup pg) {
        ProtectObject tmp = new ProtectObject();
        tmp.setProviderSN(sn);
        Set<ProtectObjectStorageInfo> list = OracleAppUtil.queryMatchedStorages(tmp);
        if (VerifyUtil.isEmpty(list)) {
            LOGGER.error((Object)"The adg environment is not ready: sn=%s", new Object[]{sn});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("ism.drm.recovery.adg.env.not.ready", new String[]{pg.getName()});
            return false;
        }
        storageInfoList.addAll(list);
        return true;
    }
}

