/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.operation.sdk.model.OperationResultBill;
import com.huawei.ism.drm.oracle.recovery.process.AdgRefactorStorageRelationSubAbsProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupExtendUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.replication.service.impl.StorageReplicationServiceImpl;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageReplicationService;
import com.huawei.ism.drm.storage.service.impl.DrmStorageServiceImpl;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AdgRefactorStorageRelationPSubProcessor
extends AdgRefactorStorageRelationSubAbsProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgRefactorStorageRelationPSubProcessor.class);

    public boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        ProtectObject po = DBRecoveryTools.getProtectObjectByPoId((Set)context.getRecoveryProtectObjects(), (String)this.getPoId());
        if (VerifyUtil.isEmpty((Object)po)) {
            LOGGER.error((Object)"Not find po by poId: %s", new Object[]{this.getPoId()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        boolean isSyncSuccess = this.syncRedoReplicationPair(po);
        if (!isSyncSuccess) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        boolean isSplitSuccess = this.splitBackUpRelicationPair(po);
        if (!isSplitSuccess) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private boolean syncRedoReplicationPair(ProtectObject po) {
        DrmStorageServiceImpl drmStorageService = (DrmStorageServiceImpl)ServiceLocator.getInstance().getService(DrmStorageServiceImpl.class);
        IStorageReplicationService replicationService = (IStorageReplicationService)ServiceLocator.getInstance().getService(StorageReplicationServiceImpl.class);
        String srcRedoLunWwn = OracleAppUtil.getAdgStandbyLogWwn(po.getProtectGroup());
        List replicationPairs = drmStorageService.queryReplicationPairsByMasterLunWWN(Arrays.asList(srcRedoLunWwn.split(",")), true);
        StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
        HashSet<String> doneCgList = new HashSet<String>();
        for (ReplicationPair pair : replicationPairs) {
            boolean isCg = !VerifyUtil.isEmpty((String)pair.getConsistentGroupId());
            String id = isCg ? pair.getConsistentGroupId() : pair.getReplicationId();
            if (doneCgList.contains(id)) continue;
            List targetLunList = pair.getRepTgtLuns();
            ReplicationTargetLun targetLun = (ReplicationTargetLun)targetLunList.get(0);
            if (targetLun.getPairStatus().intValue() == XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() || targetLun.getPairStatus().intValue() == ReplicationConstantDefine.PairStatus.SYNCHRONIZING.getValue() || targetLun.getPairStatus().intValue() == XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue()) {
                LOGGER.info((Object)"The pair/cg(%s) status is normal or is being synchronized.", new Object[]{id});
                continue;
            }
            proxy.setLunWriteProtection(targetLun.getTgtDevSN(), id, isCg, 2);
            OperationResult result = replicationService.syncReplication(targetLun.getTgtDevSN(), pair.getDevSn(), id, isCg);
            if (!result.isSuccess() && Long.parseLong(result.getErrorCode()) != 1077937983L) {
                LOGGER.error((Object)"Failed to synchronize the pair, result: %s.", new Object[]{result.getErrorCode()});
                this.updateProcessDetail("ism.drm.recovery.reprotect.sync.pair.error", new String[]{id});
                return false;
            }
            doneCgList.add(id);
        }
        return true;
    }

    private boolean splitBackUpRelicationPair(ProtectObject po) {
        IRecoveryProcessHandler recoveryProcHandler = (IRecoveryProcessHandler)RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        DrmStorageServiceImpl drmStorageService = (DrmStorageServiceImpl)ServiceLocator.getInstance().getService(DrmStorageServiceImpl.class);
        Set replicaSet = ProtectGroupExtendUtil.getAllRemoteStorageReplica((ProtectGroup)po.getProtectGroup());
        HashSet<String> doneCgList = new HashSet<String>();
        for (RemoteStorageReplica replica : replicaSet) {
            String id;
            List replicationPairList = drmStorageService.queryReplicationPairsByMasterLunId(replica.getSrcStorageProviderSN(), Collections.singletonList(replica.getSrcStorageId()), true, Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
            ReplicationPair pair = (ReplicationPair)replicationPairList.get(0);
            boolean isCg = !VerifyUtil.isEmpty((String)pair.getConsistentGroupId());
            String string = id = isCg ? pair.getConsistentGroupId() : pair.getReplicationId();
            if (doneCgList.contains(id)) continue;
            ReplicationTargetLun targetLun = (ReplicationTargetLun)pair.getRepTgtLuns().get(0);
            if (XveEuumDefineParent.RUNNING_STATUS_E.SPLIT.getValue() == targetLun.getPairStatus().intValue()) {
                LOGGER.info((Object)"The pair/cg(%s) has been split.", new Object[]{id});
                return true;
            }
            OperationResultBill bill = recoveryProcHandler.swap(id, replica.getSrcStorageProviderSN(), replica.getStorageProviderSN(), isCg, false);
            if (bill.isHasFailRecord() && !VerifyUtil.isEmpty((Collection)bill.getOperationResults())) {
                LOGGER.error((Object)"Failed to split the original active/standby pair(%s).", new Object[]{replica.getReplicationPairId()});
                this.updateProcessDetail("ism.drm.recovery.reprotect.split.pair.error", new String[]{id});
                return false;
            }
            doneCgList.add(id);
        }
        return true;
    }
}

