/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.oracle.sdk.model.OracleInstance;
import com.huawei.ism.database.sdk.model.Database;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.util.DatabaseApplicationUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.oracle.recovery.process.AdgStartupOracleSubProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class AdgStartupOracleProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgStartupOracleProcessor.class);
    private static final long serialVersionUID = -187457383035547181L;

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue()) {
            this.setIsEnabled(false);
            this.setIsEditable(false);
        } else {
            this.setIsEnabled(true);
            this.setIsEditable(false);
        }
    }

    protected boolean execute(RecoveryProcessorContext context) {
        boolean isSuccess;
        if (VerifyUtil.isEmpty((Collection)this.getChildProc()) && !(isSuccess = this.createSubProcessors(context))) {
            LOGGER.error((Object)"Create AdgStartupOracleProcessor sub processor failed");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        if (recoveryTemplate == null) {
            LOGGER.error((Object)"AdgStartupOracleProcessor recoveryTemplate is empty.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        recoveryTemplate.process(context);
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    private boolean createSubProcessors(RecoveryProcessorContext context) {
        HashSet<AdgStartupOracleSubProcessor> startupPDBSubProcessors = new HashSet<AdgStartupOracleSubProcessor>();
        for (ProtectObject po : context.getRecoveryProtectObjects()) {
            String hostSnListS;
            Optional<Object> hostSnOption;
            if (Arrays.asList(DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue(), DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue()).contains(this.getProcType())) {
                List<String> ips = OracleAppUtil.getIpsByRecoveryContext(context);
                if (VerifyUtil.isEmpty(ips)) continue;
                hostSnOption = ips.stream().findFirst();
            } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType()) {
                hostSnListS = String.valueOf(context.getAttribute("standByHostList"));
                hostSnOption = Arrays.stream(hostSnListS.split(",")).findAny();
            } else {
                hostSnListS = po.getProtectGroup().getProperty("STAND_BY_HOSTSNS");
                hostSnOption = Arrays.stream(hostSnListS.split(",")).findAny();
            }
            if (!hostSnOption.isPresent()) continue;
            String hostSn = (String)hostSnOption.get();
            List databases = DatabaseApplicationUtil.queryAllDatabaseInstance((String)hostSn, (int)1, new HashMap());
            if (CollectionUtils.isEmpty((Collection)databases)) {
                LOGGER.error((Object)"Not find databases by hostSn: %s", new Object[]{hostSn});
                continue;
            }
            Database database = (Database)databases.get(0);
            ManagedObject managedObject = database.getParentMo();
            if (!(managedObject instanceof OracleInstance)) continue;
            OracleInstance dbInstance = (OracleInstance)managedObject;
            AdgStartupOracleSubProcessor processor = this.getAdgStartupOracleSubProcessor(po, hostSn, database, dbInstance);
            startupPDBSubProcessors.add(processor);
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(startupPDBSubProcessors);
        } else {
            this.setChildProc(startupPDBSubProcessors);
        }
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private AdgStartupOracleSubProcessor getAdgStartupOracleSubProcessor(ProtectObject po, String hostSn, Database database, OracleInstance dbInstance) {
        AdgStartupOracleSubProcessor processor = new AdgStartupOracleSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processor.setDbName(database.getName());
        processor.setInstanceName(dbInstance.getInstanceName());
        processor.setPoId(po.getUuid());
        processor.setTgtHostSn(hostSn);
        return processor;
    }
}

