/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Set;

public class AdgStartupOracleSubProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgStartupOracleSubProcessor.class);
    private String poId;
    private String dbName;
    private String instanceName;
    private String instances;
    private String tgtHostSn;

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getInstances() {
        return this.instances;
    }

    public void setInstances(String instances) {
        this.instances = instances;
    }

    public String getPoId() {
        return this.poId;
    }

    public void setPoId(String poId) {
        this.poId = poId;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getTgtHostSn() {
        return this.tgtHostSn;
    }

    public void setTgtHostSn(String tgtHostSn) {
        this.tgtHostSn = tgtHostSn;
    }

    protected boolean execute(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Begin execute AdgStartupOracleSubProcessor db sub processor, dbName=%s.", new Object[]{this.getDbName()});
        this.updateProcessNameParams(new String[]{this.getDbName()});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.database.already.started", new String[]{this.getDbName()});
            LOGGER.info((Object)"database instance has been started, dbName=%s.", new Object[]{this.getDbName()});
            return true;
        }
        ProtectObject po = DBRecoveryTools.getProtectObjectByPoId((Set)context.getRecoveryProtectObjects(), (String)this.getPoId());
        if (VerifyUtil.isEmpty((Object)po)) {
            LOGGER.error((Object)"Not find po by poId: %s", new Object[]{this.getPoId()});
            this.updateProcessDetail("lego.err.1073947394", new String[]{this.getDbName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        ProtectObject temp = OracleAppUtil.clone(po);
        temp.setProperty("drHostSn", (Object)this.getTgtHostSn());
        temp.setProperty("DB_NAMES", (Object)this.getDbName());
        temp.setProperty("INSTANCENAME", (Object)this.getInstanceName());
        if (this.adgStartup(temp)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        } else {
            LOGGER.error((Object)"can't adg start database instance, the dbName=%s.", new Object[]{this.getDbName()});
            this.updateProcessDetail("ism.drm.recovery.database.startup.failed", new String[]{this.getDbName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        }
        LOGGER.info((Object)"End execute adg start database sub processor, dbName=%s.", new Object[]{this.getDbName()});
        return true;
    }

    protected boolean adgStartup(ProtectObject po) {
        try {
            ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType()).adgStartup(po);
            LOGGER.info((Object)"Adg start database success, dbName=%s.", new Object[]{this.getDbName()});
            return true;
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Adg start database failed:%s,%s.", new Object[]{po.getUuid(), ExceptionUtil.getErrorMessage((Throwable)e)});
            return false;
        }
    }
}

