/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.application.model.AppStorageInfo;
import com.huawei.ism.drm.application.model.ApplicationResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotProcessor;
import com.huawei.ism.drm.storage.recovery.process.ICreateSnapshotHandler;
import com.huawei.ism.drm.storage.recovery.process.common.CommonRecoveryProcessor;
import com.huawei.ism.drm.storage.recovery.process.snapshot.CreateSnapshotBackupCopySubProcessor;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class CreateOracleAdgSnapshotProcessor
extends CommonRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(CreateSnapshotProcessor.class);
    private static final long serialVersionUID = -5927698726937203398L;
    private static final long NO_SNAPSHOT_FOUND = 51010014L;

    protected boolean execute(RecoveryProcessorContext context) {
        context.setAttribute("batch_active_snapshot", (Object)"true");
        boolean result = super.execute(context);
        if (!result) {
            return result;
        }
        return this.activateSnapshotAtOnce();
    }

    private boolean activateSnapshotAtOnce() {
        String devSn;
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOGGER.error((Object)"Create snapshot processor not found.");
            return this.failure(new LegoCheckedException(51010014L));
        }
        HashMap<String, List> devAndSnapshotIdMap = new HashMap<String, List>();
        for (RecoveryProcessor recoveryProcessor : this.getChildProc()) {
            if (!(recoveryProcessor instanceof ICreateSnapshotHandler)) continue;
            ICreateSnapshotHandler snapshotHandler = (ICreateSnapshotHandler)recoveryProcessor;
            devSn = snapshotHandler.getDeviceId();
            List snapshotSet = devAndSnapshotIdMap.computeIfAbsent(devSn, k -> new ArrayList());
            snapshotSet.add(snapshotHandler.getSnapshotId());
        }
        Set entrySet = devAndSnapshotIdMap.entrySet();
        for (Map.Entry entry : entrySet) {
            devSn = (String)entry.getKey();
            List snapshotIds = (List)entry.getValue();
            IStorageSnapshotManager snapshotMgrByDevId = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn);
            OperationResult result = snapshotMgrByDevId.activeSnapshot(devSn, snapshotIds);
            if (result.isSuccess()) continue;
            LOGGER.error((Object)"Failed to activate snapshot: snapshotIds=%s", new Object[]{snapshotIds});
            this.updateProcessDetail("lego.err." + result.getErrorCode(), result.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        return true;
    }

    protected Set<RecoveryProcessor> createProcessors(RecoveryProcessorContext context) {
        List allPos = DBRecoveryTools.appProtectObjectsFilter((RecoveryProcessorContext)context);
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()) {
            Collection recoveryTasks = RecoveryProcessUtil.filterRecoveryTask((RecoveryProcessorContext)context, (String)this.getRecoveryTasksKey());
            String disasterSiteId = String.valueOf(context.getAttribute("DISASTER_SITE_ID"));
            Set tasks = RecoveryTaskUtil.getRecoveryTasksByDisisaterSite((Collection)recoveryTasks, (String)disasterSiteId);
            Set<CreateSnapshotBackupCopySubProcessor> dataSubProcessors = this.buildSubProcessorByPos(allPos, DrmEnumDefine.OracleDiskType.DATA);
            Set<CreateSnapshotBackupCopySubProcessor> redoProcessors = this.buildSubProcessorByTask(tasks);
            HashSet<CreateSnapshotBackupCopySubProcessor> allSubProcessors = new HashSet<CreateSnapshotBackupCopySubProcessor>();
            allSubProcessors.addAll(dataSubProcessors);
            allSubProcessors.addAll(redoProcessors);
            this.setSubProcessorHostInfo(context, allSubProcessors);
            return new HashSet<CreateSnapshotBackupCopySubProcessor>(allSubProcessors);
        }
        Set<CreateSnapshotBackupCopySubProcessor> subProcessors = this.buildSubProcessorByPos(allPos, DrmEnumDefine.OracleDiskType.ALL);
        return new HashSet<CreateSnapshotBackupCopySubProcessor>(subProcessors);
    }

    private Set<CreateSnapshotBackupCopySubProcessor> buildSubProcessorByTask(Set<RecoveryTask> recoveryTasks) {
        HashSet<CreateSnapshotBackupCopySubProcessor> subProcessors = new HashSet<CreateSnapshotBackupCopySubProcessor>();
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        String remoteBackupIds = OracleAppUtil.getAdgBackupLunId(this.getContextRef().getProtectGroup());
        for (RecoveryTask task : recoveryTasks) {
            Map lunAndHostMap = task.getLunAndHostMap();
            if (VerifyUtil.isEmpty((Map)lunAndHostMap)) continue;
            Set entrySet = lunAndHostMap.entrySet();
            for (Map.Entry entry : entrySet) {
                String lunAndHostMapKey = (String)entry.getKey();
                String lunId = RecoveryProcessUtil.getLunIdFromLunAndHostMapKey((String)lunAndHostMapKey);
                String tgtDeviceId = task.getTgtDevcieId();
                Lun backUpLun = storageService.getLunBySnAndLunId(tgtDeviceId, lunId);
                if (!remoteBackupIds.contains(backUpLun.getLunId())) continue;
                CreateSnapshotBackupCopySubProcessor processor = new CreateSnapshotBackupCopySubProcessor(tgtDeviceId, lunId, backUpLun.getName(), DrmEnumDefine.OracleDiskType.REDO.getTypeValue());
                subProcessors.add(processor);
            }
        }
        return subProcessors;
    }

    private void setSubProcessorHostInfo(RecoveryProcessorContext context, Set<CreateSnapshotBackupCopySubProcessor> subProcessors) {
        String ids = this.getHostString(context);
        LOGGER.info((Object)"Set BackupCopySubProcessor hostId: %s", new Object[]{ids});
        subProcessors.forEach(processor -> processor.setHostOrGroupIds(ids));
    }

    private String getHostString(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        Set recoverySettings = recoveryPlan.getRecoverySettings();
        Optional<String> opt = recoverySettings.stream().filter(setting -> setting.getRecoveryPlan().getPlanId().equals(recoveryPlan.getPlanId())).filter(setting -> "PG_DISASTER_HOST".equals(setting.getName())).map(RecoverySetting::getValue).findFirst();
        if (!opt.isPresent()) {
            LOGGER.error((Object)"Not find hostID from recovery plan setting with PG_DISASTER_HOST");
            throw new LegoCheckedException(1073947394L);
        }
        return RecoveryProcessUtil.getHostOrGroupIds(new ArrayList<String>(Collections.singleton(opt.get())));
    }

    private Set<CreateSnapshotBackupCopySubProcessor> buildSubProcessorByPos(List<ProtectObject> allPos, DrmEnumDefine.OracleDiskType type) {
        if (CollectionUtils.isEmpty(allPos)) {
            LOGGER.error((Object)"Not find any po, return empty.");
            return Collections.emptySet();
        }
        HashSet<CreateSnapshotBackupCopySubProcessor> devSnAndLunMapping = new HashSet<CreateSnapshotBackupCopySubProcessor>();
        for (ProtectObject po : allPos) {
            IApplicationManager applicationManager = ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType());
            List appStandbyResources = applicationManager.getAppStandbyResource(po);
            if (CollectionUtils.isEmpty((Collection)appStandbyResources)) {
                LOGGER.error((Object)"Not find standby resource by poName: %s", new Object[]{po.getName()});
                continue;
            }
            ApplicationResource resource = (ApplicationResource)appStandbyResources.get(0);
            String archiveFlag = (String)po.getProps().get("ARCHIVE_LOG");
            devSnAndLunMapping.addAll(this.loadProcessorsByStandbyResource(resource, type, archiveFlag));
        }
        return devSnAndLunMapping;
    }

    private Set<CreateSnapshotBackupCopySubProcessor> loadProcessorsByStandbyResource(ApplicationResource resource, DrmEnumDefine.OracleDiskType type, String archiveFlag) {
        Set<AppStorageInfo> infoSet;
        if (type == DrmEnumDefine.OracleDiskType.DATA) {
            String dataLunWwn = this.getContextRef().getProtectGroup().getProps().getOrDefault("DATA_LUN_WWN", "");
            infoSet = resource.getAppStorageInfos().stream().filter(storageInfo -> dataLunWwn.contains(storageInfo.getWwn())).collect(Collectors.toSet());
            infoSet.forEach(info -> info.setAsmDg(DrmEnumDefine.OracleDiskType.DATA.getTypeValue()));
        } else {
            ProtectGroup protectGroup = this.getContextRef().getProtectGroup();
            String adgStandbyLogWwn = OracleAppUtil.getAdgStandbyLogWwn(protectGroup);
            resource.getAppStorageInfos().forEach(info -> {
                if (!"1".equals(archiveFlag) && OracleAppUtil.isArchive(info)) {
                    return;
                }
                if (adgStandbyLogWwn.contains(info.getWwn())) {
                    info.setAsmDg(DrmEnumDefine.OracleDiskType.REDO.getTypeValue());
                } else {
                    info.setAsmDg(DrmEnumDefine.OracleDiskType.DATA.getTypeValue());
                }
            });
            infoSet = resource.getAppStorageInfos();
        }
        if (CollectionUtils.isEmpty((Collection)infoSet)) {
            LOGGER.error((Object)"Not find standby storage info by hostSn: %s and queryType: %s", new Object[]{resource.getHostSn(), type.getTypeValue()});
            return Collections.emptySet();
        }
        return this.getProcessorByAppStorageInfo(resource.getDevSn(), infoSet, AppStorageInfo::getResourceId, AppStorageInfo::getVgName, AppStorageInfo::getAsmDg);
    }

    private Set<CreateSnapshotBackupCopySubProcessor> getProcessorByAppStorageInfo(String devSn, Set<AppStorageInfo> storageInfoSet, Function<AppStorageInfo, String> resourceId, Function<AppStorageInfo, String> vgName, Function<AppStorageInfo, String> asmDg) {
        return storageInfoSet.stream().map(storageInfo -> new CreateSnapshotBackupCopySubProcessor(devSn, (String)resourceId.apply((AppStorageInfo)storageInfo), (String)vgName.apply((AppStorageInfo)storageInfo), (String)asmDg.apply((AppStorageInfo)storageInfo))).collect(Collectors.toSet());
    }
}

