/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.oracle.recovery.process.DeleteLunMappingFromLunGroupSubProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupExtendUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DeleteLunMappingFromLunGroupProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(DeleteLunMappingFromLunGroupProcessor.class);

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue()) {
            this.setIsEnabled(false);
            this.setIsEditable(false);
        } else {
            this.setIsEnabled(true);
            this.setIsEditable(false);
        }
    }

    protected boolean execute(RecoveryProcessorContext context) {
        boolean isSuccess;
        if (VerifyUtil.isEmpty((Collection)this.getChildProc()) && !(isSuccess = this.createSubProcessors(context))) {
            LOGGER.error((Object)"Create OracleAdgConfigProcessor sub processor failed");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        List processors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor((List)processors);
        recoveryTemplate.process(context);
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    private boolean createSubProcessors(RecoveryProcessorContext context) {
        List allPos = DBRecoveryTools.appProtectObjectsFilter((RecoveryProcessorContext)context);
        HashSet<DeleteLunMappingFromLunGroupSubProcessor> delMappingLunSubProcessors = new HashSet<DeleteLunMappingFromLunGroupSubProcessor>();
        for (ProtectObject po : allPos) {
            Set replicaSet = ProtectGroupExtendUtil.getAllRemoteStorageReplica((ProtectGroup)po.getProtectGroup());
            String sn = ((RemoteStorageReplica)replicaSet.stream().findFirst().get()).getStorageProviderSN();
            List<DeleteLunMappingFromLunGroupSubProcessor> processorList = this.getDeleteLunMappingFromLunGroupSubProcessor(context, sn);
            delMappingLunSubProcessors.addAll(processorList);
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(delMappingLunSubProcessors);
        } else {
            this.setChildProc(delMappingLunSubProcessors);
        }
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private List<DeleteLunMappingFromLunGroupSubProcessor> getDeleteLunMappingFromLunGroupSubProcessor(RecoveryProcessorContext context, String sn) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        String deviceSn = (String)recoveryPlan.getGlobalSettings().get("PG_DISASTER_HOST");
        for (RecoverySetting setting : recoveryPlan.getRecoverySettings()) {
            if (!setting.getRecoveryPlan().getPlanId().equals(recoveryPlan.getPlanId()) || !setting.getName().equals("PG_DISASTER_HOST")) continue;
            deviceSn = setting.getValue();
            break;
        }
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        String redoLunWwns = OracleAppUtil.getAdgStandbyLogWwn(context.getProtectGroup());
        List lunList = storageService.getLunByWwn(sn, new HashSet<String>(Arrays.asList(redoLunWwns.split(","))));
        ArrayList<DeleteLunMappingFromLunGroupSubProcessor> processorList = new ArrayList<DeleteLunMappingFromLunGroupSubProcessor>();
        for (Lun lun : lunList) {
            DeleteLunMappingFromLunGroupSubProcessor processor = this.getSubProcessor(lun);
            processor.setHostOrGroupId(deviceSn);
            processorList.add(processor);
        }
        return processorList;
    }

    private DeleteLunMappingFromLunGroupSubProcessor getSubProcessor(Lun lun) {
        DeleteLunMappingFromLunGroupSubProcessor processor = new DeleteLunMappingFromLunGroupSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setDeviceId(lun.getDevSn());
        processor.setLunId(lun.getResourceId());
        processor.setLunName(lun.getName());
        processor.setLunWWN(lun.getWwn());
        return processor;
    }
}

