/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.oracle.hostagent.action.OracleAction;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Set;

public class OracleAdgConfigCleanDrillingSubProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(OracleAdgConfigCleanDrillingSubProcessor.class);
    private String poId;
    private String dbName;
    private String instanceName;
    private String instances;
    private String drHostSn;
    private String dataWwn;
    private String redoWwn;

    protected boolean execute(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Begin execute Adg CleanDrilling: dbName=%s, hostSn=%s", new Object[]{this.getDbName(), this.getDrHostSn()});
        this.updateProcessNameParams(new String[]{this.getDbName()});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        ProtectObject po = DBRecoveryTools.getProtectObjectByPoId((Set)context.getRecoveryProtectObjects(), (String)this.getPoId());
        if (VerifyUtil.isEmpty((Object)po)) {
            LOGGER.error((Object)"Not find po by poId: %s", new Object[]{this.getPoId()});
            this.updateProcessDetail("lego.err.1073947394", new String[]{this.getDbName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        OperationResult result = this.cleanDrilling(po);
        if (result.isSuccess()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        } else {
            LOGGER.error((Object)"Failed to clean drilling oracle adg, the dbName=%s.", new Object[]{this.getDbName()});
            this.updateProcessDetail(new LegoCheckedException(result.getErrorCode()));
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        }
        LOGGER.info((Object)"End execute config db udev sub processor, dbName=%s.", new Object[]{this.getDbName()});
        return true;
    }

    protected OperationResult cleanDrilling(ProtectObject po) {
        ProtectObject temp = OracleAppUtil.clone(po);
        temp.setProperty("drHostSn", (Object)this.getDrHostSn());
        temp.setProperty("DATABASES", (Object)this.getDbName());
        temp.setProperty("dataWwn", (Object)this.getDataWwn());
        temp.setProperty("redoWwn", (Object)this.getRedoWwn());
        INeMgrProtocolExtendService extendService = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend neExtend = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)extendService, (String)this.getDrHostSn());
        OracleAction oracleAction = new OracleAction(neExtend, this.getDrHostSn());
        OperationResult operationResult = new OperationResult("adg cleanDrilling", true, false, new String[0]);
        try {
            oracleAction.cleanDrilling(temp.getProps());
            LOGGER.info((Object)"Config database udev success, dbName=%s.", new Object[]{this.getDbName()});
            operationResult.setSuccess(true);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Config database udev failed:%s,%s.", new Object[]{po.getUuid(), ExceptionUtil.getErrorMessage((Throwable)e)});
            operationResult.setSuccess(false);
            operationResult.setErrorCode(String.valueOf(e.getErrorCode()));
        }
        return operationResult;
    }

    public String getPoId() {
        return this.poId;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getInstances() {
        return this.instances;
    }

    public String getDrHostSn() {
        return this.drHostSn;
    }

    public String getDataWwn() {
        return this.dataWwn;
    }

    public String getRedoWwn() {
        return this.redoWwn;
    }

    public void setPoId(String poId) {
        this.poId = poId;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setInstances(String instances) {
        this.instances = instances;
    }

    public void setDrHostSn(String drHostSn) {
        this.drHostSn = drHostSn;
    }

    public void setDataWwn(String dataWwn) {
        this.dataWwn = dataWwn;
    }

    public void setRedoWwn(String redoWwn) {
        this.redoWwn = redoWwn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OracleAdgConfigCleanDrillingSubProcessor)) {
            return false;
        }
        OracleAdgConfigCleanDrillingSubProcessor other = (OracleAdgConfigCleanDrillingSubProcessor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$poId = this.getPoId();
        String other$poId = other.getPoId();
        if (this$poId == null ? other$poId != null : !this$poId.equals(other$poId)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$instanceName = this.getInstanceName();
        String other$instanceName = other.getInstanceName();
        if (this$instanceName == null ? other$instanceName != null : !this$instanceName.equals(other$instanceName)) {
            return false;
        }
        String this$instances = this.getInstances();
        String other$instances = other.getInstances();
        if (this$instances == null ? other$instances != null : !this$instances.equals(other$instances)) {
            return false;
        }
        String this$drHostSn = this.getDrHostSn();
        String other$drHostSn = other.getDrHostSn();
        if (this$drHostSn == null ? other$drHostSn != null : !this$drHostSn.equals(other$drHostSn)) {
            return false;
        }
        String this$dataWwn = this.getDataWwn();
        String other$dataWwn = other.getDataWwn();
        if (this$dataWwn == null ? other$dataWwn != null : !this$dataWwn.equals(other$dataWwn)) {
            return false;
        }
        String this$redoWwn = this.getRedoWwn();
        String other$redoWwn = other.getRedoWwn();
        return !(this$redoWwn == null ? other$redoWwn != null : !this$redoWwn.equals(other$redoWwn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OracleAdgConfigCleanDrillingSubProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $poId = this.getPoId();
        result = result * 59 + ($poId == null ? 43 : $poId.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $instanceName = this.getInstanceName();
        result = result * 59 + ($instanceName == null ? 43 : $instanceName.hashCode());
        String $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : $instances.hashCode());
        String $drHostSn = this.getDrHostSn();
        result = result * 59 + ($drHostSn == null ? 43 : $drHostSn.hashCode());
        String $dataWwn = this.getDataWwn();
        result = result * 59 + ($dataWwn == null ? 43 : $dataWwn.hashCode());
        String $redoWwn = this.getRedoWwn();
        result = result * 59 + ($redoWwn == null ? 43 : $redoWwn.hashCode());
        return result;
    }

    public String toString() {
        return "OracleAdgConfigCleanDrillingSubProcessor(poId=" + this.getPoId() + ", dbName=" + this.getDbName() + ", instanceName=" + this.getInstanceName() + ", instances=" + this.getInstances() + ", drHostSn=" + this.getDrHostSn() + ", dataWwn=" + this.getDataWwn() + ", redoWwn=" + this.getRedoWwn() + ")";
    }
}

