/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.BaseSwapReplicationSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.ForceSwapReplicationProcessor;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.service.impl.DrmStorageServiceImpl;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OracleForceSwapReplicationProcessor
extends ForceSwapReplicationProcessor {
    private static final long serialVersionUID = -7426268818073733547L;

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue()) {
            this.setIsEnabled(false);
            this.setIsEditable(false);
        } else {
            this.setIsEnabled(true);
            this.setIsEditable(false);
        }
    }

    public boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        return super.execute(context);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected boolean updateSubProcessors(RecoveryProcessorContext context) {
        Collection recoveryTasks = (Collection)context.getAttribute(this.getRecoveryTasksKey());
        String disasterSiteId = context.getDisasterSiteId();
        Set tmpRecoveryTasks = RecoveryTaskUtil.getRecoveryTasksByDisisaterSite((Collection)recoveryTasks, (String)disasterSiteId);
        HashSet<BaseSwapReplicationSubProcessor> swapReplicationSubProcessors = new HashSet<BaseSwapReplicationSubProcessor>();
        for (RecoveryTask recoveryTask : tmpRecoveryTasks) {
            BaseSwapReplicationSubProcessor swapProcessor = this.createSwapReplicationSubProcessor(recoveryTask);
            swapReplicationSubProcessors.add(swapProcessor);
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.setChildProc(swapReplicationSubProcessors);
        } else {
            this.updateSubProcessors(swapReplicationSubProcessors);
        }
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private BaseSwapReplicationSubProcessor createSwapReplicationSubProcessor(RecoveryTask recoveryTask) {
        DrmStorageServiceImpl drmStorageService = (DrmStorageServiceImpl)ServiceLocator.getInstance().getService(DrmStorageServiceImpl.class);
        String lunId = this.getContextRef().getProtectGroup().getProperty("REMOTE_PAIR_TRGLUNIDS");
        List replicationPairs = drmStorageService.queryReplicationPairsByLunIds(recoveryTask.getSrcDeviceId(), Collections.singleton(lunId), true, false, Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
        BaseSwapReplicationSubProcessor processor = this.getSubProcessorInstance();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setReplicationId(((ReplicationPair)replicationPairs.get(0)).getReplicationId());
        processor.setSrcDeviceId(recoveryTask.getTgtDevcieId());
        processor.setTgtDeviceId(recoveryTask.getSrcDeviceId());
        processor.setRelationType(Integer.valueOf(recoveryTask.getProtectType()));
        processor.setOnlySplit(false);
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        return processor;
    }

    public void beforeExecRecoveryProcessor() {
        ProtectObject po = (ProtectObject)this.getContextRef().getProtectGroup().getPolist().stream().findFirst().get();
        IApplicationManager applicationManager = ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType());
        List appStandbyResources = applicationManager.getAppStandbyResource(po);
        ArrayList standbyHostList = new ArrayList();
        appStandbyResources.forEach(e -> standbyHostList.add(e.getHostSn()));
        this.getContextRef().setAttribute("standByHostList", (Object)String.join((CharSequence)",", standbyHostList));
        super.beforeExecRecoveryProcessor();
    }
}

