/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.oracle.recovery.process.SwitchoverOracleSubProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class SwitchoverOracleProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 9160935010197558047L;
    private static final Log LOGGER = LogFactory.getInstance(SwitchoverOracleProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        boolean isSuccess;
        if (VerifyUtil.isEmpty((Collection)this.getChildProc()) && !(isSuccess = this.createSubProcessors(context))) {
            LOGGER.error((Object)"Create switchover sub processor failed");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOGGER.error((Object)"SwitchoverOracleSubProcessor sub processors is empty.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        if (recoveryTemplate == null) {
            LOGGER.info((Object)"Not find recoveryTemplate");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        recoveryTemplate.process(context);
        boolean isExecSuccess = this.calcProcessResultBySubProc();
        if (isExecSuccess) {
            this.updatePoAfterSwitchover(context);
        }
        return isExecSuccess;
    }

    protected boolean calcProcessResultBySubProc() {
        boolean isSuccess = super.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        return isSuccess;
    }

    private void updatePoAfterSwitchover(RecoveryProcessorContext context) {
        List allPos = DBRecoveryTools.appProtectObjectsFilter((RecoveryProcessorContext)context);
        if (CollectionUtils.isEmpty((Collection)allPos)) {
            LOGGER.error((Object)"Not find po list.");
            return;
        }
        allPos.forEach(po -> po.getProps().put("HAS_SWITCHOVER", "true"));
    }

    protected boolean createSubProcessors(RecoveryProcessorContext context) {
        List allPos = DBRecoveryTools.appProtectObjectsFilter((RecoveryProcessorContext)context);
        if (CollectionUtils.isEmpty((Collection)allPos)) {
            LOGGER.error((Object)"Not find po list.");
            return false;
        }
        HashSet<SwitchoverOracleSubProcessor> switchoverSubProcessors = new HashSet<SwitchoverOracleSubProcessor>();
        for (ProtectObject po : allPos) {
            SwitchoverOracleSubProcessor processor = this.createSwitchoverSubProcessor(po);
            switchoverSubProcessors.add(processor);
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(switchoverSubProcessors);
        } else {
            this.setChildProc(switchoverSubProcessors);
        }
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private SwitchoverOracleSubProcessor createSwitchoverSubProcessor(ProtectObject po) {
        SwitchoverOracleSubProcessor processor = new SwitchoverOracleSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processor.setPoId(po.getUuid());
        processor.setDbName(po.getName());
        return processor;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        if (oldProcess == null || newProcess == null) {
            return false;
        }
        return oldProcess.getProcId().equals(newProcess.getProcId());
    }
}

