/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.recovery.process.TestConnDBSubProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TestConnOracleRACAppSubProcessor
extends TestConnDBSubProcessor {
    private static final long serialVersionUID = 1352094696231991228L;
    private static final int MAX_HOST = 8;
    private String successHosts = null;
    private String failedHosts = null;

    public String getSuccessHosts() {
        return this.successHosts;
    }

    public void setSuccessHosts(String successHosts) {
        this.successHosts = successHosts;
    }

    public String getFailedHosts() {
        return this.failedHosts;
    }

    public void setFailedHosts(String failedHosts) {
        this.failedHosts = failedHosts;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean execute(RecoveryProcessorContext context) {
        if (null == context) {
            LOGGER.info((Object)"context is null.", 90160758787071L);
            return false;
        }
        String dbName = this.getDbName();
        LOGGER.debug((Object)("begin to execute test oracle rac sub processor,dbName:" + dbName), 90160758786816L);
        this.updateProcessNameParams(new String[]{dbName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessNameParams(new String[]{dbName});
            this.updateProcessDetail("ism.drm.recovery.database.already.started", new String[]{super.getDbName()});
            LOGGER.info((Object)("database instance has been started succ, dbName=" + super.getDbName()), -1L);
            return true;
        }
        HashSet<DrResource> hostsOfRecovery = new HashSet<DrResource>(8);
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        String resourceSn = this.getDisasterHostSn(recoveryPlan);
        DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(resourceSn);
        int clusterType = -1;
        if (resource instanceof DrHostGroup) {
            hostsOfRecovery.addAll(resource.getChildResources());
            clusterType = ((DrHostGroup)resource).getClusterType();
        } else if (resource instanceof DrHost) {
            hostsOfRecovery.add(resource);
        }
        OracleAppUtil.filterHasSuccHosts(hostsOfRecovery, this.successHosts, this.getProcType());
        Set posWithRp = this.getAllPOsByInstanceName(context);
        ProtectObject currentPo = OracleAppUtil.findPoById(posWithRp, this.getPoId());
        if (currentPo == null) {
            LOGGER.info((Object)"The currentPo is null.");
            return false;
        }
        ProtectGroup pg = context.getProtectGroup();
        this.testDBStart(dbName, hostsOfRecovery, clusterType, currentPo, pg);
        return true;
    }

    private void testDBStart(String dbName, Set<DrResource> hostsOfRecovery, int clusterType, ProtectObject currentPo, ProtectGroup pg) {
        Set<String> failedHostsSbOfThisTime = this.getFailedHostsSbOfThisTime();
        ProtectObject parm = this.getPoForTestDB(currentPo);
        this.testDBStartWithHosts(hostsOfRecovery, parm, failedHostsSbOfThisTime, clusterType, pg);
        int succCount = 0;
        int failedCount = this.getFailedDbCount(failedHostsSbOfThisTime);
        if (this.successHosts != null) {
            succCount = this.successHosts.split(",").length;
        }
        this.setProcResult(dbName, failedCount, succCount, hostsOfRecovery.size(), clusterType);
    }

    private int getFailedDbCount(Set<String> failedHostsSbOfThisTime) {
        int failedCount = 0;
        int countOfFailed = failedHostsSbOfThisTime.size();
        if (0 == countOfFailed) {
            this.setFailedHosts(null);
        } else {
            StringBuffer hostIPSB = new StringBuffer();
            int index = 0;
            for (String hostIP : failedHostsSbOfThisTime) {
                hostIPSB.append(hostIP);
                if (index != countOfFailed - 1) {
                    hostIPSB.append(',');
                }
                ++index;
            }
            this.setFailedHosts(hostIPSB.toString());
            failedCount = countOfFailed;
        }
        return failedCount;
    }

    private Set<String> getFailedHostsSbOfThisTime() {
        HashSet<String> failedHostsSbOfThisTime;
        if (null != this.failedHosts) {
            String[] ipArray = this.failedHosts.split(",");
            failedHostsSbOfThisTime = new HashSet(ipArray.length);
            for (String ip : ipArray) {
                failedHostsSbOfThisTime.add(ip);
            }
        } else {
            failedHostsSbOfThisTime = new HashSet<String>(8);
        }
        return failedHostsSbOfThisTime;
    }

    private void testDBStartWithHosts(Set<DrResource> hostsOfHostGroup, ProtectObject currentPo, Set<String> failedHostsSbOfThisTime, int clusterType, ProtectGroup pg) {
        for (DrResource res : hostsOfHostGroup) {
            ProtectObject clonePo = this.getTestProtectObject(currentPo, pg, res);
            String hostSn = res.getDeviceSn();
            clonePo.setProviderSN(hostSn);
            if (clusterType == DrmAppEnumDefine.CLUSTER_TYPE_E.ORACLE_RAC.getValue()) {
                clonePo.getProps().put("OPER_TYPE", String.valueOf(0));
            }
            this.setTestDBStartResult(failedHostsSbOfThisTime, res.getIpAddress(), clonePo);
            if (clusterType == DrmAppEnumDefine.CLUSTER_TYPE_E.ORACLE_RAC.getValue() || clusterType == -1 || VerifyUtil.isEmpty((String)this.successHosts)) continue;
            LOGGER.info((Object)"Start database successful, cluster type: %s, hostSn:%s", new Object[]{clusterType, hostSn});
            break;
        }
    }

    private ProtectObject getTestProtectObject(ProtectObject currentPo, ProtectGroup pg, DrResource res) {
        ProtectObject clonePo;
        if (pg.getTemplate().getType() == 47 && this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue()) {
            ProtectObject tmp = OracleAppUtil.clone(currentPo);
            tmp.setProviderSN(res.getDeviceSn());
            OracleAppUtil.updatePoPropsWithStandbyAfterSwitchover(tmp);
            clonePo = tmp;
        } else {
            clonePo = currentPo;
        }
        return clonePo;
    }

    private void setTestDBStartResult(Set<String> failedHostsSbOfThisTime, String resIP, ProtectObject clonePo) {
        if (this.isDBStartup(clonePo)) {
            this.successHosts = OracleAppUtil.getResult(resIP, this.successHosts);
            if (failedHostsSbOfThisTime.contains(resIP)) {
                failedHostsSbOfThisTime.remove(resIP);
            }
        } else {
            LOGGER.error((Object)("failed to test the dbName[" + clonePo.getName() + "] in host:" + resIP), 90160758787071L);
            if (!failedHostsSbOfThisTime.contains(resIP)) {
                failedHostsSbOfThisTime.add(resIP);
            }
        }
    }

    private void setProcResult(String dbName, int failedCount, int succCount, int hostCountInHostGroup, int clusterType) {
        this.updateProcessNameParams(new String[]{dbName});
        if (failedCount == hostCountInHostGroup) {
            this.updateProcessDetail("ism.drm.recovery.database.test.failed", new String[]{dbName});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else if (succCount == hostCountInHostGroup) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        } else if (succCount > 0 && clusterType != DrmAppEnumDefine.CLUSTER_TYPE_E.ORACLE_RAC.getValue()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        } else {
            String[] hosts = new String[]{this.successHosts, this.failedHosts};
            this.updateProcessDetail("ism.drm.recovery.database.test.partsucc", hosts);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue());
        }
    }

    private String getDisasterHostSn(RecoveryPlan recoveryPlan) {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue()) {
            Iterator pgIter = recoveryPlan.getProtectGroups().iterator();
            if (!pgIter.hasNext()) {
                throw new LegoCheckedException(1073947393L);
            }
            ProtectGroup pg = (ProtectGroup)pgIter.next();
            if (null != pg) {
                return pg.getPoProviderSN();
            }
            return null;
        }
        String deviceSn = (String)recoveryPlan.getGlobalSettings().get("PG_DISASTER_HOST");
        for (RecoverySetting setting : recoveryPlan.getRecoverySettings()) {
            if (!setting.getRecoveryPlan().getPlanId().equals(recoveryPlan.getPlanId()) || !setting.getName().equals("PG_DISASTER_HOST")) continue;
            deviceSn = setting.getValue();
            break;
        }
        return deviceSn;
    }

    protected ProtectObject getPoForTestDB(ProtectObject po) {
        return po;
    }
}

