/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.topology;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.application.model.AppStorageInfo;
import com.huawei.ism.drm.application.model.ApplicationResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.db.topology.DataBaseTopoBuilder;
import com.huawei.ism.drm.db.util.DatabaseApplicationUtil;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.topology.element.DBElement;
import com.huawei.ism.drm.host.topology.element.DBInstanceElement;
import com.huawei.ism.drm.host.topology.element.DeviceElement;
import com.huawei.ism.drm.host.topology.element.DiskElement;
import com.huawei.ism.drm.host.topology.element.DiskGroupElement;
import com.huawei.ism.drm.host.topology.element.HostElement;
import com.huawei.ism.drm.host.topology.skin.HostGroupSkin;
import com.huawei.ism.drm.host.topology.skin.HostSkin;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.topo.element.SiteElement;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.twaver.Skin;
import com.huawei.ism.drm.topo.twaver.TopoElement;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.twaver.IData;
import com.huawei.twaver.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:ProtectGroup-1")
public class OracleTopoBuilder
extends DataBaseTopoBuilder {
    private static final Log LOGGER = LogFactory.getInstance(OracleTopoBuilder.class);
    private static final String APP_TYPE_LABEL = "Oracle";
    private static final String ISPRIMARY = "isPrimary";
    private static final String ISRAC = "isRac";
    private static final String SITE = "site";
    private static final String SITE_A_OR_B = "SITE_A_OR_B";
    private static final String SITE_A = "SITE_A";
    private static final String SITE_B = "SITE_B";
    private static final String REDO = "REDO";

    public void buildTopo(TopoBaseContext context) {
        if (context == null) {
            LOGGER.error((Object)"context is null.", 90160758786989L);
            return;
        }
        this.initialize(context);
        ProtectGroup protectGroup = context.getProtectGroup();
        String hostSN = protectGroup.getPoProviderSN();
        DrResource resource = this.getDrResource(hostSN);
        if (resource == null) {
            return;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(SITE_A_OR_B, SITE_A);
        this.checkRac(resource, dataMap);
        dataMap.put(ISPRIMARY, protectGroup.isPrimary());
        String productSiteId = protectGroup.getProductSiteId();
        Site productSite = context.getSiteService().getSiteById(productSiteId);
        dataMap.put(SITE, productSite);
        int type = protectGroup.getTemplate().getType();
        if (this.getSanActiveTemplateTypes().contains(type) || PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(type) && ProtectionJobUtil.isHyperMetroInFirstSite((ProtectGroup)context.getProtectGroup())) {
            this.buildDoubleActiveTopo(context, resource, APP_TYPE_LABEL, dataMap);
            return;
        }
        SiteElement productSiteNode = new SiteElement(productSite);
        context.addChild((IData)context.getRootNode(), (IData)productSiteNode);
        this.setTopoHostInfo(context, resource, dataMap, (Node)productSiteNode);
        if (type == 47) {
            this.buildSiteBTopo(context, protectGroup);
        }
    }

    private void buildSiteBTopo(TopoBaseContext context, ProtectGroup protectGroup) {
        HashMap<String, Object> dataMapB = new HashMap<String, Object>();
        ProtectGroupReplica protectGroupReplica = (ProtectGroupReplica)protectGroup.getReplicaList().iterator().next();
        Site siteB = context.getSiteService().getSiteById(protectGroupReplica.getRecoverySite());
        dataMapB.put(SITE_A_OR_B, SITE_B);
        dataMapB.put(SITE, siteB);
        dataMapB.put(ISPRIMARY, protectGroup.isPrimary());
        SiteElement siteBNode = new SiteElement(siteB);
        context.addChild((IData)context.getRootNode(), (IData)siteBNode);
        this.buildSiteBHostsTopo(context, (Node)siteBNode, APP_TYPE_LABEL, dataMapB);
    }

    private void setTopoHostInfo(TopoBaseContext context, DrResource resource, Map<String, Object> dataMap, Node siteNode) {
        if (resource instanceof DrHost) {
            this.buildHostTopo(context, (DrHost)resource, siteNode, APP_TYPE_LABEL, true, dataMap);
        } else if (resource instanceof DrHostGroup) {
            DrHostGroup hostGroupInfo = (DrHostGroup)resource;
            String hostKey = hostGroupInfo.getDeviceSn() + ":hostStyleNode";
            TopoElement hostStyleNode = new TopoElement((Object)hostKey).use(new Skin[]{new HostSkin()});
            context.addChild((IData)siteNode, (IData)hostStyleNode);
            String hostGroupKey = hostGroupInfo.getDeviceSn() + ":hostGroup";
            TopoElement hostGroupStyleNode = new TopoElement((Object)hostGroupKey).use(new Skin[]{new HostGroupSkin()});
            context.addChild((IData)hostStyleNode, (IData)hostGroupStyleNode);
            Set drHosts = hostGroupInfo.getChildResources();
            for (DrResource eHost : drHosts) {
                dataMap.put("isOracle", true);
                this.buildHostTopo(context, (DrHost)eHost, (Node)hostGroupStyleNode, APP_TYPE_LABEL, null, dataMap);
            }
        }
    }

    protected void buildSiteBHostsTopo(TopoBaseContext context, Node root, String type, Map<String, Object> dataMap) {
        ProtectObject po = (ProtectObject)context.getProtectGroup().getPolist().iterator().next();
        IApplicationManager applicationManager = ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType());
        try {
            LOGGER.debug((Object)"Begin check adg status at %s.", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
            applicationManager.checkEnvStatus(po);
            LOGGER.debug((Object)"End check adg status at %s.", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"The adg status is invalid at %s", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
            return;
        }
        List appStandbyResource = applicationManager.getAppStandbyResource(po);
        if (VerifyUtil.isEmpty((Collection)appStandbyResource)) {
            LOGGER.error((Object)"%s has no data in siteB.", new Object[]{context.getProtectGroup().getName()});
            return;
        }
        this.updateProps(context, appStandbyResource);
        if (VerifyUtil.isEmpty((Collection)appStandbyResource)) {
            return;
        }
        DrResource childResource = this.getDrResource(((ApplicationResource)appStandbyResource.get(0)).getHostSn());
        if (childResource.getParentDrResource() == null) {
            appStandbyResource.forEach(appResource -> this.buildSiteBHostTopo(context, (ApplicationResource)appResource, root, dataMap));
        }
        if (!(childResource.getParentDrResource() instanceof DrHostGroup)) {
            return;
        }
        this.buildsiteBhostGroupTopo(context, appStandbyResource, root, type, dataMap);
    }

    private void updateProps(TopoBaseContext context, List<ApplicationResource> appStandbyResource) {
        String devSn = appStandbyResource.get(0).getDevSn();
        List lunIdList = appStandbyResource.get(0).getAppStorageInfos().stream().map(AppStorageInfo::getResourceId).collect(Collectors.toList());
        List pairs = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getReplicationPairsByResourceIds(devSn, lunIdList, Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
        ArrayList srcLunIds = new ArrayList();
        ArrayList trgLunIds = new ArrayList();
        pairs.forEach(pair -> {
            srcLunIds.add(pair.getSrcLunId());
            trgLunIds.add(pair.getTgtLunId());
        });
        context.getProtectGroup().getProps().put("REMOTE_PAIR_SRCLUNIDS", String.join((CharSequence)",", srcLunIds));
        context.getProtectGroup().getProps().put("REMOTE_PAIR_TRGLUNIDS", String.join((CharSequence)",", trgLunIds));
    }

    private void buildsiteBhostGroupTopo(TopoBaseContext context, List<ApplicationResource> appStandbyResource, Node root, String type, Map<String, Object> dataMap) {
        DrResource childResource = this.getDrResource(appStandbyResource.get(0).getHostSn());
        DrHostGroup hostGroupInfo = null;
        if (childResource.getParentDrResource() instanceof DrHostGroup) {
            hostGroupInfo = (DrHostGroup)childResource.getParentDrResource();
        }
        if (hostGroupInfo == null) {
            return;
        }
        String hostKey = hostGroupInfo.getDeviceSn() + ":hostStyleNode";
        TopoElement hostStyleNode = new TopoElement((Object)hostKey).use(new Skin[]{new HostSkin()});
        context.addChild((IData)root, (IData)hostStyleNode);
        String hostGroupKey = hostGroupInfo.getDeviceSn() + ":hostGroup";
        TopoElement hostGroupStyleNode = new TopoElement((Object)hostGroupKey).use(new Skin[]{new HostGroupSkin()});
        context.addChild((IData)hostStyleNode, (IData)hostGroupStyleNode);
        for (ApplicationResource applicationResource : appStandbyResource) {
            DrResource resource = this.getDrResource(applicationResource.getHostSn());
            if (resource == null || !(resource instanceof DrHost)) continue;
            Node hostNode = (Node)context.addChild((IData)hostGroupStyleNode, (IData)new HostElement((DrHost)resource));
            Node poStyleNode = TopoServiceUtil.createProtectObjStyleNode((TopoBaseContext)context, (String)type, (String)(applicationResource.getHostSn() + context.getType()));
            context.addChild((IData)hostNode, (IData)poStyleNode);
            Node asmStyleNode = TopoServiceUtil.createDiskGroupStyleNode((TopoBaseContext)context, (String)applicationResource.getHostSn());
            context.addChild((IData)hostNode, (IData)asmStyleNode);
            String dbName = (String)applicationResource.getExtendParams().get("STANDBY_DB_NAME");
            List databases = DatabaseApplicationUtil.queryAllDatabaseInstances((String)applicationResource.getHostSn(), (int)1, new HashMap());
            if (VerifyUtil.isEmpty((Collection)databases)) continue;
            String dbInstanceName = ((DatabaseInstance)databases.get(0)).getInstanceName();
            boolean isDbStatusRight = this.isDatabaseOnline(applicationResource.getHostSn(), dbName, dataMap);
            Node poNode = (Node)context.addChild((IData)poStyleNode, (IData)new DBInstanceElement(null, dbInstanceName, isDbStatusRight));
            applicationResource.getAppStorageInfos().forEach(appStorageInfo -> {
                String id = this.buildHostStorageTopoSiteB(context, applicationResource.getHostSn(), hostNode, (AppStorageInfo)appStorageInfo);
                context.linkTo(poNode, (Object)id, new Skin[0]);
            });
        }
    }

    private void buildSiteBHostTopo(TopoBaseContext context, ApplicationResource appResource, Node root, Map<String, Object> dataMap) {
        ProtectGroup protectGroup = context.getProtectGroup();
        String hostSN = appResource.getHostSn();
        DrResource drResource = this.getDrResource(hostSN);
        if (!(drResource instanceof DrHost)) {
            return;
        }
        Node hostNode = (Node)context.addChild((IData)root, (IData)new HostElement((DrHost)drResource));
        Node poStyleNode = TopoServiceUtil.createProtectObjStyleNode((TopoBaseContext)context, (String)APP_TYPE_LABEL, (String)(hostSN + context.getType()));
        context.addChild((IData)hostNode, (IData)poStyleNode);
        Set poSet = protectGroup.getPolist();
        Node asmStyleNode = TopoServiceUtil.createDiskGroupStyleNode((TopoBaseContext)context, (String)hostSN);
        context.addChild((IData)hostNode, (IData)asmStyleNode);
        String dbName = (String)appResource.getExtendParams().get("STANDBY_DB_NAME");
        boolean isDbStatusRight = this.isDatabaseOnline(hostSN, dbName, dataMap);
        Node poNode = (Node)context.addChild((IData)poStyleNode, (IData)new DBElement(null, dbName, isDbStatusRight));
        appResource.getAppStorageInfos().forEach(appStorageInfo -> {
            String id = this.buildHostStorageTopoSiteB(context, hostSN, hostNode, (AppStorageInfo)appStorageInfo);
            context.linkTo(poNode, (Object)id, new Skin[0]);
        });
    }

    protected String buildHostStorageTopoSiteB(TopoBaseContext context, String hostSN, Node fatherNode, ProtectObjectStorageInfo hostStorageInfo, List<String> siteIds) {
        String id = hostSN + hostStorageInfo.getDeviceName();
        DeviceElement node = new DeviceElement((Object)id, hostStorageInfo.getDeviceName());
        this.buildAsmTopo(context, hostSN, fatherNode, hostStorageInfo, id);
        this.createDeviceTopo(context, hostSN, fatherNode, (Node)node, hostStorageInfo);
        this.createDiskTopoSiteB(context, hostSN, fatherNode, hostStorageInfo, siteIds);
        id = hostSN + ":diskGroup:" + hostStorageInfo.getAsmDiskGroupName();
        return id;
    }

    protected String buildHostStorageTopoSiteB(TopoBaseContext context, String hostSN, Node fatherNode, AppStorageInfo appStorageInfo) {
        String deviceName = appStorageInfo.getDeviceName();
        String id = hostSN + deviceName;
        DeviceElement node = new DeviceElement((Object)id, deviceName);
        this.buildAsmTopo(context, hostSN, fatherNode, appStorageInfo, id);
        this.createDeviceTopo(context, hostSN, fatherNode, (Node)node, appStorageInfo);
        this.createDiskTopoSiteB(context, hostSN, fatherNode, appStorageInfo, null);
        id = hostSN + ":diskGroup:" + appStorageInfo.getAsmDg();
        return id;
    }

    protected void createDeviceTopo(TopoBaseContext context, String hostSN, Node fatherNode, Node deviceNode, AppStorageInfo appStorageInfo) {
        Node deviceStyleNode = TopoServiceUtil.createDeviceStyleNode((TopoBaseContext)context, (String)hostSN);
        context.addChild((IData)fatherNode, (IData)deviceStyleNode);
        context.addChild((IData)deviceStyleNode, (IData)deviceNode);
        context.linkTo(deviceNode, (Object)(hostSN + "Disk" + appStorageInfo.getResourceId()), new Skin[0]);
    }

    protected void buildAsmTopo(TopoBaseContext context, String hostSN, Node fatherNode, AppStorageInfo appStorageInfo, String hostId) {
        Node asmStyleNode = TopoServiceUtil.createDiskGroupStyleNode((TopoBaseContext)context, (String)hostSN);
        context.addChild((IData)fatherNode, (IData)asmStyleNode);
        String id = hostSN + ":diskGroup:" + appStorageInfo.getAsmDg();
        Node asmNode = null;
        if (context.getElementBox().getElementByID((Object)id) instanceof Node) {
            asmNode = (Node)context.getElementBox().getElementByID((Object)id);
        }
        if (asmNode == null) {
            asmNode = new DiskGroupElement((Object)id, appStorageInfo.getAsmDg());
            asmNode = (Node)context.addChild((IData)asmStyleNode, (IData)asmNode);
        }
        context.linkTo(asmNode, (Object)hostId, new Skin[0]);
    }

    protected void createDiskTopoSiteB(TopoBaseContext context, String hostSN, Node fatherNode, ProtectObjectStorageInfo hostStorageInfo, List<String> siteIds) {
        Node diskStyleNode = TopoServiceUtil.createDiskStyleNode((TopoBaseContext)context, (String)hostSN);
        context.addChild((IData)fatherNode, (IData)diskStyleNode);
        String diskID = hostSN + "Disk" + hostStorageInfo.getResourceId();
        LOGGER.info((Object)"Begin build siteB disk node: %s", new Object[]{diskID});
        DiskElement diskNode = new DiskElement((Object)diskID);
        context.addChild((IData)diskStyleNode, (IData)diskNode);
        String srcSN = ((ProtectGroupReplica)context.getProtectGroup().getReplicaList().iterator().next()).getProductArray();
        if (REDO.equals(hostStorageInfo.getAsmDiskGroupName())) {
            String trgSN = ((ProtectGroupReplica)context.getProtectGroup().getReplicaList().iterator().next()).getRecoveryArray();
            List<String> resourceIds = Arrays.asList(((String)context.getProtectGroup().getProps().get("REMOTE_PAIR_SRCLUNIDS")).split(","));
            resourceIds.forEach(arg_0 -> this.lambda$createDiskTopoSiteB$4(trgSN, context, (Node)diskNode, arg_0));
        }
    }

    protected void createDiskTopoSiteB(TopoBaseContext context, String hostSN, Node fatherNode, AppStorageInfo appStorageInfo, List<String> siteIds) {
        Node diskStyleNode = TopoServiceUtil.createDiskStyleNode((TopoBaseContext)context, (String)hostSN);
        context.addChild((IData)fatherNode, (IData)diskStyleNode);
        String diskID = hostSN + "Disk" + appStorageInfo.getResourceId();
        LOGGER.info((Object)"Begin build siteB disk node: %s", new Object[]{diskID});
        DiskElement diskNode = new DiskElement((Object)diskID);
        context.addChild((IData)diskStyleNode, (IData)diskNode);
        String srcSN = ((ProtectGroupReplica)context.getProtectGroup().getReplicaList().iterator().next()).getProductArray();
        if (REDO.equals(appStorageInfo.getAsmDg())) {
            String trgSN = ((ProtectGroupReplica)context.getProtectGroup().getReplicaList().iterator().next()).getRecoveryArray();
            List<String> resourceIds = Arrays.asList(((String)context.getProtectGroup().getProps().get("REMOTE_PAIR_SRCLUNIDS")).split(","));
            resourceIds.forEach(arg_0 -> this.lambda$createDiskTopoSiteB$5(appStorageInfo, trgSN, context, (Node)diskNode, arg_0));
        }
    }

    private void checkRac(DrResource resource, Map<String, Object> dataMap) {
        boolean isRac = false;
        if (resource instanceof DrHostGroup) {
            DrHostGroup hostGroup = (DrHostGroup)resource;
            isRac = hostGroup.getClusterType() == DrmAppEnumDefine.CLUSTER_TYPE_E.ORACLE_RAC.getValue();
        }
        dataMap.put(ISRAC, isRac);
    }

    protected boolean getDatabaseStatus(String hostSN, ProtectObject po, Map<String, Object> dataMap) {
        try {
            OracleAppUtil.checkOneInstanceStatus(po, hostSN);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Oracle ADG status is not matched, hostSn:%s", new Object[]{hostSN});
            return false;
        }
        return true;
    }

    private boolean isDatabaseOnline(String hostSN, String databaseName, Map<String, Object> dataMap) {
        return this.getLocalDataBaseStatus(hostSN, databaseName, 1);
    }

    protected Node getPoNode(TopoBaseContext context, Node poStyleNode, ProtectObject po, Node hostNode, boolean dbStatus, Map<String, Object> dataMap) {
        Node poNode;
        boolean isRac = (Boolean)dataMap.get(ISRAC);
        if (isRac) {
            String racAppName = (String)po.getProps().get("INSTANCENAME");
            Map hostAppNameMap = this.getHostAndAppMap(racAppName);
            String name = po.getName();
            if (hostAppNameMap != null) {
                name = (String)hostAppNameMap.get(hostNode.getID());
            }
            poNode = (Node)context.addChild((IData)poStyleNode, (IData)new DBInstanceElement(null, name, dbStatus));
        } else {
            String name = po.getName();
            poNode = (Node)context.addChild((IData)poStyleNode, (IData)new DBElement(null, name, dbStatus));
        }
        return poNode;
    }

    public String getTopoType() {
        return "ProtectGroup-1";
    }

    private List<String> convertToLunIdsList(String lunIds) {
        if (VerifyUtil.isEmpty((String)lunIds)) {
            LOGGER.warn((Object)"lunIds is empty");
            return Collections.emptyList();
        }
        try {
            LOGGER.info((Object)"Bgein get lunIds from props.");
            JSONArray jsonArray = JSONArray.fromObject((Object)lunIds);
            return JSONArray.toCollection((JSONArray)jsonArray, String.class);
        }
        catch (LegoCheckedException e) {
            return Collections.singletonList(lunIds);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to convert cgUuids to array", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$createDiskTopoSiteB$5(AppStorageInfo appStorageInfo, String trgSN, TopoBaseContext context, Node diskNode, String resourceId) {
        if (appStorageInfo.getResourceId().equals(resourceId)) {
            String lunNodeId = trgSN + resourceId;
            this.linkDiskNodeToLun(context, diskNode, lunNodeId, null);
        }
    }

    private /* synthetic */ void lambda$createDiskTopoSiteB$4(String trgSN, TopoBaseContext context, Node diskNode, String resourceId) {
        String lunNodeId = trgSN + resourceId;
        this.linkDiskNodeToLun(context, diskNode, lunNodeId, null);
    }
}

