/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.execute.process;

import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.BackupInstanceInfo;
import com.huawei.ism.drm.kube.sdk.model.KubeBackupJob;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.sdk.utils.KubeResourceNameGenerator;
import com.huawei.ism.drm.kube.service.IKubeService;
import com.huawei.ism.drm.kube.service.impl.KubeServiceImpl;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PreCDRBackupAction
extends AbstractBaseProtectAction {
    private static final Log LOGGER = LogFactory.getInstance(PreCDRBackupAction.class);

    public boolean doExecute(ActionContext context) {
        String srcSn;
        KubeServiceImpl kubeService;
        boolean isLocalCDRStatusNormal;
        ProtectGroup protectGroup = null;
        if (context.getObject("PG_ENTITY") instanceof ProtectGroup) {
            protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        }
        if (!(isLocalCDRStatusNormal = (kubeService = new KubeServiceImpl()).checkCDRStatusBySN(srcSn = protectGroup.getPoProviderSN()))) {
            LOGGER.error((Object)"Can not link to CDR. IsLocalCDRStatusNormal:%s.", new Object[]{isLocalCDRStatusNormal});
            this.setDetail("lego.err.1073947737");
            return false;
        }
        String backupInstanceName = (String)protectGroup.getProps().get("kube_backup_instance");
        IKubeHandler kubeHandler = PreCDRBackupAction.getKubeHandler();
        List infos = kubeHandler.getBackupInstanceInfos(srcSn).stream().filter(info -> info.getName().equals(backupInstanceName)).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(infos)) {
            LOGGER.error((Object)"BackupInstance %s is not exist.", new Object[]{backupInstanceName});
            this.setDetail("lego.err.2117645");
            return false;
        }
        BackupInstanceInfo info2 = (BackupInstanceInfo)infos.iterator().next();
        if (!KubeEnumDefine.BackupInstanceStatus.NORMAL.getValue().equals(info2.getStatus()) && !KubeEnumDefine.BackupInstanceStatus.BACKUPING.getValue().equals(info2.getStatus())) {
            LOGGER.error((Object)"BackupInstance %s status is: %s.", new Object[]{backupInstanceName, info2.getStatus()});
            this.setDetail("lego.err.1073947754");
            this.setDetailParams(this.constructParams(new String[]{info2.getName(), info2.getStatus()}));
            return false;
        }
        context.addObject("backup_instance", (Object)info2);
        KubeBackupJob kubeBackupJob = this.checkOrGetKubeBackupJob(context, protectGroup, backupInstanceName, kubeHandler);
        PreCDRBackupAction.getKubeService().saveBackupJob(kubeBackupJob);
        return true;
    }

    private KubeBackupJob checkOrGetKubeBackupJob(ActionContext context, ProtectGroup protectGroup, String backupInstanceName, IKubeHandler kubeHandler) {
        KubeBackupJob kubeBackupJob;
        Map executeParameter = (Map)context.getObject("EXCUTE_PARAMETER_MAP", Map.class);
        Object backupJobObj = executeParameter.get("backupJob");
        if (VerifyUtil.isEmpty(backupJobObj)) {
            kubeBackupJob = new KubeBackupJob();
            kubeBackupJob.setName(KubeResourceNameGenerator.generate());
            kubeBackupJob.setBackupInstanceName(backupInstanceName);
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("bcm-backupjob", String.valueOf(System.currentTimeMillis()));
            kubeBackupJob.setLabels(labels);
            kubeHandler.createBackupJob(protectGroup.getPoProviderSN(), kubeBackupJob);
        } else {
            if (!(backupJobObj instanceof KubeBackupJob)) {
                throw new LegoCheckedException(1073947393L);
            }
            kubeBackupJob = (KubeBackupJob)backupJobObj;
        }
        context.addObject("backupJob", (Object)kubeBackupJob);
        return kubeBackupJob;
    }

    private static IKubeHandler getKubeHandler() {
        return (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
    }

    private static IKubeService getKubeService() {
        return (IKubeService)ServiceLocator.getInstance().getService(IKubeService.class);
    }
}

