/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.license;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.license.sdk.ILicenseUseInter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collections;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Session;

public class KubeLicenseUseInter
implements ILicenseUseInter {
    private static final Log logger = LogFactory.getInstance(KubeLicenseUseInter.class);

    public int getUseCount() {
        int n;
        Session session = null;
        try {
            session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            CriteriaBuilder crb = session.getCriteriaBuilder();
            CriteriaQuery crq = crb.createQuery(ProtectObject.class);
            Root root = crq.from(ProtectObject.class);
            Path path = root.get("poType");
            CriteriaBuilder.In in = crb.in((Expression)path);
            in.value((Object)21);
            in.value((Object)20);
            List<Predicate> predicates = Collections.singletonList(crb.and(new Predicate[]{in}));
            List protectObjects = session.createQuery(crq.select((Selection)root).where(predicates.toArray(new Predicate[0]))).getResultList();
            double used = 0.0;
            for (ProtectObject po : protectObjects) {
                used += NumberUtil.convertToDouble((Object)po.getProps().getOrDefault("capacity", "0")).doubleValue();
            }
            n = new Double(used).intValue();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"Get kube license used count failed, error info: %s", (Throwable)e);
                throw new LegoCheckedException(-1L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return n;
    }

    public String getType() {
        return "BOMBCMREPSWTB";
    }
}

