/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.msg;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.kube.sdk.model.KubernetesNE;
import com.huawei.ism.drm.kube.sdk.model.ResourceSetInfo;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

public class KubeMessageSubscriber
extends MessageTaskManager {
    private static final Log LOGGER = LogFactory.getInstance(KubeMessageSubscriber.class);

    public KubeMessageSubscriber(IMessageCenter msgCenter) {
        msgCenter.addSubscriberTo((MessageTaskManager)this);
    }

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)1);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(105L);
        return mrs;
    }

    public void onMessage(MessageUnit mu) {
        long msgType = mu.getCmdcode();
        if (msgType != 105L) {
            LOGGER.error((Object)"Message was not subscribed, msgType: %s", new Object[]{String.valueOf(msgType)});
            return;
        }
        Object msg = mu.getObj();
        if (!(msg instanceof Map)) {
            return;
        }
        Map msgMap = (Map)msg;
        for (Object obj : msgMap.values()) {
            if (!(obj instanceof KubernetesNE)) {
                LOGGER.error((Object)"Not get the right obj class: %s", new Object[]{obj.getClass().getName()});
                continue;
            }
            KubernetesNE kube = (KubernetesNE)obj;
            this.deleteDrKubernetesResource(kube);
            this.restoreKubeResourceAlarm(kube);
            this.restoreLicenseAlarm();
        }
    }

    private void deleteDrKubernetesResource(KubernetesNE kube) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        try {
            DrResource drResource = resourceService.getDrResourceBySnInLocalSite(kube.getSn(), "ism.drm.deviceType.container.mainType");
            if (drResource == null) {
                LOGGER.error((Object)"DrResource is null, devSn=%s, serviceIp: %s", new Object[]{kube.getSn(), kube.getIpAddress()});
                return;
            }
            String dbId = drResource.getDbId();
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)drResource);
            this.deleteKubeRelatedResource(dbId);
            LOGGER.info((Object)"Delete kube all resources success for kubeIp: %s", new Object[]{kube.getIpAddress()});
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Delete resource failed, devSn=%s, serviceIp: %s, errorMsg: %s", new Object[]{kube.getSn(), kube.getIpAddress(), ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
    }

    private void deleteKubeRelatedResource(String dbId) {
        this.deleteResourceSet(dbId);
        this.deleteKubeStorage(dbId);
    }

    private void deleteKubeStorage(String dbId) {
        DetachedCriteria criForKubeStorage = DetachedCriteria.forClass(KubeStorage.class);
        criForKubeStorage.add((Criterion)Restrictions.eq((String)"kubeId", (Object)dbId));
        List tmpKubeStorageList = CommonDAOLocator.getBaseDao().getHibernateTemplate().findByCriteria(criForKubeStorage);
        List tmpKubeStorages = tmpKubeStorageList.stream().filter(obj -> obj instanceof KubeStorage).map(obj -> (KubeStorage)obj).collect(Collectors.toList());
        LOGGER.info((Object)"Begin to delete kubeStorages for dbId: %s", new Object[]{dbId});
        CommonDAOLocator.getBaseDao().getHibernateTemplate().deleteAll(tmpKubeStorages);
    }

    private void deleteResourceSet(String dbId) {
        DetachedCriteria criForResourceSet = DetachedCriteria.forClass(ResourceSetInfo.class);
        criForResourceSet.add((Criterion)Restrictions.eq((String)"kubeId", (Object)dbId));
        List tmpResourceSetList = CommonDAOLocator.getBaseDao().getHibernateTemplate().findByCriteria(criForResourceSet);
        List tmpResourceSets = tmpResourceSetList.stream().filter(obj -> obj instanceof ResourceSetInfo).map(obj -> (ResourceSetInfo)obj).collect(Collectors.toList());
        LOGGER.info((Object)"Begin to delete resourceSet for dbId: %s", new Object[]{dbId});
        CommonDAOLocator.getBaseDao().getHibernateTemplate().deleteAll(tmpResourceSets);
    }

    private void restoreKubeResourceAlarm(KubernetesNE kubernetes) {
        String[] alarmParams = new String[]{String.valueOf(kubernetes.getMoId())};
        AlarmReporter.restoreAlarm((String)"0x00080322000f", (String[])alarmParams);
    }

    private void restoreLicenseAlarm() {
        try {
            ILicenseControl licenseControl = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
            licenseControl.checkLicenseRestoreAlarm();
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Restore license alarm failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
    }
}

