/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process.common;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.kube.recovery.process.BaseKubeRecoveryEventProcessor;
import com.huawei.ism.drm.kube.recovery.process.RecoveryReentrantChecker;
import com.huawei.ism.drm.kube.recovery.process.migrate.KubeRecoveryMonitorRemoteCopyProgressProcessor;
import com.huawei.ism.drm.kube.recovery.process.migrate.KubeRecoverySyncMetaDataProcessor;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeJobType;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeRecoveryJobOperation;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeRecoveryJobType;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class KubeRecoveryDisableProductCdrProtectPlanProcessor
extends BaseKubeRecoveryEventProcessor
implements RecoveryReentrantChecker {
    private static final long serialVersionUID = -4778201292947506895L;
    private static final Log LOGGER = LogFactory.getInstance(KubeRecoveryDisableProductCdrProtectPlanProcessor.class);
    private static final long CHECK_DISABLE_PAUSE_TIME = 5000L;
    private static final long CHECK_DISABLE_TIME_OUT = 300000L;

    @Override
    protected KubeRecoveryJobType getJobType() {
        return KubeRecoveryJobType.PLAN_MIGRATION;
    }

    @Override
    protected KubeJobType getJobSubType() {
        return KubeJobType.RECOVERY_JOB;
    }

    @Override
    protected KubeRecoveryJobOperation getCurrentJobOperation() {
        return KubeRecoveryJobOperation.DISABLE_PROTECTION_PLAN;
    }

    @Override
    protected String getStage() {
        return "Resources";
    }

    @Override
    protected String getStartKeyword() {
        return "";
    }

    @Override
    protected String getEndKeyword() {
        return "";
    }

    @Override
    protected boolean isProduct() {
        return true;
    }

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Start execute kube job.DeviceSn: %s, jobType: %s, jobName: %s, jobOperation: %s", new Object[]{this.getDevSn(), this.getJobType().getValue(), this.getJobName(), this.getCurrentJobOperation().getValue()});
        this.createRecoveryJob();
        boolean isDisableSuccess = this.checkDisableProtectionPlanSuccess(this.getCdrProtectPlanName());
        if (isDisableSuccess) {
            return this.success();
        }
        return this.failure();
    }

    private boolean checkDisableProtectionPlanSuccess(String kubeProtectPlanName) {
        long startTime = System.currentTimeMillis();
        while (true) {
            Optional protectionPlanOptional;
            if (!(protectionPlanOptional = KubeRecoveryDisableProductCdrProtectPlanProcessor.getKubeHandler().getProtectionPlan(this.getDevSn(), kubeProtectPlanName)).isPresent()) {
                LOGGER.error((Object)"Check disable protection plan result failed, cause target protect plan [ %s ] is not exist", new Object[]{kubeProtectPlanName});
                throw new LegoCheckedException(1073947393L);
            }
            KubeProtectionPlan protectionPlan = (KubeProtectionPlan)protectionPlanOptional.get();
            if (KubeEnumDefine.CDRProtectGroupStatus.DISABLE.equals((Object)protectionPlan.getStatus())) {
                return true;
            }
            if (System.currentTimeMillis() - startTime > 300000L) {
                LOGGER.error((Object)"Check disable protection plan result time out,target protect plan is : %s", new Object[]{kubeProtectPlanName});
                return false;
            }
            CommUtil.pauseThread((long)5000L);
        }
    }

    @Override
    protected boolean checkReprotectReentrantable(RecoveryPlan recoveryPlan) {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType()) {
            return super.checkReprotectReentrantable(recoveryPlan);
        }
        return this.checkReentrantAble(recoveryPlan);
    }

    @Override
    public List<String> getCheckProcessors() {
        return Collections.unmodifiableList(Arrays.asList(KubeRecoverySyncMetaDataProcessor.class.getName(), KubeRecoveryMonitorRemoteCopyProgressProcessor.class.getName(), KubeRecoveryDisableProductCdrProtectPlanProcessor.class.getName()));
    }

    @Override
    public DrmEnumDefine.RecoveryPlanExecuteTypeE getProcessorType() {
        return DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION;
    }
}

